/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.util;

import java.util.ArrayList;
import java.util.Iterator;

public class ChainedIterator<T>
implements Iterator<T> {
    private final Iterator<Iterator<? extends T>> _iterators;
    private Iterator<? extends T> _currItr;

    public ChainedIterator(Iterator<? extends T> ... iterators) {
        ArrayList<Iterator<? extends T>> list = new ArrayList<Iterator<? extends T>>();
        for (Iterator<? extends T> itr : iterators) {
            list.add(itr);
        }
        this._iterators = list.iterator();
    }

    @Override
    public boolean hasNext() {
        while (this._currItr == null || !this._currItr.hasNext()) {
            if (this._iterators.hasNext()) {
                this._currItr = this._iterators.next();
                continue;
            }
            return false;
        }
        return this._currItr.hasNext();
    }

    @Override
    public T next() {
        return this._currItr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

