/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.server.multiplexer;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.parseq.BaseTask;
import com.linkedin.parseq.Context;
import com.linkedin.parseq.promise.Promise;
import com.linkedin.parseq.promise.Promises;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.multiplexer.IndividualBody;
import com.linkedin.restli.common.multiplexer.IndividualRequest;
import com.linkedin.restli.internal.common.DataMapConverter;
import com.linkedin.restli.server.multiplexer.IndividualResponseException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.activation.MimeTypeParseException;

final class SyntheticRequestCreationTask
extends BaseTask<RestRequest> {
    private final RestRequest _envelopeRequest;
    private final BaseTask<IndividualRequest> _individualRequest;
    private final String _individualRequestId;

    SyntheticRequestCreationTask(String individualRequestId, RestRequest envelopeRequest, BaseTask<IndividualRequest> individualRequest) {
        this._individualRequestId = individualRequestId;
        this._envelopeRequest = envelopeRequest;
        this._individualRequest = individualRequest;
    }

    protected Promise<? extends RestRequest> run(Context context) throws Throwable {
        if (this._individualRequest.isFailed()) {
            return Promises.error((Throwable)this._individualRequest.getError());
        }
        try {
            return Promises.value((Object)SyntheticRequestCreationTask.createSyntheticRequest(this._envelopeRequest, (IndividualRequest)this._individualRequest.get()));
        }
        catch (MimeTypeParseException e) {
            return Promises.error((Throwable)new IndividualResponseException(HttpStatus.S_415_UNSUPPORTED_MEDIA_TYPE, "Unsupported media type for request id=" + this._individualRequestId, e));
        }
        catch (IOException e) {
            return Promises.error((Throwable)new IndividualResponseException(HttpStatus.S_400_BAD_REQUEST, "Invalid request body for request id=" + this._individualRequestId, e));
        }
        catch (Exception e) {
            return Promises.error((Throwable)e);
        }
    }

    private static RestRequest createSyntheticRequest(RestRequest envelopeRequest, IndividualRequest individualRequest) throws MimeTypeParseException, IOException {
        URI uri = URI.create(individualRequest.getRelativeUrl());
        ByteString entity = SyntheticRequestCreationTask.getBodyAsByteString(individualRequest);
        return ((RestRequestBuilder)((RestRequestBuilder)((RestRequestBuilder)new RestRequestBuilder(uri).setMethod(individualRequest.getMethod())).setHeaders((Map)individualRequest.getHeaders())).setCookies(envelopeRequest.getCookies())).setEntity(entity).build();
    }

    private static ByteString getBodyAsByteString(IndividualRequest individualRequest) throws MimeTypeParseException, IOException {
        IndividualBody body = individualRequest.getBody(GetMode.NULL);
        ByteString entity = ByteString.empty();
        if (body != null) {
            entity = DataMapConverter.dataMapToByteString((Map)individualRequest.getHeaders(), (DataMap)body.data());
        }
        return entity;
    }
}

