/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server.response;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.restli.common.BatchCreateIdResponse;
import com.linkedin.restli.common.CreateIdEntityStatus;
import com.linkedin.restli.common.CreateIdStatus;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.server.RoutingResult;
import com.linkedin.restli.internal.server.methods.AnyRecord;
import com.linkedin.restli.internal.server.response.BatchCreateResponseEnvelope;
import com.linkedin.restli.internal.server.response.ErrorResponseBuilder;
import com.linkedin.restli.internal.server.response.PartialRestResponse;
import com.linkedin.restli.internal.server.response.ResponseUtils;
import com.linkedin.restli.internal.server.response.RestLiResponseBuilder;
import com.linkedin.restli.internal.server.response.RestLiResponseDataImpl;
import com.linkedin.restli.internal.server.util.RestUtils;
import com.linkedin.restli.server.BatchCreateKVResult;
import com.linkedin.restli.server.BatchCreateResult;
import com.linkedin.restli.server.CreateKVResponse;
import com.linkedin.restli.server.CreateResponse;
import com.linkedin.restli.server.ResourceContext;
import com.linkedin.restli.server.RestLiResponseData;
import com.linkedin.restli.server.RestLiServiceException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchCreateResponseBuilder
implements RestLiResponseBuilder {
    private final ErrorResponseBuilder _errorResponseBuilder;

    public BatchCreateResponseBuilder(ErrorResponseBuilder errorResponseBuilder) {
        this._errorResponseBuilder = errorResponseBuilder;
    }

    @Override
    public PartialRestResponse buildResponse(RoutingResult routingResult, RestLiResponseData responseData) {
        List<BatchCreateResponseEnvelope.CollectionCreateResponseItem> collectionCreateResponses = responseData.getBatchCreateResponseEnvelope().getCreateResponses();
        ArrayList<Object> formattedResponses = new ArrayList<Object>(collectionCreateResponses.size());
        for (BatchCreateResponseEnvelope.CollectionCreateResponseItem response : collectionCreateResponses) {
            if (response.isErrorResponse()) {
                RestLiServiceException exception = response.getException();
                formattedResponses.add(new CreateIdStatus(exception.getStatus().getCode(), response.getId(), this._errorResponseBuilder.buildErrorResponse(exception), ProtocolVersionUtil.extractProtocolVersion(responseData.getHeaders())));
                continue;
            }
            formattedResponses.add(response.getRecord());
        }
        PartialRestResponse.Builder builder = new PartialRestResponse.Builder();
        BatchCreateIdResponse batchCreateIdResponse = new BatchCreateIdResponse(formattedResponses);
        return builder.headers(responseData.getHeaders()).cookies(responseData.getCookies()).entity((RecordTemplate)batchCreateIdResponse).build();
    }

    @Override
    public RestLiResponseData buildRestLiResponseData(RestRequest request, RoutingResult routingResult, Object result, Map<String, String> headers, List<HttpCookie> cookies) {
        if (result instanceof BatchCreateKVResult) {
            BatchCreateKVResult list = (BatchCreateKVResult)result;
            if (list.getResults() == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null List inside of a BatchCreateKVResult returned by the resource method: " + routingResult.getResourceMethod());
            }
            ArrayList<BatchCreateResponseEnvelope.CollectionCreateResponseItem> collectionCreateList = new ArrayList<BatchCreateResponseEnvelope.CollectionCreateResponseItem>(list.getResults().size());
            for (CreateKVResponse e : list.getResults()) {
                if (e == null) {
                    throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null element inside of List inside of a BatchCreateResult returned by the resource method: " + routingResult.getResourceMethod());
                }
                Object id = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(e.getId(), routingResult);
                if (e.getError() == null) {
                    ResourceContext resourceContext = routingResult.getContext();
                    DataMap entityData = e.getEntity() != null ? e.getEntity().data() : null;
                    DataMap data = RestUtils.projectFields(entityData, resourceContext.getProjectionMode(), resourceContext.getProjectionMask());
                    CreateIdEntityStatus entry = new CreateIdEntityStatus(e.getStatus().getCode(), id, (RecordTemplate)new AnyRecord(data), null, ProtocolVersionUtil.extractProtocolVersion(headers));
                    collectionCreateList.add(new BatchCreateResponseEnvelope.CollectionCreateResponseItem((CreateIdStatus)entry));
                    continue;
                }
                collectionCreateList.add(new BatchCreateResponseEnvelope.CollectionCreateResponseItem(e.getError(), id));
            }
            RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(HttpStatus.S_200_OK, headers, cookies);
            responseData.setResponseEnvelope(new BatchCreateResponseEnvelope(collectionCreateList, true, responseData));
            return responseData;
        }
        BatchCreateResult list = (BatchCreateResult)result;
        if (list.getResults() == null) {
            throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null List inside of a BatchCreateResult returned by the resource method: " + routingResult.getResourceMethod());
        }
        ArrayList<BatchCreateResponseEnvelope.CollectionCreateResponseItem> collectionCreateList = new ArrayList<BatchCreateResponseEnvelope.CollectionCreateResponseItem>(list.getResults().size());
        for (CreateResponse e : list.getResults()) {
            if (e == null) {
                throw new RestLiServiceException(HttpStatus.S_500_INTERNAL_SERVER_ERROR, "Unexpected null encountered. Null element inside of List inside of a BatchCreateResult returned by the resource method: " + routingResult.getResourceMethod());
            }
            Object id = ResponseUtils.translateCanonicalKeyToAlternativeKeyIfNeeded(e.getId(), routingResult);
            if (e.getError() == null) {
                CreateIdStatus entry = new CreateIdStatus(e.getStatus().getCode(), id, null, ProtocolVersionUtil.extractProtocolVersion(headers));
                collectionCreateList.add(new BatchCreateResponseEnvelope.CollectionCreateResponseItem(entry));
                continue;
            }
            collectionCreateList.add(new BatchCreateResponseEnvelope.CollectionCreateResponseItem(e.getError(), id));
        }
        RestLiResponseDataImpl responseData = new RestLiResponseDataImpl(HttpStatus.S_200_OK, headers, cookies);
        responseData.setResponseEnvelope(new BatchCreateResponseEnvelope(collectionCreateList, responseData));
        return responseData;
    }
}

