/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server;

import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.server.filter.RestLiFilterChain;
import com.linkedin.restli.internal.server.filter.RestLiFilterResponseContextFactory;
import com.linkedin.restli.server.RequestExecutionCallback;
import com.linkedin.restli.server.RequestExecutionReport;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.filter.FilterRequestContext;
import com.linkedin.restli.server.filter.FilterResponseContext;

public class RestLiCallback<T>
implements RequestExecutionCallback<T> {
    private final RestLiFilterChain _filterChain;
    private final FilterRequestContext _filterRequestContext;
    private final RestLiFilterResponseContextFactory _filterResponseContextFactory;

    public RestLiCallback(FilterRequestContext filterRequestContext, RestLiFilterResponseContextFactory filterResponseContextFactory, RestLiFilterChain filterChain) {
        this._filterResponseContextFactory = filterResponseContextFactory;
        this._filterChain = filterChain;
        this._filterRequestContext = filterRequestContext;
    }

    @Override
    public void onSuccess(T result, RequestExecutionReport executionReport, RestLiResponseAttachments responseAttachments) {
        FilterResponseContext responseContext;
        try {
            responseContext = this._filterResponseContextFactory.fromResult(result);
        }
        catch (Exception e) {
            this.onError(e, executionReport, null, responseAttachments);
            return;
        }
        this._filterChain.onResponse(this._filterRequestContext, responseContext, responseAttachments);
    }

    @Override
    public void onError(Throwable e, RequestExecutionReport executionReport, RestLiAttachmentReader requestAttachmentReader, RestLiResponseAttachments responseAttachments) {
        FilterResponseContext responseContext = this._filterResponseContextFactory.fromThrowable(e);
        this._filterChain.onError(e, this._filterRequestContext, responseContext, responseAttachments);
    }
}

