/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.server;

import com.google.common.base.Strings;
import com.linkedin.common.Version;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.template.StringArray;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.jersey.core.util.MultivaluedMap;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.attachments.RestLiAttachmentReader;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.CookieUtil;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.ProtocolVersionUtil;
import com.linkedin.restli.internal.common.QueryParamsDataMap;
import com.linkedin.restli.internal.common.URIParamUtils;
import com.linkedin.restli.internal.server.MutablePathKeys;
import com.linkedin.restli.internal.server.PathKeysImpl;
import com.linkedin.restli.internal.server.ServerResourceContext;
import com.linkedin.restli.internal.server.util.ArgumentUtils;
import com.linkedin.restli.internal.server.util.RestLiSyntaxException;
import com.linkedin.restli.server.ProjectionMode;
import com.linkedin.restli.server.RestLiResponseAttachments;
import com.linkedin.restli.server.RestLiServiceException;
import com.linkedin.restli.server.RoutingException;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class ResourceContextImpl
implements ServerResourceContext {
    private static final int INITIAL_CUSTOM_REQUEST_CONTEXT_CAPACITY = 1;
    private final MutablePathKeys _pathKeys;
    private final RestRequest _request;
    private final DataMap _parameters;
    private final Map<String, String> _requestHeaders;
    private final Map<String, String> _responseHeaders;
    private final List<HttpCookie> _requestCookies;
    private final List<HttpCookie> _responseCookies;
    private final Map<Object, RestLiServiceException> _batchKeyErrors;
    private final RequestContext _requestContext;
    private final ProtocolVersion _protocolVersion;
    private String _mimeType;
    private ProjectionMode _projectionMode;
    private MaskTree _projectionMask;
    private ProjectionMode _metadataProjectionMode;
    private MaskTree _metadataProjectionMask;
    private MaskTree _pagingProjectionMask;
    private final RestLiAttachmentReader _requestAttachmentReader;
    private final boolean _responseAttachmentsAllowed;
    private RestLiResponseAttachments _responseStreamingAttachments;
    private Map<String, Object> _customRequestContext;

    public ResourceContextImpl() throws RestLiSyntaxException {
        this(new PathKeysImpl(), ((RestRequestBuilder)new RestRequestBuilder(URI.create("")).setHeader("X-RestLi-Protocol-Version", AllProtocolVersions.LATEST_PROTOCOL_VERSION.toString())).build(), new RequestContext());
    }

    public ResourceContextImpl(MutablePathKeys pathKeys, RestRequest request, RequestContext requestContext) throws RestLiSyntaxException {
        this(pathKeys, request, requestContext, false, null);
    }

    public ResourceContextImpl(MutablePathKeys pathKeys, RestRequest request, RequestContext requestContext, boolean responseAttachmentsAllowed, RestLiAttachmentReader restLiAttachmentReader) throws RestLiSyntaxException {
        this._pathKeys = pathKeys;
        this._request = request;
        this._requestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this._requestHeaders.putAll(request.getHeaders());
        this._responseHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this._requestCookies = new ArrayList<HttpCookie>(CookieUtil.decodeCookies((List)this._request.getCookies()));
        this._responseCookies = new ArrayList<HttpCookie>();
        this._requestContext = requestContext;
        this._responseAttachmentsAllowed = responseAttachmentsAllowed;
        this._requestAttachmentReader = restLiAttachmentReader;
        this._protocolVersion = ProtocolVersionUtil.extractProtocolVersion((Map)request.getHeaders());
        try {
            if (this._protocolVersion.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
                MultivaluedMap queryParameters = UriComponent.decodeQuery((URI)this._request.getURI(), (boolean)false);
                this._parameters = URIParamUtils.parseUriParams((Map)queryParameters);
            } else {
                Map<String, List<String>> queryParameters = ArgumentUtils.getQueryParameters(this._request.getURI());
                this._parameters = QueryParamsDataMap.parseDataMapKeys(queryParameters);
            }
        }
        catch (PathSegment.PathSegmentSyntaxException e) {
            throw new RestLiSyntaxException("Invalid query parameters syntax: " + this._request.getURI().toString(), e);
        }
        this._projectionMask = this._parameters.containsKey((Object)"fields") ? ArgumentUtils.parseProjectionParameter(ArgumentUtils.argumentAsString(this.getParameter("fields"), "fields")) : null;
        this._metadataProjectionMask = this._parameters.containsKey((Object)"metadataFields") ? ArgumentUtils.parseProjectionParameter(ArgumentUtils.argumentAsString(this.getParameter("metadataFields"), "metadataFields")) : null;
        this._pagingProjectionMask = this._parameters.containsKey((Object)"pagingFields") ? ArgumentUtils.parseProjectionParameter(ArgumentUtils.argumentAsString(this.getParameter("pagingFields"), "pagingFields")) : null;
        this._batchKeyErrors = new HashMap<Object, RestLiServiceException>();
        this._projectionMode = ProjectionMode.getDefault();
        this._metadataProjectionMode = ProjectionMode.getDefault();
    }

    @Override
    public DataMap getParameters() {
        return this._parameters;
    }

    @Override
    public URI getRequestURI() {
        return this._request.getURI();
    }

    @Override
    public String getRequestActionName() {
        return ArgumentUtils.argumentAsString(this.getParameter("action"), "action");
    }

    @Override
    public String getRequestFinderName() {
        return ArgumentUtils.argumentAsString(this.getParameter("q"), "q");
    }

    @Override
    public String getRequestMethod() {
        return this._request.getMethod();
    }

    @Override
    public MutablePathKeys getPathKeys() {
        return this._pathKeys;
    }

    @Override
    @Deprecated
    public RestRequest getRawRequest() {
        return this._request;
    }

    @Override
    public MaskTree getProjectionMask() {
        return this._projectionMask;
    }

    @Override
    public void setProjectionMask(MaskTree projectionMask) {
        this._projectionMask = projectionMask;
    }

    @Override
    public MaskTree getMetadataProjectionMask() {
        return this._metadataProjectionMask;
    }

    @Override
    public void setMetadataProjectionMask(MaskTree metadataProjectionMask) {
        this._metadataProjectionMask = metadataProjectionMask;
    }

    @Override
    public MaskTree getPagingProjectionMask() {
        return this._pagingProjectionMask;
    }

    @Override
    public void setPagingProjectionMask(MaskTree pagingProjectionMask) {
        this._pagingProjectionMask = pagingProjectionMask;
    }

    @Override
    public String getParameter(String key) {
        Object paramValueObj = this._parameters.get((Object)key);
        if (paramValueObj == null) {
            return null;
        }
        if (paramValueObj instanceof List) {
            List paramValueList = (List)paramValueObj;
            if (paramValueList.isEmpty()) {
                return null;
            }
            return paramValueList.get(0).toString();
        }
        return paramValueObj.toString();
    }

    @Override
    public Object getStructuredParameter(String key) {
        return this._parameters.get((Object)key);
    }

    @Override
    public List<String> getParameterValues(String key) {
        Object paramObject = this._parameters.get((Object)key);
        if (paramObject == null) {
            return null;
        }
        if (paramObject instanceof String && this._protocolVersion.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_1_0_0.getProtocolVersion()) == 0) {
            return Collections.singletonList((String)paramObject);
        }
        if (!(paramObject instanceof DataList)) {
            throw new RoutingException("Invalid value type for parameter " + key, HttpStatus.S_400_BAD_REQUEST.getCode());
        }
        return new StringArray((DataList)paramObject);
    }

    @Override
    public boolean hasParameter(String key) {
        return this._parameters.containsKey((Object)key);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this._requestHeaders;
    }

    @Override
    public List<HttpCookie> getRequestCookies() {
        return this._requestCookies;
    }

    @Override
    public void setResponseHeader(String name, String value) {
        String headerName = "X-LinkedIn-Id".equals(name) ? "X-LinkedIn-Id" : ("X-RestLi-Id".equals(name) ? "X-RestLi-Id" : null);
        if (headerName != null) {
            throw new IllegalArgumentException("Illegal to set the \"" + headerName + "\" header. This header is reserved for the ID returned from create method on the resource.");
        }
        this._responseHeaders.put(name, value);
    }

    @Override
    public void addResponseCookie(HttpCookie cookie) {
        if (cookie != null) {
            this._responseCookies.add(cookie);
        }
    }

    @Override
    public RequestContext getRawRequestContext() {
        return this._requestContext;
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return Collections.unmodifiableMap(this._responseHeaders);
    }

    @Override
    public List<HttpCookie> getResponseCookies() {
        return this._responseCookies;
    }

    @Override
    public Map<Object, RestLiServiceException> getBatchKeyErrors() {
        return this._batchKeyErrors;
    }

    @Override
    public String getRestLiRequestMethod() {
        String headerValue = this._request.getHeader("X-RestLi-Method");
        return headerValue == null ? "" : headerValue;
    }

    @Override
    public ProtocolVersion getRestliProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public ProjectionMode getProjectionMode() {
        return this._projectionMode;
    }

    @Override
    public void setProjectionMode(ProjectionMode projectionMode) {
        this._projectionMode = projectionMode;
    }

    @Override
    public ProjectionMode getMetadataProjectionMode() {
        return this._metadataProjectionMode;
    }

    @Override
    public void setMetadataProjectionMode(ProjectionMode metadataProjectionMode) {
        this._metadataProjectionMode = metadataProjectionMode;
    }

    @Override
    public void setResponseMimeType(String type) {
        this._mimeType = type;
    }

    @Override
    public String getResponseMimeType() {
        return this._mimeType;
    }

    @Override
    public boolean responseAttachmentsSupported() {
        return this._responseAttachmentsAllowed;
    }

    @Override
    public RestLiAttachmentReader getRequestAttachmentReader() {
        return this._requestAttachmentReader;
    }

    @Override
    public void setResponseAttachments(RestLiResponseAttachments responseAttachments) throws IllegalStateException {
        if (!this._responseAttachmentsAllowed) {
            throw new IllegalStateException("Response attachments can only be set if the client request indicates permissibility");
        }
        this._responseStreamingAttachments = responseAttachments;
    }

    @Override
    public RestLiResponseAttachments getResponseAttachments() {
        return this._responseStreamingAttachments;
    }

    @Override
    public Optional<Object> getCustomContextData(String key) {
        if (this._customRequestContext != null && !Strings.isNullOrEmpty((String)key) && this._customRequestContext.containsKey(key)) {
            return Optional.of(this._customRequestContext.get(key));
        }
        return Optional.empty();
    }

    @Override
    public void putCustomContextData(String key, Object data) {
        if (!Strings.isNullOrEmpty((String)key) && data != null) {
            if (this._customRequestContext == null) {
                this._customRequestContext = new HashMap<String, Object>(1);
            }
            this._customRequestContext.put(key, data);
        }
    }

    @Override
    public Optional<Object> removeCustomContextData(String key) {
        return this.getCustomContextData(key).isPresent() ? Optional.of(this._customRequestContext.remove(key)) : Optional.empty();
    }
}

