/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.stores.PropertyStore;
import com.linkedin.d2.discovery.stores.toggling.TogglingPublisher;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeperStore;
import com.linkedin.d2.discovery.util.LogUtil;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTogglingStore<T>
extends TogglingPublisher<T> {
    private static final Logger _log = LoggerFactory.getLogger(ZooKeeperTogglingStore.class);

    public ZooKeeperTogglingStore(final ZooKeeperStore<T> store, PropertyStore<T> backup, PropertyEventBus<T> eventBus, boolean allowToggling) {
        super(store, backup, eventBus);
        if (store != null && allowToggling) {
            store.getClient().addStateListener(new ZKConnection.StateListener(){

                @Override
                public void notifyStateChange(Watcher.Event.KeeperState state) {
                    if (state != Watcher.Event.KeeperState.SyncConnected) {
                        LogUtil.warn(_log, " lost zk connection, so shutting down, and toggling zk store off");
                        store.shutdown(new PropertyEventThread.PropertyEventShutdownCallback(){

                            @Override
                            public void done() {
                                LogUtil.info(_log, "shutdown complete");
                            }
                        });
                    }
                }
            });
        } else {
            LogUtil.warn(_log, "got a null store when constructing zk toggling store, so starting disabled");
        }
    }
}

