/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.simple;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.callback.SimpleCallback;
import com.linkedin.common.util.MapUtil;
import com.linkedin.common.util.None;
import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.LoadBalancerStateItem;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.properties.AllowedClientPropertyKeys;
import com.linkedin.d2.balancer.properties.ClientServiceConfigValidator;
import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.PartitionData;
import com.linkedin.d2.balancer.properties.ServiceProperties;
import com.linkedin.d2.balancer.properties.UriProperties;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategyFactory;
import com.linkedin.d2.balancer.strategies.degrader.DegraderConfigFactory;
import com.linkedin.d2.balancer.util.ClientFactoryProvider;
import com.linkedin.d2.balancer.util.LoadBalancerUtil;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessor;
import com.linkedin.d2.balancer.util.partitions.PartitionAccessorFactory;
import com.linkedin.d2.discovery.event.PropertyEventBus;
import com.linkedin.d2.discovery.event.PropertyEventBusImpl;
import com.linkedin.d2.discovery.event.PropertyEventPublisher;
import com.linkedin.d2.discovery.event.PropertyEventSubscriber;
import com.linkedin.d2.discovery.event.PropertyEventThread;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.internal.common.util.CollectionUtils;
import com.linkedin.r2.transport.common.TransportClientFactory;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.util.ClosableQueue;
import com.linkedin.r2.util.ConfigValueExtractor;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.linkedin.util.degrader.DegraderImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadBalancerState
implements LoadBalancerState,
ClientFactoryProvider {
    private static final Logger _log = LoggerFactory.getLogger(SimpleLoadBalancerState.class);
    private final UriLoadBalancerSubscriber _uriSubscriber;
    private final ClusterLoadBalancerSubscriber _clusterSubscriber;
    private final ServiceLoadBalancerSubscriber _serviceSubscriber;
    private final PropertyEventBus<UriProperties> _uriBus;
    private final PropertyEventBus<ClusterProperties> _clusterBus;
    private final PropertyEventBus<ServiceProperties> _serviceBus;
    private final Map<String, LoadBalancerStateItem<UriProperties>> _uriProperties;
    private final Map<String, ClusterInfoItem> _clusterInfo;
    private final Map<String, LoadBalancerStateItem<ServiceProperties>> _serviceProperties;
    private final AtomicLong _version;
    private final Map<String, Set<String>> _servicesPerCluster;
    private final ScheduledExecutorService _executor;
    private final List<SimpleLoadBalancerStateListener> _listeners;
    private volatile long _delayedExecution;
    private final Map<String, Map<URI, TrackerClient>> _trackerClients;
    private final Map<String, Map<String, TransportClient>> _serviceClients;
    private final Map<String, TransportClientFactory> _clientFactories;
    private final Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> _loadBalancerStrategyFactories;
    private final Map<String, Map<String, LoadBalancerStrategy>> _serviceStrategies;
    private final Map<String, List<LoadBalancerState.SchemeStrategyPair>> _serviceStrategiesCache;
    private final SSLContext _sslContext;
    private final SSLParameters _sslParameters;
    private final boolean _isSSLEnabled;
    private static final String LIST_SEPARATOR = ",";
    private final Map<String, Map<String, Object>> _clientServicesConfig;

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventPublisher<UriProperties> uriPublisher, PropertyEventPublisher<ClusterProperties> clusterPublisher, PropertyEventPublisher<ServiceProperties> servicePublisher, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories) {
        this(executorService, uriPublisher, clusterPublisher, servicePublisher, clientFactories, loadBalancerStrategyFactories, null, null, false);
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventPublisher<UriProperties> uriPublisher, PropertyEventPublisher<ClusterProperties> clusterPublisher, PropertyEventPublisher<ServiceProperties> servicePublisher, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled) {
        this(executorService, new PropertyEventBusImpl<UriProperties>(executorService, uriPublisher), new PropertyEventBusImpl<ClusterProperties>(executorService, clusterPublisher), new PropertyEventBusImpl<ServiceProperties>(executorService, servicePublisher), clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, Collections.emptyMap());
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled) {
        this(executorService, uriBus, clusterBus, serviceBus, clientFactories, loadBalancerStrategyFactories, sslContext, sslParameters, isSSLEnabled, Collections.emptyMap());
    }

    public SimpleLoadBalancerState(ScheduledExecutorService executorService, PropertyEventBus<UriProperties> uriBus, PropertyEventBus<ClusterProperties> clusterBus, PropertyEventBus<ServiceProperties> serviceBus, Map<String, TransportClientFactory> clientFactories, Map<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>> loadBalancerStrategyFactories, SSLContext sslContext, SSLParameters sslParameters, boolean isSSLEnabled, Map<String, Map<String, Object>> clientServicesConfig) {
        this._executor = executorService;
        this._uriProperties = new ConcurrentHashMap<String, LoadBalancerStateItem<UriProperties>>();
        this._clusterInfo = new ConcurrentHashMap<String, ClusterInfoItem>();
        this._serviceProperties = new ConcurrentHashMap<String, LoadBalancerStateItem<ServiceProperties>>();
        this._version = new AtomicLong(0L);
        this._uriBus = uriBus;
        this._uriSubscriber = new UriLoadBalancerSubscriber(uriBus);
        this._clusterBus = clusterBus;
        this._clusterSubscriber = new ClusterLoadBalancerSubscriber(clusterBus);
        this._serviceBus = serviceBus;
        this._serviceSubscriber = new ServiceLoadBalancerSubscriber(serviceBus);
        this._clientFactories = Collections.unmodifiableMap(new HashMap<String, TransportClientFactory>(clientFactories));
        this._loadBalancerStrategyFactories = Collections.unmodifiableMap(new HashMap<String, LoadBalancerStrategyFactory<? extends LoadBalancerStrategy>>(loadBalancerStrategyFactories));
        this._servicesPerCluster = new ConcurrentHashMap<String, Set<String>>();
        this._serviceStrategies = new ConcurrentHashMap<String, Map<String, LoadBalancerStrategy>>();
        this._serviceStrategiesCache = new ConcurrentHashMap<String, List<LoadBalancerState.SchemeStrategyPair>>();
        this._trackerClients = new ConcurrentHashMap<String, Map<URI, TrackerClient>>();
        this._serviceClients = new ConcurrentHashMap<String, Map<String, TransportClient>>();
        this._listeners = Collections.synchronizedList(new ArrayList());
        this._delayedExecution = 1000L;
        this._sslContext = sslContext;
        this._sslParameters = sslParameters;
        this._isSSLEnabled = isSSLEnabled;
        this._clientServicesConfig = this.validateClientServicesConfig(clientServicesConfig);
    }

    private Map<String, Map<String, Object>> validateClientServicesConfig(Map<String, Map<String, Object>> clientServicesConfig) {
        HashMap<String, Map<String, Object>> validatedClientServicesConfig = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : clientServicesConfig.entrySet()) {
            String serviceName = entry.getKey();
            Map<String, Object> clientConfigForSingleService = entry.getValue();
            HashMap<String, Object> validatedClientConfigForSingleService = new HashMap<String, Object>();
            for (Map.Entry<String, Object> innerMapEntry : clientConfigForSingleService.entrySet()) {
                String clientSuppliedConfigKey = innerMapEntry.getKey();
                Object clientSuppliedConfigValue = innerMapEntry.getValue();
                if (!AllowedClientPropertyKeys.isAllowedConfigKey(clientSuppliedConfigKey)) continue;
                validatedClientConfigForSingleService.put(clientSuppliedConfigKey, clientSuppliedConfigValue);
                LogUtil.info(_log, "Client supplied config key {} for service {}", new Object[]{clientSuppliedConfigKey, serviceName});
            }
            if (validatedClientConfigForSingleService.isEmpty()) continue;
            validatedClientServicesConfig.put(serviceName, validatedClientConfigForSingleService);
        }
        return validatedClientServicesConfig;
    }

    public void register(final SimpleLoadBalancerStateListener listener) {
        LogUtil.trace(_log, "register listener: ", listener);
        this._executor.execute(new PropertyEventThread.PropertyEvent("add listener for state"){

            @Override
            public void innerRun() {
                SimpleLoadBalancerState.this._listeners.add(listener);
            }
        });
    }

    public void unregister(final SimpleLoadBalancerStateListener listener) {
        LogUtil.trace(_log, "unregister listener: ", listener);
        this._executor.execute(new PropertyEventThread.PropertyEvent("remove listener for state"){

            @Override
            public void innerRun() {
                SimpleLoadBalancerState.this._listeners.remove(listener);
            }
        });
    }

    @Override
    public void start(Callback<None> callback) {
        callback.onSuccess((Object)None.none());
    }

    @Override
    public void shutdown(final PropertyEventThread.PropertyEventShutdownCallback shutdown) {
        LogUtil.trace(_log, "shutdown");
        this._executor.execute(new PropertyEventThread.PropertyEvent("shutdown load balancer state"){

            @Override
            public void innerRun() {
                for (Object strategyEntry : SimpleLoadBalancerState.this._serviceStrategies.values()) {
                    strategyEntry.values().forEach(LoadBalancerStrategy::shutdown);
                }
                HashSet transportClients = new HashSet();
                for (Map clientsByScheme : SimpleLoadBalancerState.this._serviceClients.values()) {
                    transportClients.addAll(clientsByScheme.values());
                }
                Callback trackerCallback = Callbacks.countDown((Callback)Callbacks.adaptSimple((SimpleCallback)new SimpleCallback(){

                    public void onDone() {
                        shutdown.done();
                    }
                }), (int)transportClients.size());
                LogUtil.info(_log, "shutting down cluster clients");
                for (TransportClient transportClient : transportClients) {
                    transportClient.shutdown(trackerCallback);
                }
                for (SimpleLoadBalancerStateListener listener : SimpleLoadBalancerState.this._listeners) {
                    for (Map.Entry serviceStrategy : SimpleLoadBalancerState.this._serviceStrategies.entrySet()) {
                        for (Map.Entry strategyEntry : ((Map)serviceStrategy.getValue()).entrySet()) {
                            listener.onStrategyRemoved((String)serviceStrategy.getKey(), (String)strategyEntry.getKey(), (LoadBalancerStrategy)strategyEntry.getValue());
                        }
                        Map trackerClients = (Map)SimpleLoadBalancerState.this._trackerClients.get(serviceStrategy.getKey());
                        if (trackerClients == null) continue;
                        for (TrackerClient client : trackerClients.values()) {
                            listener.onClientRemoved((String)serviceStrategy.getKey(), client);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void listenToService(String serviceName, LoadBalancerState.LoadBalancerStateListenerCallback callback) {
        LogUtil.trace(_log, "listenToService: ", serviceName);
        this._serviceSubscriber.ensureListening(serviceName, callback);
    }

    @Override
    public void listenToCluster(final String clusterName, final LoadBalancerState.LoadBalancerStateListenerCallback callback) {
        LogUtil.trace(_log, "listenToCluster: ", clusterName);
        LoadBalancerState.LoadBalancerStateListenerCallback wrappedCallback = new LoadBalancerState.LoadBalancerStateListenerCallback(){
            private final AtomicInteger _count = new AtomicInteger(2);

            @Override
            public void done(int type, String name) {
                if (this._count.decrementAndGet() <= 0) {
                    callback.done(type, clusterName);
                }
            }
        };
        this._clusterSubscriber.ensureListening(clusterName, wrappedCallback);
        this._uriSubscriber.ensureListening(clusterName, wrappedCallback);
    }

    @Override
    public LoadBalancerStateItem<UriProperties> getUriProperties(String clusterName) {
        return this._uriProperties.get(clusterName);
    }

    @Override
    public LoadBalancerStateItem<ClusterProperties> getClusterProperties(String clusterName) {
        ClusterInfoItem clusterInfoItem = this._clusterInfo.get(clusterName);
        return clusterInfoItem == null ? null : clusterInfoItem.getClusterPropertiesItem();
    }

    @Override
    public LoadBalancerStateItem<PartitionAccessor> getPartitionAccessor(String clusterName) {
        ClusterInfoItem clusterInfoItem = this._clusterInfo.get(clusterName);
        return clusterInfoItem == null ? null : clusterInfoItem.getPartitionAccessorItem();
    }

    @Override
    public LoadBalancerStateItem<ServiceProperties> getServiceProperties(String serviceName) {
        return this._serviceProperties.get(serviceName);
    }

    public Map<String, LoadBalancerStateItem<ServiceProperties>> getServiceProperties() {
        return this._serviceProperties;
    }

    public long getVersion() {
        return this._version.get();
    }

    public int getClusterCount() {
        return this._clusterInfo.size();
    }

    public int getClusterListenCount() {
        return this._clusterSubscriber.propertyListenCount();
    }

    public int getListenerCount() {
        return this._listeners.size();
    }

    public int getServiceCount() {
        return this._serviceProperties.size();
    }

    public int getServiceListenCount() {
        return this._serviceSubscriber.propertyListenCount();
    }

    public Set<String> getSupportedSchemes() {
        return this._clientFactories.keySet();
    }

    public Set<String> getSupportedStrategies() {
        return this._loadBalancerStrategyFactories.keySet();
    }

    public int getTrackerClientCount(String clusterName) {
        Set<String> serviceNames = this._servicesPerCluster.get(clusterName);
        int count = 0;
        for (String serviceName : serviceNames) {
            count += ((Map)LoadBalancerUtil.getOrElse(this._trackerClients, serviceName, new HashMap())).size();
        }
        return count;
    }

    public Set<String> getServicesForCluster(String clusterName) {
        Set<String> services = this._servicesPerCluster.get(clusterName);
        if (services == null) {
            return Collections.emptySet();
        }
        return services;
    }

    public int getUriCount() {
        return this._uriProperties.size();
    }

    public void setVersion(final long version) {
        LogUtil.trace(_log, "setVersion: ", version);
        this._executor.execute(new PropertyEventThread.PropertyEvent("set version to: " + version){

            @Override
            public void innerRun() {
                LogUtil.info(_log, "set global version to: ", version);
                SimpleLoadBalancerState.this._version.set(version);
            }
        });
    }

    @Override
    public boolean isListeningToCluster(String clusterName) {
        return this._clusterSubscriber.isListeningToProperty(clusterName);
    }

    @Override
    public boolean isListeningToService(String serviceName) {
        return this._serviceSubscriber.isListeningToProperty(serviceName);
    }

    public long getDelayedExecution() {
        return this._delayedExecution;
    }

    public void setDelayedExecution(long delayedExecution) {
        this._delayedExecution = delayedExecution;
    }

    @Override
    public TrackerClient getClient(String serviceName, URI uri) {
        Map<URI, TrackerClient> trackerClients = this._trackerClients.get(serviceName);
        TrackerClient trackerClient = null;
        if (trackerClients != null) {
            trackerClient = trackerClients.get(uri);
        } else {
            LogUtil.warn(_log, "get client called on unknown service ", serviceName, ": ", uri);
        }
        return trackerClient;
    }

    public List<URI> getServerUrisForServiceName(String clusterName) {
        Map<URI, TrackerClient> trackerClients = this._trackerClients.get(clusterName);
        if (trackerClients == null) {
            return Collections.emptyList();
        }
        return new ArrayList<URI>(trackerClients.keySet());
    }

    @Override
    public TransportClient getClient(String serviceName, String scheme) {
        Map<String, TransportClient> transportClients = this._serviceClients.get(serviceName);
        TransportClient transportClient = null;
        if (transportClients != null) {
            transportClient = transportClients.get(scheme.toLowerCase());
            if (transportClient == null) {
                LogUtil.warn(_log, "no generic transport client for service " + serviceName + " and scheme: " + scheme);
            }
        } else {
            LogUtil.warn(_log, "get client called on unknown service ", serviceName);
        }
        return transportClient;
    }

    @Override
    public LoadBalancerStrategy getStrategy(String serviceName, String scheme) {
        Map<String, LoadBalancerStrategy> strategies = this._serviceStrategies.get(serviceName);
        LoadBalancerStrategy strategy = null;
        if (strategies != null) {
            strategy = strategies.get(scheme);
        } else {
            LogUtil.warn(_log, "get strategy called on unknown service ", serviceName);
        }
        return strategy;
    }

    @Override
    public List<LoadBalancerState.SchemeStrategyPair> getStrategiesForService(String serviceName, List<String> prioritizedSchemes) {
        List<LoadBalancerState.SchemeStrategyPair> cached = this._serviceStrategiesCache.get(serviceName);
        if (cached != null && !cached.isEmpty()) {
            return cached;
        }
        ArrayList<LoadBalancerState.SchemeStrategyPair> orderedStrategies = new ArrayList<LoadBalancerState.SchemeStrategyPair>(prioritizedSchemes.size());
        for (String scheme : prioritizedSchemes) {
            if ("https".equals(scheme) && !this._isSSLEnabled) continue;
            LoadBalancerStrategy strategy = this.getStrategy(serviceName, scheme);
            if (strategy != null) {
                orderedStrategies.add(new LoadBalancerState.SchemeStrategyPair(scheme, strategy));
                continue;
            }
            LogUtil.warn(_log, "unable to find a load balancer strategy for ", serviceName, " with scheme: ", scheme);
        }
        this._serviceStrategiesCache.put(serviceName, orderedStrategies);
        return orderedStrategies;
    }

    @Override
    public TransportClientFactory getClientFactory(String scheme) {
        return this._clientFactories.get(scheme);
    }

    private void removeTrackerClients(String clusterName) {
        LogUtil.warn(_log, "removing all tracker clients for cluster: ", clusterName);
        Set<String> serviceNames = this._servicesPerCluster.get(clusterName);
        if (serviceNames != null) {
            for (String serviceName : serviceNames) {
                Map<URI, TrackerClient> clients = this._trackerClients.remove(serviceName);
                if (clients == null) continue;
                for (TrackerClient client : clients.values()) {
                    for (SimpleLoadBalancerStateListener listener : this._listeners) {
                        listener.onClientRemoved(serviceName, client);
                    }
                }
            }
        }
    }

    private TrackerClient getTrackerClient(String serviceName, URI uri, Map<Integer, PartitionData> partitionDataMap, DegraderImpl.Config config, Clock clk, long callTrackerInterval, String errorStatusPattern) {
        Map<String, TransportClient> clientsByScheme = this._serviceClients.get(serviceName);
        if (clientsByScheme == null) {
            _log.error("getTrackerClient: unknown service name {} for URI {} and partitionDataMap {}", new Object[]{serviceName, uri, partitionDataMap});
            return null;
        }
        TransportClient client = clientsByScheme.get(uri.getScheme().toLowerCase());
        if (client == null) {
            LogUtil.debug(_log, "No TransportClient for scheme {}, service {}, URI {} and partitionDataMap {}. This client may not be configured to handle URIs in this scheme.", new Object[]{uri.getScheme(), serviceName, uri, partitionDataMap});
            return null;
        }
        TrackerClient trackerClient = new TrackerClient(uri, partitionDataMap, client, clk, config, callTrackerInterval, errorStatusPattern);
        return trackerClient;
    }

    private Map<String, TransportClient> createAndInsertTransportClientTo(ServiceProperties serviceProperties) {
        HashMap<String, Object> transportClientProperties = new HashMap<String, Object>(serviceProperties.getTransportClientProperties());
        Object allowedClientOverrideKeysObj = transportClientProperties.remove("allowedClientOverrideKeys");
        HashSet allowedClientOverrideKeys = new HashSet(ConfigValueExtractor.buildList(allowedClientOverrideKeysObj, (String)LIST_SEPARATOR));
        Map<String, Object> clientSuppliedServiceProperties = this._clientServicesConfig.get(serviceProperties.getServiceName());
        if (clientSuppliedServiceProperties != null) {
            LogUtil.debug(_log, "Client supplied configs for service {}", new Object[]{serviceProperties.getServiceName()});
            for (String clientSuppliedKey : clientSuppliedServiceProperties.keySet()) {
                if (!allowedClientOverrideKeys.contains(clientSuppliedKey)) continue;
                if (ClientServiceConfigValidator.isValidValue(transportClientProperties, clientSuppliedServiceProperties, clientSuppliedKey)) {
                    transportClientProperties.put(clientSuppliedKey, clientSuppliedServiceProperties.get(clientSuppliedKey));
                    LogUtil.info(_log, "Client overrode config property {} for service {}. This is being used to instantiate the Transport Client", new Object[]{clientSuppliedKey, serviceProperties.getServiceName()});
                    continue;
                }
                LogUtil.warn(_log, "Client supplied config property {} with an invalid value {} for service {}", new Object[]{clientSuppliedKey, clientSuppliedServiceProperties.get(clientSuppliedKey), serviceProperties.getServiceName()});
            }
        }
        List<String> schemes = serviceProperties.getPrioritizedSchemes();
        HashMap<String, TransportClient> newTransportClients = new HashMap<String, TransportClient>();
        if (schemes != null && !schemes.isEmpty()) {
            for (String scheme : schemes) {
                TransportClientFactory factory = this._clientFactories.get(scheme);
                if ("https".equals(scheme)) {
                    if (!this._isSSLEnabled) continue;
                    if (this._sslContext != null && this._sslParameters != null) {
                        transportClientProperties.put("http.sslContext", this._sslContext);
                        transportClientProperties.put("http.sslParams", this._sslParameters);
                    } else {
                        _log.error("https specified as a prioritized scheme for service: " + serviceProperties.getServiceName() + " but no SSLContext or SSLParameters have been configured.");
                        if (schemes.size() != 1) continue;
                        throw new IllegalStateException("SSL enabled but required SSLContext and SSLParameterswere not both present.");
                    }
                }
                if (factory != null) {
                    transportClientProperties.put("http.serviceName", serviceProperties.getServiceName());
                    TransportClient client = factory.getClient(transportClientProperties);
                    newTransportClients.put(scheme.toLowerCase(), client);
                    continue;
                }
                _log.warn("Failed to find client factory for scheme {}", (Object)scheme);
            }
        } else {
            _log.warn("Prioritized schemes is null for service properties = " + serviceProperties.getServiceName());
        }
        return newTransportClients;
    }

    private static long getTrackerClientInterval(ServiceProperties serviceProperties) {
        long trackerClientInterval = 5000L;
        if (serviceProperties.getLoadBalancerStrategyProperties() != null) {
            trackerClientInterval = (Long)MapUtil.getWithDefault(serviceProperties.getLoadBalancerStrategyProperties(), (Object)"http.loadBalancer.updateIntervalMs", (Object)5000L, Long.class);
        }
        return trackerClientInterval;
    }

    private static String getErrorStatusPattern(ServiceProperties serviceProperties) {
        String pattern = "(5..)";
        if (serviceProperties.getLoadBalancerStrategyProperties() != null) {
            pattern = (String)MapUtil.getWithDefault(serviceProperties.getLoadBalancerStrategyProperties(), (Object)"http.loadBalancer.errorStatusRegex", (Object)"(5..)", String.class);
        }
        return pattern;
    }

    void refreshTransportClientsPerService(ServiceProperties serviceProperties) {
        ConcurrentHashMap<URI, TrackerClient> newTrackerClients;
        LoadBalancerStateItem<UriProperties> uriItem;
        UriProperties uriProperties;
        String serviceName = serviceProperties.getServiceName();
        Map<String, TransportClient> newTransportClients = this.createAndInsertTransportClientTo(serviceProperties);
        newTransportClients = Collections.unmodifiableMap(newTransportClients);
        Map<String, TransportClient> oldTransportClients = this._serviceClients.put(serviceName, newTransportClients);
        DegraderImpl.Config config = null;
        if (serviceProperties.getDegraderProperties() != null && !serviceProperties.getDegraderProperties().isEmpty()) {
            config = DegraderConfigFactory.toDegraderConfig(serviceProperties.getDegraderProperties());
        } else {
            LogUtil.debug(_log, "trying to see if there's a special degraderImpl properties but serviceInfo.getDegraderImpl() is null for service name = " + serviceName + " so we'll set config to default");
        }
        SystemClock clk = SystemClock.instance();
        if (serviceProperties.getLoadBalancerStrategyProperties() != null) {
            Map<String, Object> loadBalancerStrategyProperties = serviceProperties.getLoadBalancerStrategyProperties();
            clk = (Clock)MapUtil.getWithDefault(loadBalancerStrategyProperties, (Object)"clock", (Object)SystemClock.instance(), Clock.class);
        }
        UriProperties uriProperties2 = uriProperties = (uriItem = this._uriProperties.get(serviceProperties.getClusterName())) == null ? null : uriItem.getProperty();
        if (uriProperties != null) {
            Set<URI> uris = uriProperties.Uris();
            newTrackerClients = new ConcurrentHashMap(CollectionUtils.getMapInitialCapacity((int)uris.size(), (float)0.75f), 0.75f, 1);
            long trackerClientInterval = SimpleLoadBalancerState.getTrackerClientInterval(serviceProperties);
            String errorStatusPattern = SimpleLoadBalancerState.getErrorStatusPattern(serviceProperties);
            for (URI uri : uris) {
                TrackerClient trackerClient = this.getTrackerClient(serviceName, uri, uriProperties.getPartitionDataMap(uri), config, (Clock)clk, trackerClientInterval, errorStatusPattern);
                if (trackerClient == null) continue;
                newTrackerClients.put(uri, trackerClient);
            }
        } else {
            newTrackerClients = new ConcurrentHashMap<URI, TrackerClient>(16, 0.75f, 1);
        }
        this._trackerClients.put(serviceName, newTrackerClients);
        this.shutdownTransportClients(oldTransportClients, serviceName);
    }

    private void shutdownClients(String serviceName) {
        _log.warn("shutting down all tracker clients and transport clients for service " + serviceName);
        Map<URI, TrackerClient> clients = this._trackerClients.remove(serviceName);
        if (clients != null) {
            for (TrackerClient client : clients.values()) {
                for (SimpleLoadBalancerStateListener listener : this._listeners) {
                    listener.onClientRemoved(serviceName, client);
                }
            }
        }
        Map<String, TransportClient> schemeToTransportClients = this._serviceClients.get(serviceName);
        this.shutdownTransportClients(schemeToTransportClients, serviceName);
    }

    private void shutdownTransportClients(final Map<String, TransportClient> schemeToTransportClients, final String serviceName) {
        if (schemeToTransportClients != null) {
            this._executor.schedule(new Runnable(){

                @Override
                public void run() {
                    for (final Map.Entry entry : schemeToTransportClients.entrySet()) {
                        Callback<None> callback = new Callback<None>(){

                            public void onError(Throwable e) {
                                _log.warn("Failed to shut down old " + serviceName + " TransportClient with scheme = " + (String)entry.getKey(), e);
                            }

                            public void onSuccess(None result) {
                                _log.info("Shut down old " + serviceName + " TransportClient with scheme = " + (String)entry.getKey());
                            }
                        };
                        ((TransportClient)entry.getValue()).shutdown((Callback)callback);
                    }
                }
            }, this._delayedExecution, TimeUnit.MILLISECONDS);
        }
    }

    void refreshServiceStrategies(ServiceProperties serviceProperties) {
        LogUtil.info(_log, "refreshing service strategies for service: ", serviceProperties);
        List<String> strategyList = serviceProperties.getLoadBalancerStrategyList();
        LoadBalancerStrategyFactory<? extends LoadBalancerStrategy> factory = null;
        if (strategyList != null && !strategyList.isEmpty()) {
            String strategy;
            Iterator<String> iterator = strategyList.iterator();
            while (iterator.hasNext() && (factory = this._loadBalancerStrategyFactories.get(strategy = iterator.next())) == null) {
            }
        }
        if (factory == null) {
            LogUtil.warn(_log, "No valid strategy found. ", serviceProperties);
        }
        ConcurrentHashMap<String, LoadBalancerStrategy> strategyMap = new ConcurrentHashMap<String, LoadBalancerStrategy>();
        if (factory != null && serviceProperties.getPrioritizedSchemes() != null && !serviceProperties.getPrioritizedSchemes().isEmpty()) {
            List<String> schemes = serviceProperties.getPrioritizedSchemes();
            for (String scheme : schemes) {
                HashMap<String, Object> loadBalancerStrategyProperties = new HashMap<String, Object>(serviceProperties.getLoadBalancerStrategyProperties());
                loadBalancerStrategyProperties.put("path", serviceProperties.getPath());
                LoadBalancerStrategy strategy = factory.newLoadBalancer(serviceProperties.getServiceName(), loadBalancerStrategyProperties, serviceProperties.getDegraderProperties());
                strategyMap.put(scheme, strategy);
            }
        } else {
            LogUtil.warn(_log, "unable to find cluster or factory for ", serviceProperties, ": ", factory);
        }
        Map oldStrategies = this._serviceStrategies.put(serviceProperties.getServiceName(), strategyMap);
        this._serviceStrategiesCache.remove(serviceProperties.getServiceName());
        LogUtil.info(_log, "removing strategies ", serviceProperties.getServiceName(), ": ", oldStrategies);
        LogUtil.info(_log, "putting strategies ", serviceProperties.getServiceName(), ": ", strategyMap);
        if (oldStrategies != null) {
            oldStrategies.values().forEach(LoadBalancerStrategy::shutdown);
            for (SimpleLoadBalancerStateListener listener : this._listeners) {
                for (Map.Entry oldStrategy : oldStrategies.entrySet()) {
                    listener.onStrategyRemoved(serviceProperties.getServiceName(), (String)oldStrategy.getKey(), (LoadBalancerStrategy)oldStrategy.getValue());
                }
            }
        }
        if (!strategyMap.isEmpty()) {
            for (SimpleLoadBalancerStateListener listener : this._listeners) {
                for (Map.Entry newStrategy : strategyMap.entrySet()) {
                    listener.onStrategyAdded(serviceProperties.getServiceName(), (String)newStrategy.getKey(), (LoadBalancerStrategy)newStrategy.getValue());
                }
            }
        }
    }

    public static interface SimpleLoadBalancerStateListener {
        public void onStrategyAdded(String var1, String var2, LoadBalancerStrategy var3);

        public void onStrategyRemoved(String var1, String var2, LoadBalancerStrategy var3);

        public void onClientAdded(String var1, TrackerClient var2);

        public void onClientRemoved(String var1, TrackerClient var2);
    }

    public class ServiceLoadBalancerSubscriber
    extends AbstractLoadBalancerSubscriber<ServiceProperties> {
        public ServiceLoadBalancerSubscriber(PropertyEventBus<ServiceProperties> eventBus) {
            super(0, eventBus);
        }

        @Override
        protected void handlePut(String listenTo, ServiceProperties discoveryProperties) {
            Set serviceNames;
            ServiceProperties oldServiceProperties;
            LoadBalancerStateItem oldServicePropertiesItem = (LoadBalancerStateItem)SimpleLoadBalancerState.this._serviceProperties.get(listenTo);
            SimpleLoadBalancerState.this._serviceProperties.put(listenTo, new LoadBalancerStateItem<ServiceProperties>(discoveryProperties, SimpleLoadBalancerState.this._version.incrementAndGet(), System.currentTimeMillis()));
            if (discoveryProperties != null) {
                Set serviceNames2;
                ServiceProperties oldServiceProperties2;
                if (oldServicePropertiesItem != null && (oldServiceProperties2 = (ServiceProperties)oldServicePropertiesItem.getProperty()) != null && oldServiceProperties2.getClusterName() != null && !oldServiceProperties2.getClusterName().equals(discoveryProperties.getClusterName()) && (serviceNames2 = (Set)SimpleLoadBalancerState.this._servicesPerCluster.get(oldServiceProperties2.getClusterName())) != null) {
                    serviceNames2.remove(oldServiceProperties2.getServiceName());
                }
                SimpleLoadBalancerState.this.refreshServiceStrategies(discoveryProperties);
                SimpleLoadBalancerState.this.refreshTransportClientsPerService(discoveryProperties);
                Set serviceNames3 = (Set)SimpleLoadBalancerState.this._servicesPerCluster.get(discoveryProperties.getClusterName());
                if (serviceNames3 == null) {
                    serviceNames3 = Collections.newSetFromMap(new ConcurrentHashMap());
                    SimpleLoadBalancerState.this._servicesPerCluster.put(discoveryProperties.getClusterName(), serviceNames3);
                }
                serviceNames3.add(discoveryProperties.getServiceName());
            } else if (oldServicePropertiesItem != null && (oldServiceProperties = (ServiceProperties)oldServicePropertiesItem.getProperty()) != null && (serviceNames = (Set)SimpleLoadBalancerState.this._servicesPerCluster.get(oldServiceProperties.getClusterName())) != null) {
                serviceNames.remove(oldServiceProperties.getServiceName());
            }
            if (discoveryProperties == null) {
                _log.warn("We receive a null service properties for {}. ", (Object)listenTo);
            }
        }

        @Override
        protected void handleRemove(String listenTo) {
            _log.warn("Received a service properties event to remove() for service = " + listenTo);
            LoadBalancerStateItem serviceItem = (LoadBalancerStateItem)SimpleLoadBalancerState.this._serviceProperties.remove(listenTo);
            if (serviceItem != null && serviceItem.getProperty() != null) {
                ServiceProperties serviceProperties = (ServiceProperties)serviceItem.getProperty();
                Set serviceNames = (Set)SimpleLoadBalancerState.this._servicesPerCluster.get(serviceProperties.getClusterName());
                if (serviceNames != null) {
                    serviceNames.remove(serviceProperties.getServiceName());
                }
                SimpleLoadBalancerState.this.shutdownClients(listenTo);
            }
        }
    }

    public class ClusterLoadBalancerSubscriber
    extends AbstractLoadBalancerSubscriber<ClusterProperties> {
        public ClusterLoadBalancerSubscriber(PropertyEventBus<ClusterProperties> cPropertyEventBus) {
            super(1, cPropertyEventBus);
        }

        @Override
        protected void handlePut(String listenTo, ClusterProperties discoveryProperties) {
            if (discoveryProperties != null) {
                SimpleLoadBalancerState.this._clusterInfo.put(listenTo, new ClusterInfoItem(discoveryProperties, PartitionAccessorFactory.getPartitionAccessor(discoveryProperties.getPartitionProperties())));
            } else {
                SimpleLoadBalancerState.this._clusterInfo.put(listenTo, new ClusterInfoItem(discoveryProperties, null));
            }
        }

        @Override
        protected void handleRemove(String listenTo) {
            SimpleLoadBalancerState.this._clusterInfo.remove(listenTo);
        }
    }

    public class UriLoadBalancerSubscriber
    extends AbstractLoadBalancerSubscriber<UriProperties> {
        public UriLoadBalancerSubscriber(PropertyEventBus<UriProperties> uPropertyEventBus) {
            super(1, uPropertyEventBus);
        }

        @Override
        protected void handlePut(String listenTo, UriProperties discoveryProperties) {
            if (discoveryProperties != null) {
                String clusterName = discoveryProperties.getClusterName();
                Set serviceNames = (Set)SimpleLoadBalancerState.this._servicesPerCluster.get(clusterName);
                if (serviceNames != null) {
                    for (String serviceName : serviceNames) {
                        ConcurrentHashMap<URI, TrackerClient> trackerClients = (ConcurrentHashMap<URI, TrackerClient>)SimpleLoadBalancerState.this._trackerClients.get(serviceName);
                        if (trackerClients == null) {
                            trackerClients = new ConcurrentHashMap<URI, TrackerClient>();
                            SimpleLoadBalancerState.this._trackerClients.put(serviceName, trackerClients);
                        }
                        LoadBalancerStateItem serviceProperties = (LoadBalancerStateItem)SimpleLoadBalancerState.this._serviceProperties.get(serviceName);
                        DegraderImpl.Config config = null;
                        SystemClock clk = SystemClock.instance();
                        if (serviceProperties == null || serviceProperties.getProperty() == null || ((ServiceProperties)serviceProperties.getProperty()).getDegraderProperties() == null) {
                            LogUtil.debug(_log, "trying to see if there's a special degraderImpl properties but serviceInfo is null for serviceName = " + serviceName + " so we'll set config to default");
                        } else {
                            Map<String, String> degraderImplProperties = ((ServiceProperties)serviceProperties.getProperty()).getDegraderProperties();
                            config = DegraderConfigFactory.toDegraderConfig(degraderImplProperties);
                        }
                        if (serviceProperties != null && serviceProperties.getProperty() != null && ((ServiceProperties)serviceProperties.getProperty()).getLoadBalancerStrategyProperties() != null) {
                            Map<String, Object> loadBalancerStrategyProperties = ((ServiceProperties)serviceProperties.getProperty()).getLoadBalancerStrategyProperties();
                            clk = (Clock)MapUtil.getWithDefault(loadBalancerStrategyProperties, (Object)"clock", (Object)SystemClock.instance(), Clock.class);
                        }
                        long trackerClientInterval = SimpleLoadBalancerState.getTrackerClientInterval((ServiceProperties)serviceProperties.getProperty());
                        String errorStatusPattern = SimpleLoadBalancerState.getErrorStatusPattern((ServiceProperties)serviceProperties.getProperty());
                        for (URI uri : discoveryProperties.Uris()) {
                            Map<Integer, PartitionData> partitionDataMap = discoveryProperties.getPartitionDataMap(uri);
                            TrackerClient client = (TrackerClient)trackerClients.get(uri);
                            if (client != null && client.getParttitionDataMap().equals(partitionDataMap) || (client = SimpleLoadBalancerState.this.getTrackerClient(serviceName, uri, partitionDataMap, config, (Clock)clk, trackerClientInterval, errorStatusPattern)) == null) continue;
                            LogUtil.debug(_log, "adding new tracker client from updated uri properties: ", client);
                            for (SimpleLoadBalancerStateListener listener : SimpleLoadBalancerState.this._listeners) {
                                listener.onClientAdded(serviceName, client);
                            }
                            trackerClients.put(uri, client);
                        }
                    }
                }
            }
            SimpleLoadBalancerState.this._uriProperties.put(listenTo, new LoadBalancerStateItem<UriProperties>(discoveryProperties, SimpleLoadBalancerState.this._version.incrementAndGet(), System.currentTimeMillis()));
            if (discoveryProperties != null) {
                Set serviceNames = (Set)SimpleLoadBalancerState.this._servicesPerCluster.get(discoveryProperties.getClusterName());
                if (serviceNames != null) {
                    for (String serviceName : serviceNames) {
                        Map trackerClients = (Map)SimpleLoadBalancerState.this._trackerClients.get(serviceName);
                        if (trackerClients == null) continue;
                        for (URI uri : trackerClients.keySet()) {
                            if (discoveryProperties.Uris().contains(uri)) continue;
                            TrackerClient client = (TrackerClient)trackerClients.remove(uri);
                            LogUtil.debug(_log, "removing dead tracker client: ", client);
                            for (SimpleLoadBalancerStateListener listener : SimpleLoadBalancerState.this._listeners) {
                                listener.onClientRemoved(serviceName, client);
                            }
                        }
                    }
                }
            } else {
                LogUtil.warn(_log, "received a null uri properties for cluster: ", listenTo);
            }
        }

        @Override
        protected void handleRemove(String listenTo) {
            SimpleLoadBalancerState.this._uriProperties.remove(listenTo);
            LogUtil.warn(_log, "received a uri properties event remove() for cluster: ", listenTo);
            SimpleLoadBalancerState.this.removeTrackerClients(listenTo);
        }
    }

    public abstract class AbstractLoadBalancerSubscriber<T>
    implements PropertyEventSubscriber<T> {
        private final String _name;
        private final int _type;
        private final PropertyEventBus<T> _eventBus;
        private final ConcurrentMap<String, ClosableQueue<LoadBalancerState.LoadBalancerStateListenerCallback>> _waiters = new ConcurrentHashMap<String, ClosableQueue<LoadBalancerState.LoadBalancerStateListenerCallback>>();

        public AbstractLoadBalancerSubscriber(int type, PropertyEventBus<T> eventBus) {
            this._name = this.getClass().getSimpleName();
            this._type = type;
            this._eventBus = eventBus;
        }

        public boolean isListeningToProperty(String propertyName) {
            ClosableQueue waiters = (ClosableQueue)this._waiters.get(propertyName);
            return waiters != null && waiters.isClosed();
        }

        public int propertyListenCount() {
            return this._waiters.size();
        }

        public void ensureListening(String propertyName, LoadBalancerState.LoadBalancerStateListenerCallback callback) {
            ClosableQueue waiters = (ClosableQueue)this._waiters.get(propertyName);
            boolean register = false;
            if (waiters == null) {
                waiters = new ClosableQueue();
                ClosableQueue previous = this._waiters.putIfAbsent(propertyName, (ClosableQueue<LoadBalancerState.LoadBalancerStateListenerCallback>)waiters);
                if (previous == null) {
                    register = true;
                } else {
                    waiters = previous;
                }
            }
            if (!waiters.offer((Object)callback)) {
                callback.done(this._type, propertyName);
            }
            if (register) {
                this._eventBus.register(Collections.singleton(propertyName), this);
            }
        }

        @Override
        public void onAdd(String propertyName, T propertyValue) {
            LogUtil.trace(_log, this._name, ".onAdd: ", propertyName, ": ", propertyValue);
            this.handlePut(propertyName, propertyValue);
            List queueList = ((ClosableQueue)this._waiters.get(propertyName)).ensureClosed();
            if (queueList != null) {
                for (LoadBalancerState.LoadBalancerStateListenerCallback waiter : queueList) {
                    waiter.done(this._type, propertyName);
                }
            }
        }

        @Override
        public void onInitialize(String propertyName, T propertyValue) {
            LogUtil.trace(_log, this._name, ".onInitialize: ", propertyName, ": ", propertyValue);
            this.handlePut(propertyName, propertyValue);
            for (LoadBalancerState.LoadBalancerStateListenerCallback waiter : ((ClosableQueue)this._waiters.get(propertyName)).close()) {
                waiter.done(this._type, propertyName);
            }
        }

        @Override
        public void onRemove(String propertyName) {
            LogUtil.trace(_log, this._name, ".onRemove: ", propertyName);
            this.handleRemove(propertyName);
            List queueList = ((ClosableQueue)this._waiters.get(propertyName)).ensureClosed();
            if (queueList != null) {
                for (LoadBalancerState.LoadBalancerStateListenerCallback waiter : queueList) {
                    waiter.done(this._type, propertyName);
                }
            }
        }

        protected abstract void handlePut(String var1, T var2);

        protected abstract void handleRemove(String var1);
    }

    private class ClusterInfoItem {
        private final LoadBalancerStateItem<ClusterProperties> _clusterPropertiesItem;
        private final LoadBalancerStateItem<PartitionAccessor> _partitionAccessorItem;

        ClusterInfoItem(ClusterProperties clusterProperties, PartitionAccessor partitionAccessor) {
            long version = SimpleLoadBalancerState.this._version.incrementAndGet();
            this._clusterPropertiesItem = new LoadBalancerStateItem<ClusterProperties>(clusterProperties, version, System.currentTimeMillis());
            this._partitionAccessorItem = new LoadBalancerStateItem<PartitionAccessor>(partitionAccessor, version, System.currentTimeMillis());
        }

        LoadBalancerStateItem<ClusterProperties> getClusterPropertiesItem() {
            return this._clusterPropertiesItem;
        }

        LoadBalancerStateItem<PartitionAccessor> getPartitionAccessorItem() {
            return this._partitionAccessorItem;
        }

        public String toString() {
            return "_clusterProperties = " + this._clusterPropertiesItem.getProperty();
        }
    }
}

