/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.xmlcache;

import java.util.Set;
import org.apache.geode.cache.control.RebalanceFactory;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.ResourceManager;

public class ResourceManagerCreation
implements ResourceManager {
    private volatile float criticalHeapPercentage;
    private boolean criticalHeapSet = false;
    private volatile float evictionHeapPercentage;
    private boolean evictionHeapSet = false;
    private volatile float criticalOffHeapPercentage;
    private boolean criticalOffHeapSet = false;
    private volatile float evictionOffHeapPercentage;
    private boolean evictionOffHeapSet = false;

    @Override
    public RebalanceFactory createRebalanceFactory() {
        throw new IllegalArgumentException("Unused");
    }

    @Override
    public Set<RebalanceOperation> getRebalanceOperations() {
        throw new IllegalArgumentException("Unused");
    }

    @Override
    public float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    @Override
    public void setCriticalHeapPercentage(float heapPercentage) {
        this.criticalHeapSet = true;
        this.criticalHeapPercentage = heapPercentage;
    }

    public void setCriticalHeapPercentageToDefault() {
        this.criticalHeapPercentage = 0.0f;
    }

    public boolean hasCriticalHeap() {
        return this.criticalHeapSet;
    }

    @Override
    public float getCriticalOffHeapPercentage() {
        return this.criticalOffHeapPercentage;
    }

    @Override
    public void setCriticalOffHeapPercentage(float offHeapPercentage) {
        this.criticalOffHeapSet = true;
        this.criticalOffHeapPercentage = offHeapPercentage;
    }

    public void setCriticalOffHeapPercentageToDefault() {
        this.criticalOffHeapPercentage = 0.0f;
    }

    public boolean hasCriticalOffHeap() {
        return this.criticalOffHeapSet;
    }

    public void configure(ResourceManager r) {
        if (this.hasCriticalHeap()) {
            r.setCriticalHeapPercentage(this.criticalHeapPercentage);
        }
        if (this.hasCriticalOffHeap()) {
            r.setCriticalOffHeapPercentage(this.criticalOffHeapPercentage);
        }
        if (this.hasEvictionHeap()) {
            r.setEvictionHeapPercentage(this.evictionHeapPercentage);
        }
        if (this.hasEvictionOffHeap()) {
            r.setEvictionOffHeapPercentage(this.evictionOffHeapPercentage);
        }
    }

    public void sameAs(ResourceManager other) {
        if (this.getCriticalHeapPercentage() != other.getCriticalHeapPercentage()) {
            throw new RuntimeException("Resource Manager critical heap percentages differ: " + this.getCriticalHeapPercentage() + " != " + other.getCriticalHeapPercentage());
        }
        if (this.getCriticalOffHeapPercentage() != other.getCriticalOffHeapPercentage()) {
            throw new RuntimeException("Resource Manager critical off-heap percentages differ: " + this.getCriticalOffHeapPercentage() + " != " + other.getCriticalOffHeapPercentage());
        }
        if (this.hasEvictionHeap() && this.getEvictionHeapPercentage() != other.getEvictionHeapPercentage()) {
            throw new RuntimeException("Resource Manager eviction heap percentages differ: " + this.getEvictionHeapPercentage() + " != " + other.getEvictionHeapPercentage());
        }
        if (this.hasEvictionOffHeap() && this.getEvictionOffHeapPercentage() != other.getEvictionOffHeapPercentage()) {
            throw new RuntimeException("Resource Manager eviction off-heap percentages differ: " + this.getEvictionOffHeapPercentage() + " != " + other.getEvictionOffHeapPercentage());
        }
    }

    @Override
    public float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    @Override
    public void setEvictionHeapPercentage(float heapPercentage) {
        this.evictionHeapSet = true;
        this.evictionHeapPercentage = heapPercentage;
    }

    public void setEvictionHeapPercentageToDefault() {
        this.evictionHeapPercentage = 0.0f;
    }

    public boolean hasEvictionHeap() {
        return this.evictionHeapSet;
    }

    @Override
    public float getEvictionOffHeapPercentage() {
        return this.evictionOffHeapPercentage;
    }

    @Override
    public void setEvictionOffHeapPercentage(float offHeapPercentage) {
        this.evictionOffHeapSet = true;
        this.evictionOffHeapPercentage = offHeapPercentage;
    }

    public void setEvictionOffHeapPercentageToDefault() {
        this.evictionOffHeapPercentage = 0.0f;
    }

    public boolean hasEvictionOffHeap() {
        return this.evictionOffHeapSet;
    }
}

