/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.snapshot;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.EntrySnapshot;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.util.BlobHelper;

public class SnapshotPacket
implements DataSerializableFixedID {
    private int windowId;
    private String packetId;
    private DistributedMember sender;
    private SnapshotRecord[] records;

    public SnapshotPacket() {
    }

    public SnapshotPacket(int windowId, DistributedMember sender, List<SnapshotRecord> recs) {
        this.windowId = windowId;
        this.packetId = UUID.randomUUID().toString();
        this.sender = sender;
        this.records = recs.toArray(new SnapshotRecord[0]);
    }

    public int getWindowId() {
        return this.windowId;
    }

    public String getPacketId() {
        return this.packetId;
    }

    public DistributedMember getSender() {
        return this.sender;
    }

    public SnapshotRecord[] getRecords() {
        return this.records;
    }

    public int getDSFID() {
        return 2134;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.windowId);
        InternalDataSerializer.writeString(this.packetId, out);
        context.getSerializer().writeObject((Object)this.sender, out);
        InternalDataSerializer.writeArrayLength(this.records.length, out);
        for (SnapshotRecord rec : this.records) {
            InternalDataSerializer.invokeToData(rec, out);
        }
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.windowId = in.readInt();
        this.packetId = InternalDataSerializer.readString(in);
        this.sender = (DistributedMember)context.getDeserializer().readObject(in);
        int count = InternalDataSerializer.readArrayLength(in);
        this.records = new SnapshotRecord[count];
        for (int i = 0; i < count; ++i) {
            SnapshotRecord rec = new SnapshotRecord();
            InternalDataSerializer.invokeFromData(rec, in);
            this.records[i] = rec;
        }
    }

    public Version[] getSerializationVersions() {
        return null;
    }

    public static class SnapshotRecord
    implements DataSerializableFixedID {
        private byte[] key;
        private byte[] value;

        public SnapshotRecord() {
        }

        public SnapshotRecord(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public <K, V> SnapshotRecord(K keyObj, V valObj) throws IOException {
            this.key = BlobHelper.serializeToBlob(keyObj);
            this.value = this.convertToBytes(valObj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <K, V> SnapshotRecord(LocalRegion region, Map.Entry<K, V> entry) throws IOException {
            this.key = BlobHelper.serializeToBlob(entry.getKey());
            if (entry instanceof NonTXEntry && region != null) {
                Object v = ((NonTXEntry)entry).getRegionEntry().getValueOffHeapOrDiskWithoutFaultIn(region);
                try {
                    this.value = this.convertToBytes(v);
                }
                finally {
                    OffHeapHelper.release(v);
                }
            } else if (entry instanceof EntrySnapshot) {
                EntrySnapshot entrySnapshot = (EntrySnapshot)entry;
                Object entryValue = entrySnapshot.getValuePreferringCachedDeserializable();
                this.value = this.convertToBytes(entryValue);
            } else {
                this.value = this.convertToBytes(entry.getValue());
            }
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public <K> K getKeyObject() throws IOException, ClassNotFoundException {
            return (K)BlobHelper.deserializeBlob(this.key);
        }

        public <V> V getValueObject() throws IOException, ClassNotFoundException {
            return (V)(this.value == null ? null : BlobHelper.deserializeBlob(this.value));
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public int getSize() {
            return this.key.length + (this.value == null ? 0 : this.value.length);
        }

        public void toData(DataOutput out, SerializationContext context) throws IOException {
            InternalDataSerializer.writeByteArray(this.key, out);
            InternalDataSerializer.writeByteArray(this.value, out);
        }

        public int getDSFID() {
            return 2135;
        }

        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            this.key = InternalDataSerializer.readByteArray(in);
            this.value = InternalDataSerializer.readByteArray(in);
        }

        private byte[] convertToBytes(Object val) throws IOException {
            if (Token.isRemoved(val)) {
                throw new EntryDestroyedException();
            }
            if (Token.isInvalid(val)) {
                return null;
            }
            if (val instanceof CachedDeserializable) {
                byte[] bytes = ((CachedDeserializable)val).getSerializedValue();
                return bytes;
            }
            if (val != null) {
                return BlobHelper.serializeToBlob(val);
            }
            return null;
        }

        public Version[] getSerializationVersions() {
            return null;
        }
    }
}

