/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization;

import org.apache.geode.internal.serialization.VersionOrdinal;

public class VersionOrdinalImpl
implements VersionOrdinal {
    protected final short ordinal;

    VersionOrdinalImpl(short ordinal) {
        this.ordinal = ordinal;
    }

    @Override
    public short ordinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(VersionOrdinal other) {
        if (other == null) {
            return 1;
        }
        return this.compareTo(other.ordinal());
    }

    @Override
    public int compareTo(short other) {
        short thisOrdinal = this.ordinal;
        short otherOrdinal = other;
        return thisOrdinal - otherOrdinal;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof VersionOrdinalImpl) {
            return this.ordinal == ((VersionOrdinalImpl)other).ordinal;
        }
        return false;
    }

    public boolean equals(VersionOrdinal other) {
        return other != null && this.ordinal == other.ordinal();
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.ordinal;
        return result;
    }

    public String toString() {
        return VersionOrdinalImpl.toString(this.ordinal);
    }

    public static String toString(short ordinal) {
        return "VersionOrdinal[ordinal=" + ordinal + ']';
    }

    @Override
    public final boolean isOlderThan(VersionOrdinal version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public final boolean isNotOlderThan(VersionOrdinal version) {
        return this.compareTo(version) >= 0;
    }

    @Override
    public final boolean isNewerThan(VersionOrdinal version) {
        return this.compareTo(version) > 0;
    }

    @Override
    public final boolean isNotNewerThan(VersionOrdinal version) {
        return this.compareTo(version) <= 0;
    }
}

