/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.query.cq.internal.ServerCQResultsCache;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

class ServerCQResultsCacheReplicateRegionImpl
implements ServerCQResultsCache {
    private static final Logger logger = LogService.getLogger();
    public volatile boolean cqResultKeysInitialized = false;
    private final Map<Object, Object> cqResultKeys;
    private final Set<Object> destroysWhileCqResultsInProgress;
    private final Object LOCK = new Object();

    public ServerCQResultsCacheReplicateRegionImpl() {
        this.cqResultKeys = new HashMap<Object, Object>();
        this.destroysWhileCqResultsInProgress = new HashSet<Object>();
    }

    @Override
    public void setInitialized() {
        this.cqResultKeysInitialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.cqResultKeysInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cqResultKeys.put(key, TOKEN);
            if (!this.isInitialized()) {
                this.destroysWhileCqResultsInProgress.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key, boolean isTokenMode) {
        Object object = this.LOCK;
        synchronized (object) {
            if (isTokenMode && this.cqResultKeys.get(key) != Token.DESTROYED) {
                return;
            }
            this.cqResultKeys.remove(key);
            if (!this.isInitialized()) {
                this.destroysWhileCqResultsInProgress.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.cqResultKeys.clear();
            this.cqResultKeysInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) {
        if (!this.isInitialized()) {
            logger.warn("The CQ Result key cache is not initialized. This should not happen as the call to isPartOfCqResult() is based on the condition cqResultsCacheInitialized.");
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.destroysWhileCqResultsInProgress.forEach(this.cqResultKeys::remove);
            this.destroysWhileCqResultsInProgress.clear();
            return this.cqResultKeys.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsDestroyed(Object key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cqResultKeys.put(key, Token.DESTROYED);
            if (!this.isInitialized()) {
                this.destroysWhileCqResultsInProgress.add(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.cqResultKeys.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> getKeys() {
        Object object = this.LOCK;
        synchronized (object) {
            return Collections.synchronizedSet(new HashSet<Object>(this.cqResultKeys.keySet()));
        }
    }

    @Override
    public boolean isOldValueRequiredForQueryProcessing(Object key) {
        return !this.isInitialized() || !this.contains(key);
    }

    @Override
    public boolean isKeyDestroyed(Object key) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.cqResultKeys.clear();
        }
    }
}

