/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.connectors.jdbc.internal.cli.DescribeMappingResult;
import org.apache.geode.connectors.jdbc.internal.cli.MappingCommandUtils;
import org.apache.geode.connectors.jdbc.internal.cli.PreconditionException;
import org.apache.geode.connectors.jdbc.internal.configuration.FieldMapping;
import org.apache.geode.connectors.jdbc.internal.configuration.RegionMapping;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DescribeMappingCommand
extends GfshCommand {
    static final String DESCRIBE_MAPPING = "describe jdbc-mapping";
    private static final String DESCRIBE_MAPPING__HELP = "(Experimental) Describe the specified JDBC mapping";
    private static final String DESCRIBE_MAPPING__REGION_NAME = "region";
    private static final String DESCRIBE_MAPPING__REGION_NAME__HELP = "Region name of the JDBC mapping to be described.";
    private static final String DESCRIBE_MAPPING__GROUPS_NAME__HELP = "Server Group(s) of the JDBC mapping to be described.";
    public static final String RESULT_SECTION_NAME = "MappingDescription";

    @CliCommand(value={"describe jdbc-mapping"}, help="(Experimental) Describe the specified JDBC mapping")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel describeMapping(@CliOption(key={"region"}, mandatory=true, help="Region name of the JDBC mapping to be described.") String regionName, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Server Group(s) of the JDBC mapping to be described.") String[] groups) {
        if (regionName.startsWith("/")) {
            regionName = regionName.substring(1);
        }
        ArrayList<DescribeMappingResult> describeMappingResults = new ArrayList<DescribeMappingResult>();
        try {
            ConfigurationPersistenceService configService = this.checkForClusterConfiguration();
            if (groups == null) {
                groups = new String[]{"cluster"};
            }
            ArrayList<String> groupsArray = new ArrayList<String>();
            boolean isProxyRegion = false;
            for (String group : groups) {
                CacheConfig cacheConfig = this.getCacheConfig(configService, group);
                RegionConfig regionConfig = this.checkForRegion(regionName, cacheConfig, group);
                if (MappingCommandUtils.isAccessor(regionConfig.getRegionAttributes())) {
                    isProxyRegion = true;
                    continue;
                }
                groupsArray.add(group);
                describeMappingResults.addAll(this.getMappingsFromRegionConfig(cacheConfig, regionConfig, group));
            }
            if (groupsArray.size() == 0 && isProxyRegion) {
                return ResultModel.createInfo((String)"There is no jdbc mapping on proxy region.");
            }
        }
        catch (PreconditionException ex) {
            return ResultModel.createError((String)ex.getMessage());
        }
        if (describeMappingResults.isEmpty()) {
            throw new EntityNotFoundException("(Experimental) \nJDBC mapping for region '" + regionName + "' not found");
        }
        ResultModel resultModel = this.buildResultModel(describeMappingResults);
        resultModel.setHeader("(Experimental) ");
        return resultModel;
    }

    private CacheConfig getCacheConfig(ConfigurationPersistenceService configService, String group) throws PreconditionException {
        return MappingCommandUtils.getCacheConfig(configService, group);
    }

    private DescribeMappingResult buildDescribeMappingResult(RegionMapping regionMapping, String regionName, boolean synchronous, String group) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put(DESCRIBE_MAPPING__REGION_NAME, regionName);
        attributes.put("pdx-name", regionMapping.getPdxName());
        attributes.put("table", regionMapping.getTableName());
        attributes.put("data-source", regionMapping.getDataSourceName());
        attributes.put("synchronous", Boolean.toString(synchronous));
        attributes.put("id", regionMapping.getIds());
        attributes.put("id-user-specified", Boolean.toString(regionMapping.getSpecifiedIds()));
        if (regionMapping.getCatalog() != null) {
            attributes.put("catalog", regionMapping.getCatalog());
        }
        if (regionMapping.getSchema() != null) {
            attributes.put("schema", regionMapping.getSchema());
        }
        DescribeMappingResult result = new DescribeMappingResult(attributes);
        result.setGroupName(group);
        result.setFieldMappings(regionMapping.getFieldMappings());
        return result;
    }

    private ResultModel buildResultModel(ArrayList<DescribeMappingResult> describeMappingResult) {
        ResultModel resultModel = new ResultModel();
        for (int i = 0; i < describeMappingResult.size(); ++i) {
            DataResultModel sectionModel = resultModel.addData(RESULT_SECTION_NAME + i);
            DescribeMappingResult result = describeMappingResult.get(i);
            if (!result.getGroupName().equals("cluster")) {
                sectionModel.addData("Mapping for group", (Object)result.getGroupName());
            }
            result.getAttributeMap().forEach((arg_0, arg_1) -> ((DataResultModel)sectionModel).addData(arg_0, arg_1));
            TabularResultModel fieldMappingTable = resultModel.addTable("MappingDescriptionField Mappings" + i);
            List<FieldMapping> fieldMappings = result.getFieldMappings();
            fieldMappingTable.setHeader("PDX Field to JDBC Column Mappings");
            this.buildFieldMappingTable(fieldMappingTable, fieldMappings);
        }
        return resultModel;
    }

    private void buildFieldMappingTable(TabularResultModel fieldMappingTable, List<FieldMapping> fieldMappings) {
        fieldMappingTable.setColumnHeader(new String[]{"PDX Field", "PDX Type", "JDBC Column", "JDBC Type", "Nullable"});
        for (FieldMapping fieldMapping : fieldMappings) {
            fieldMappingTable.addRow(new String[]{fieldMapping.getPdxName(), fieldMapping.getPdxType(), fieldMapping.getJdbcName(), fieldMapping.getJdbcType(), Boolean.toString(fieldMapping.isJdbcNullable())});
        }
    }

    private ArrayList<DescribeMappingResult> getMappingsFromRegionConfig(CacheConfig cacheConfig, RegionConfig regionConfig, String group) {
        ArrayList<DescribeMappingResult> results = new ArrayList<DescribeMappingResult>();
        for (RegionMapping mapping : MappingCommandUtils.getMappingsFromRegionConfig(cacheConfig, regionConfig, group)) {
            results.add(this.buildDescribeMappingResult(mapping, regionConfig.getName(), MappingCommandUtils.isMappingSynchronous(cacheConfig, regionConfig), group));
        }
        return results;
    }

    private ConfigurationPersistenceService checkForClusterConfiguration() throws PreconditionException {
        ConfigurationPersistenceService result = this.getConfigurationPersistenceService();
        if (result == null) {
            throw new PreconditionException("Cluster Configuration must be enabled.");
        }
        return result;
    }

    private RegionConfig checkForRegion(String regionName, CacheConfig cacheConfig, String groupName) throws PreconditionException {
        return MappingCommandUtils.checkForRegion(regionName, cacheConfig, groupName);
    }

    @CliAvailabilityIndicator(value={"describe jdbc-mapping"})
    public boolean commandAvailable() {
        return this.isOnlineCommandAvailable();
    }
}

