/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.geode.cache.AttributesMutator;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.CacheLoader;
import org.apache.geode.cache.CacheWriter;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.RegionAttributesType;
import org.apache.geode.cache.configuration.RegionConfig;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.configuration.domain.DeclarableTypeInstantiator;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class RegionAlterFunction
extends CliFunction<RegionConfig> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = -4846425364943216425L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.RegionAlterFunction";

    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<RegionConfig> context) {
        InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
        RegionConfig deltaConfig = (RegionConfig)context.getArguments();
        this.alterRegion((Cache)cache, deltaConfig);
        return new CliFunctionResult(context.getMemberName(), (Object)Result.Status.OK, String.format("Region %s altered", deltaConfig.getName()));
    }

    private static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    void alterRegion(Cache cache, RegionConfig deltaConfig) {
        DeclarableType cacheWriter;
        DeclarableType cacheLoader;
        List newCacheListeners;
        String regionPathString = deltaConfig.getName();
        AbstractRegion region = (AbstractRegion)cache.getRegion(regionPathString);
        if (region == null) {
            throw new IllegalArgumentException(String.format("Region does not exist: %s", regionPathString));
        }
        AttributesMutator mutator = region.getAttributesMutator();
        RegionAttributesType regionAttributes = deltaConfig.getRegionAttributes();
        if (regionAttributes.isCloningEnabled() != null) {
            mutator.setCloningEnabled(regionAttributes.isCloningEnabled().booleanValue());
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cloning");
            }
        }
        if (regionAttributes.getEvictionAttributes() != null) {
            mutator.getEvictionAttributesMutator().setMaximum(Integer.parseInt(regionAttributes.getEvictionAttributes().getLruEntryCount().getMaximum()));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - eviction attributes max");
            }
        }
        this.updateExpirationAttributes(cache, regionAttributes.getEntryIdleTime(), region.getEntryIdleTimeout(), arg_0 -> ((AttributesMutator)mutator).setEntryIdleTimeout(arg_0), arg_0 -> ((AttributesMutator)mutator).setCustomEntryIdleTimeout(arg_0));
        this.updateExpirationAttributes(cache, regionAttributes.getEntryTimeToLive(), region.getEntryTimeToLive(), arg_0 -> ((AttributesMutator)mutator).setEntryTimeToLive(arg_0), arg_0 -> ((AttributesMutator)mutator).setCustomEntryTimeToLive(arg_0));
        this.updateExpirationAttributes(cache, regionAttributes.getRegionIdleTime(), region.getRegionIdleTimeout(), arg_0 -> ((AttributesMutator)mutator).setRegionIdleTimeout(arg_0), null);
        this.updateExpirationAttributes(cache, regionAttributes.getRegionTimeToLive(), region.getRegionTimeToLive(), arg_0 -> ((AttributesMutator)mutator).setRegionTimeToLive(arg_0), null);
        Set newGatewaySenderIds = regionAttributes.getGatewaySenderIdsAsSet();
        Set newAsyncEventQueueIds = regionAttributes.getAsyncEventQueueIdsAsSet();
        if (region instanceof PartitionedRegion) {
            HashSet senderIds = new HashSet();
            if (newGatewaySenderIds != null) {
                this.validateParallelGatewaySenderIDs((PartitionedRegion)region, newGatewaySenderIds);
                senderIds.addAll(newGatewaySenderIds);
            } else if (region.getGatewaySenderIds() != null) {
                senderIds.addAll(region.getAllGatewaySenderIds());
            }
            if (newAsyncEventQueueIds != null) {
                this.validateParallelAsynchronousEventQueueIDs((PartitionedRegion)region, newAsyncEventQueueIds);
                senderIds.addAll(newAsyncEventQueueIds);
            } else if (region.getAsyncEventQueueIds() != null) {
                senderIds.addAll(region.getAsyncEventQueueIds());
            }
            ((PartitionedRegion)region).updatePRConfigWithNewSetOfAsynchronousEventDispatchers(senderIds);
        }
        if (newGatewaySenderIds != null) {
            Set oldGatewaySenderIds = region.getGatewaySenderIds();
            oldGatewaySenderIds.stream().filter(RegionAlterFunction.not(newGatewaySenderIds::contains)).forEach(arg_0 -> ((AttributesMutator)mutator).removeGatewaySenderId(arg_0));
            newGatewaySenderIds.stream().filter(RegionAlterFunction.not(oldGatewaySenderIds::contains)).forEach(arg_0 -> ((AttributesMutator)mutator).addGatewaySenderId(arg_0));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - gateway sender IDs");
            }
        }
        if (newAsyncEventQueueIds != null) {
            Set oldAsyncEventQueueIds = region.getAsyncEventQueueIds();
            oldAsyncEventQueueIds.stream().filter(RegionAlterFunction.not(newAsyncEventQueueIds::contains)).forEach(arg_0 -> ((AttributesMutator)mutator).removeAsyncEventQueueId(arg_0));
            newAsyncEventQueueIds.stream().filter(RegionAlterFunction.not(oldAsyncEventQueueIds::contains)).forEach(arg_0 -> ((AttributesMutator)mutator).addAsyncEventQueueId(arg_0));
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - async event queue IDs");
            }
        }
        if (!(newCacheListeners = regionAttributes.getCacheListeners()).isEmpty()) {
            CacheListener[] oldCacheListeners = region.getCacheListeners();
            for (CacheListener oldCacheListener : oldCacheListeners) {
                mutator.removeCacheListener(oldCacheListener);
            }
            for (DeclarableType newCacheListener : newCacheListeners) {
                if (newCacheListener.equals((Object)DeclarableType.EMPTY)) continue;
                mutator.addCacheListener((CacheListener)DeclarableTypeInstantiator.newInstance((DeclarableType)newCacheListener, (Cache)cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache listeners");
            }
        }
        if ((cacheLoader = regionAttributes.getCacheLoader()) != null) {
            if (cacheLoader.equals((Object)DeclarableType.EMPTY)) {
                mutator.setCacheLoader(null);
            } else {
                mutator.setCacheLoader((CacheLoader)DeclarableTypeInstantiator.newInstance((DeclarableType)cacheLoader, (Cache)cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache loader");
            }
        }
        if ((cacheWriter = regionAttributes.getCacheWriter()) != null) {
            if (cacheWriter.equals((Object)DeclarableType.EMPTY)) {
                mutator.setCacheWriter(null);
            } else {
                mutator.setCacheWriter((CacheWriter)DeclarableTypeInstantiator.newInstance((DeclarableType)cacheWriter, (Cache)cache));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Region successfully altered - cache writer");
            }
        }
    }

    private void updateExpirationAttributes(Cache cache, RegionAttributesType.ExpirationAttributesType newAttributes, ExpirationAttributes existingAttributes, Consumer<ExpirationAttributes> mutator1, Consumer<CustomExpiry<Object, Object>> mutator2) {
        if (newAttributes == null) {
            return;
        }
        if (newAttributes.hasTimoutOrAction() && existingAttributes != null) {
            int existingTimeout = existingAttributes.getTimeout();
            ExpirationAction existingAction = existingAttributes.getAction();
            if (newAttributes.getTimeout() != null) {
                existingTimeout = Integer.parseInt(newAttributes.getTimeout());
            }
            if (newAttributes.getAction() != null) {
                existingAction = ExpirationAction.fromXmlString((String)newAttributes.getAction());
            }
            mutator1.accept(new ExpirationAttributes(existingTimeout, existingAction));
        }
        if (mutator2 == null) {
            return;
        }
        if (newAttributes.hasCustomExpiry()) {
            DeclarableType newCustomExpiry = newAttributes.getCustomExpiry();
            if (newCustomExpiry.equals((Object)DeclarableType.EMPTY)) {
                mutator2.accept(null);
            } else {
                mutator2.accept((CustomExpiry<Object, Object>)DeclarableTypeInstantiator.newInstance((DeclarableType)newCustomExpiry, (Cache)cache));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Region successfully altered - entry idle timeout");
        }
    }

    private void validateParallelGatewaySenderIDs(PartitionedRegion region, Set<String> newGatewaySenderIds) {
        try {
            Set parallelSenders = region.filterOutNonParallelGatewaySenders(newGatewaySenderIds);
            region.validateParallelAsynchronousEventDispatcherIds(parallelSenders);
        }
        catch (PRLocallyDestroyedException e) {
            throw new IllegalStateException("Partitioned Region not found registered", e);
        }
    }

    private void validateParallelAsynchronousEventQueueIDs(PartitionedRegion region, Set<String> newAsyncEventQueueIds) {
        try {
            Set parallelSenders = region.filterOutNonParallelAsyncEventQueues(newAsyncEventQueueIds);
            region.validateParallelAsynchronousEventDispatcherIds(parallelSenders);
        }
        catch (PRLocallyDestroyedException e) {
            throw new IllegalStateException("Partitioned Region not found registered", e);
        }
    }
}

