/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.alerting.internal.spi.AlertingAction;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.membership.api.MemberIdentifier;
import org.apache.geode.distributed.internal.membership.api.Membership;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.SystemTimer;
import org.apache.geode.internal.lang.utils.JavaWorkarounds;
import org.apache.geode.internal.logging.CoreLoggingExecutors;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.SocketCloser;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.internal.tcp.ConnectionException;
import org.apache.geode.internal.tcp.PeerConnectionFactory;
import org.apache.geode.internal.tcp.ReenteredConnectException;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ConnectionTable {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static boolean ulimitWarningIssued;
    private static final ThreadLocal<Boolean> threadWantsOwnResources;
    private final Map<DistributedMember, Object> orderedConnectionMap = new ConcurrentHashMap<DistributedMember, Object>();
    static final ThreadLocal<Map<DistributedMember, Connection>> threadOrderedConnMap;
    private SystemTimer idleConnTimer;
    private final ConcurrentMap<DistributedMember, List<Connection>> threadConnectionMap;
    private final Map<DistributedMember, Object> unorderedConnectionMap = new ConcurrentHashMap<DistributedMember, Object>();
    private final List<Connection> receivers = new ArrayList<Connection>();
    private final TCPConduit owner;
    private final BufferPool bufferPool;
    private volatile boolean closed;
    private final Executor p2pReaderThreadPool;
    private static final long READER_POOL_KEEP_ALIVE_TIME;
    private final SocketCloser socketCloser;
    @MakeNotStatic
    private static final AtomicReference<ConnectionTable> lastInstance;
    private final Map<Socket, ConnectingSocketInfo> connectingSockets = new HashMap<Socket, ConnectingSocketInfo>();

    public static void threadWantsSharedResources() {
        threadWantsOwnResources.set(Boolean.FALSE);
    }

    public static void threadWantsOwnResources() {
        threadWantsOwnResources.set(Boolean.TRUE);
    }

    private boolean threadOwnsResources() {
        DistributionManager d = this.getDM();
        if (d != null) {
            return d.getSystem().threadOwnsResources() && !AlertingAction.isThreadAlerting();
        }
        return false;
    }

    public static Boolean getThreadOwnsResourcesRegistration() {
        return threadWantsOwnResources.get();
    }

    public TCPConduit getOwner() {
        return this.owner;
    }

    public static ConnectionTable create(TCPConduit conduit) {
        ConnectionTable ct = new ConnectionTable(conduit);
        lastInstance.set(ct);
        return ct;
    }

    private ConnectionTable(TCPConduit conduit) {
        this.owner = conduit;
        this.idleConnTimer = this.owner.idleConnectionTimeout != 0 ? new SystemTimer(conduit.getDM().getSystem()) : null;
        this.threadConnectionMap = new ConcurrentHashMap<DistributedMember, List<Connection>>();
        this.p2pReaderThreadPool = this.createThreadPoolForIO(conduit.getDM().getSystem().isShareSockets());
        this.socketCloser = new SocketCloser();
        this.bufferPool = conduit.getBufferPool();
    }

    private Executor createThreadPoolForIO(boolean conserveSockets) {
        if (conserveSockets) {
            return LoggingExecutors.newThreadOnEachExecute((String)"SharedP2PReader");
        }
        return CoreLoggingExecutors.newThreadPoolWithSynchronousFeed(1, Integer.MAX_VALUE, READER_POOL_KEEP_ALIVE_TIME, TimeUnit.SECONDS, "UnsharedP2PReader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptConnection(Socket sock, PeerConnectionFactory peerConnectionFactory) throws IOException, ConnectionException {
        InetAddress connAddress = sock.getInetAddress();
        boolean finishedConnecting = false;
        Connection connection = null;
        try {
            connection = peerConnectionFactory.createReceiver(this, sock);
            this.owner.getCancelCriterion().checkCancelInProgress(null);
            finishedConnecting = true;
        }
        catch (IOException | ConnectionException ex) {
            this.owner.getCancelCriterion().checkCancelInProgress(ex);
            logger.warn("Failed to accept connection from {} because: {}", connAddress != null ? connAddress : "unavailable address", (Object)ex);
            throw ex;
        }
        finally {
            if (connection != null && !finishedConnecting) {
                ConnectionTable.closeCon("cancel after accept", connection);
                connection = null;
            }
        }
        if (connection != null) {
            List<Connection> list = this.receivers;
            synchronized (list) {
                this.owner.getStats().incReceivers();
                if (this.closed) {
                    ConnectionTable.closeCon("Connection table no longer in use", connection);
                    return;
                }
                if (!connection.isSocketClosed() && !connection.isReceiverStopped()) {
                    this.receivers.add(connection);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Accepted {} myAddr={} theirAddr={}", (Object)connection, (Object)this.getConduit().getMemberId(), (Object)connection.getRemoteAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection handleNewPendingConnection(InternalDistributedMember id, boolean sharedResource, boolean preserveOrder, Map<DistributedMember, Object> m, PendingConnection pc, long startTime, long ackThreshold, long ackSAThreshold) throws IOException, DistributedSystemDisconnectedException {
        Connection con = null;
        try {
            long senderCreateStartTime = this.owner.getStats().startSenderCreate();
            con = Connection.createSender(this.owner.getMembership(), this, preserveOrder, id, sharedResource, startTime, ackThreshold, ackSAThreshold);
            this.owner.getStats().incSenders(sharedResource, preserveOrder, senderCreateStartTime);
        }
        finally {
            if (con == null) {
                this.owner.getStats().incFailedConnect();
                Map<DistributedMember, Object> map = m;
                synchronized (map) {
                    Object rmObj = m.remove(id);
                    if (rmObj != pc && rmObj != null) {
                        m.put(id, rmObj);
                    }
                }
                pc.notifyWaiters(null);
            }
        }
        Map<DistributedMember, Object> map = m;
        synchronized (map) {
            Object e = m.get(id);
            if (e == pc) {
                m.put(id, con);
            } else if (e == null) {
                con.requestClose("pending connection cancelled");
                con = null;
            } else if (e instanceof Connection) {
                Connection newCon = (Connection)e;
                if (!newCon.connected) {
                    if (con != null) {
                        con.requestClose("pending connection closed");
                        con = null;
                    }
                } else {
                    if (con != null) {
                        con.requestClose("someone else created the connection");
                    }
                    con = newCon;
                }
            }
        }
        pc.notifyWaiters(con);
        if (con != null && logger.isDebugEnabled()) {
            logger.debug("handleNewPendingConnection {} myAddr={} theirAddr={}", (Object)con, (Object)this.getConduit().getMemberId(), (Object)con.getRemoteAddress());
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getSharedConnection(InternalDistributedMember id, boolean scheduleTimeout, boolean preserveOrder, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        Connection result;
        Object mEntry;
        Map<DistributedMember, Object> m = preserveOrder ? this.orderedConnectionMap : this.unorderedConnectionMap;
        PendingConnection pc = null;
        Map<DistributedMember, Object> map = m;
        synchronized (map) {
            mEntry = m.get(id);
            if (mEntry instanceof Connection) {
                Connection existingCon = (Connection)mEntry;
                if (!existingCon.connected) {
                    mEntry = null;
                }
            }
            if (mEntry == null) {
                pc = new PendingConnection(preserveOrder, id);
                m.put(id, pc);
            }
        }
        if (pc != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("created PendingConnection {}", (Object)pc);
            }
            result = this.handleNewPendingConnection(id, true, preserveOrder, m, pc, startTime, ackTimeout, ackSATimeout);
            if (!preserveOrder && scheduleTimeout) {
                this.scheduleIdleTimeout(result);
            }
        } else if (mEntry instanceof PendingConnection) {
            if (AlertingAction.isThreadAlerting()) {
                throw new IOException("Cannot form connection to alert listener " + id);
            }
            result = ((PendingConnection)mEntry).waitForConnect((Membership<InternalDistributedMember>)this.owner.getMembership(), startTime, ackTimeout, ackSATimeout);
            if (logger.isDebugEnabled()) {
                if (result != null) {
                    logger.debug("getSharedConnection {} myAddr={} theirAddr={}", (Object)result, (Object)this.getConduit().getMemberId(), (Object)result.getRemoteAddress());
                } else {
                    logger.debug("getSharedConnection: Connect failed");
                }
            }
        } else {
            result = (Connection)mEntry;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getThreadOwnedConnection(InternalDistributedMember id, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        List al;
        Connection result;
        Map<DistributedMember, Connection> m = threadOrderedConnMap.get();
        if (m == null) {
            m = new HashMap<DistributedMember, Connection>();
            threadOrderedConnMap.set(m);
        } else {
            result = m.get(id);
            if (result != null && !result.timedOut) {
                return result;
            }
        }
        long senderCreateStartTime = this.owner.getStats().startSenderCreate();
        result = Connection.createSender(this.owner.getMembership(), this, true, id, false, startTime, ackTimeout, ackSATimeout);
        this.owner.getStats().incSenders(false, true, senderCreateStartTime);
        if (logger.isDebugEnabled()) {
            logger.debug("ConnectionTable: created an ordered connection: {}", (Object)result);
        }
        List list = al = (List)JavaWorkarounds.computeIfAbsent(this.threadConnectionMap, (Object)id, k -> new ArrayList());
        synchronized (list) {
            al.add(result);
        }
        m.put(id, result);
        this.scheduleIdleTimeout(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleIdleTimeout(Connection conn) {
        if (conn == null) {
            return;
        }
        if (this.owner.idleConnectionTimeout != 0) {
            try {
                ConnectionTable connectionTable = this;
                synchronized (connectionTable) {
                    if (!this.closed) {
                        IdleConnTT task = new IdleConnTT(conn);
                        conn.setIdleTimeoutTask(task);
                        IdleConnTT idleConnTT = task;
                        synchronized (idleConnTT) {
                            if (!task.isCancelled()) {
                                this.getIdleConnTimer().scheduleAtFixedRate(task, this.owner.idleConnectionTimeout, this.owner.idleConnectionTimeout);
                            }
                        }
                    }
                }
            }
            catch (IllegalStateException e) {
                if (conn.isClosing()) {
                    return;
                }
                logger.debug("Got an illegal state exception: {}", (Object)e.getMessage(), (Object)e);
                this.owner.getCancelCriterion().checkCancelInProgress(null);
                Exception cause = this.owner.getShutdownCause();
                if (cause == null) {
                    cause = e;
                }
                throw new DistributedSystemDisconnectedException("The distributed system is shutting down", cause);
            }
        }
    }

    protected Connection get(InternalDistributedMember id, boolean preserveOrder, long startTime, long ackTimeout, long ackSATimeout) throws IOException, DistributedSystemDisconnectedException {
        if (this.closed) {
            this.owner.getCancelCriterion().checkCancelInProgress(null);
            throw new DistributedSystemDisconnectedException("Connection table is closed");
        }
        boolean threadOwnsResources = this.threadOwnsResources();
        Connection result = !preserveOrder || !threadOwnsResources ? this.getSharedConnection(id, threadOwnsResources, preserveOrder, startTime, ackTimeout, ackSATimeout) : this.getThreadOwnedConnection(id, startTime, ackTimeout, ackSATimeout);
        if (result != null) {
            Assert.assertTrue(result.getPreserveOrder() == preserveOrder);
        }
        return result;
    }

    synchronized void fileDescriptorsExhausted() {
        if (!ulimitWarningIssued) {
            ulimitWarningIssued = true;
            logger.fatal("This process is out of file descriptors.This will hamper communications and slow down the system.Any conserve-sockets setting is now being ignored.Please consider raising the descriptor limit.This alert is only issued once per process.");
            InternalDistributedSystem.getAnyInstance().setShareSockets(true);
        }
    }

    TCPConduit getConduit() {
        return this.owner;
    }

    BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private static void closeCon(String reason, Object c) {
        ConnectionTable.closeCon(reason, c, false);
    }

    private static void closeCon(String reason, Object c, boolean beingSick) {
        if (c == null) {
            return;
        }
        if (c instanceof Connection) {
            ((Connection)c).closePartialConnect(reason, beingSick);
        } else {
            ((PendingConnection)c).notifyWaiters(null);
        }
    }

    synchronized SystemTimer getIdleConnTimer() {
        if (this.closed) {
            return null;
        }
        if (this.idleConnTimer == null) {
            this.idleConnTimer = new SystemTimer(this.getDM().getSystem());
        }
        return this.idleConnTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Executor localExec;
        if (this.closed) {
            return;
        }
        this.closed = true;
        Map<DistributedMember, Object> map = this;
        synchronized (map) {
            if (this.idleConnTimer != null) {
                this.idleConnTimer.cancel();
            }
        }
        map = this.orderedConnectionMap;
        synchronized (map) {
            for (Object o : this.orderedConnectionMap.values()) {
                ConnectionTable.closeCon("Connection table being destroyed", o);
            }
            this.orderedConnectionMap.clear();
        }
        map = this.unorderedConnectionMap;
        synchronized (map) {
            for (Object o : this.unorderedConnectionMap.values()) {
                ConnectionTable.closeCon("Connection table being destroyed", o);
            }
            this.unorderedConnectionMap.clear();
        }
        if (this.threadConnectionMap != null) {
            map = this.threadConnectionMap;
            synchronized (map) {
                Iterator<Object> iterator = this.threadConnectionMap.values().iterator();
                while (iterator.hasNext()) {
                    List connections;
                    List list = connections = (List)iterator.next();
                    synchronized (list) {
                        for (Object o : connections) {
                            ConnectionTable.closeCon("Connection table being destroyed", o);
                        }
                    }
                }
                this.threadConnectionMap.clear();
            }
        }
        if ((localExec = this.p2pReaderThreadPool) != null && localExec instanceof ExecutorService) {
            ((ExecutorService)localExec).shutdown();
        }
        this.closeReceivers(false);
        Map<DistributedMember, Connection> map2 = threadOrderedConnMap.get();
        if (map2 != null) {
            map2.clear();
        }
        this.socketCloser.close();
    }

    public void executeCommand(Runnable runnable) {
        Executor local = this.p2pReaderThreadPool;
        if (local != null) {
            local.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeReceivers(boolean beingSick) {
        List<Connection> list = this.receivers;
        synchronized (list) {
            Iterator<Connection> it = this.receivers.iterator();
            while (it.hasNext()) {
                Connection con = it.next();
                if (beingSick && !con.getPreserveOrder()) continue;
                ConnectionTable.closeCon("Connection table being destroyed", con, beingSick);
                it.remove();
            }
            Map<Socket, ConnectingSocketInfo> map = this.connectingSockets;
            synchronized (map) {
                Iterator<Map.Entry<Socket, ConnectingSocketInfo>> it2 = this.connectingSockets.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry<Socket, ConnectingSocketInfo> entry = it2.next();
                    try {
                        entry.getKey().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    it2.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReceiver(Connection con) {
        List<Connection> list = this.receivers;
        synchronized (list) {
            this.receivers.remove(con);
        }
    }

    protected void removeEndpoint(DistributedMember stub, String reason) {
        this.removeEndpoint(stub, reason, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEndpoint(DistributedMember memberID, String reason, boolean notifyDisconnect) {
        Object al;
        ConcurrentMap<DistributedMember, List<Connection>> cm;
        if (this.closed) {
            return;
        }
        boolean needsRemoval = false;
        Map<DistributedMember, Object> map = this.orderedConnectionMap;
        synchronized (map) {
            if (this.orderedConnectionMap.get(memberID) != null) {
                needsRemoval = true;
            }
        }
        if (!needsRemoval) {
            map = this.unorderedConnectionMap;
            synchronized (map) {
                if (this.unorderedConnectionMap.get(memberID) != null) {
                    needsRemoval = true;
                }
            }
        }
        if (!needsRemoval && (cm = this.threadConnectionMap) != null) {
            al = (List)cm.get(memberID);
            boolean bl = needsRemoval = al != null && !al.isEmpty();
        }
        if (needsRemoval) {
            Iterator iterator;
            List al2;
            Object c;
            InternalDistributedMember remoteAddress = null;
            al = this.orderedConnectionMap;
            synchronized (al) {
                c = this.orderedConnectionMap.remove(memberID);
                if (c instanceof Connection) {
                    remoteAddress = ((Connection)c).getRemoteAddress();
                }
                ConnectionTable.closeCon(reason, c);
            }
            al = this.unorderedConnectionMap;
            synchronized (al) {
                c = this.unorderedConnectionMap.remove(memberID);
                if (remoteAddress == null && c instanceof Connection) {
                    remoteAddress = ((Connection)c).getRemoteAddress();
                }
                ConnectionTable.closeCon(reason, c);
            }
            ConcurrentMap<DistributedMember, List<Connection>> cm2 = this.threadConnectionMap;
            if (cm2 != null && (al2 = (List)cm2.remove(memberID)) != null) {
                iterator = al2;
                synchronized (iterator) {
                    for (Connection c2 : al2) {
                        if (remoteAddress == null && c2 != null) {
                            remoteAddress = c2.getRemoteAddress();
                        }
                        ConnectionTable.closeCon(reason, c2);
                    }
                    al2.clear();
                }
            }
            HashSet<Socket> toRemove = new HashSet<Socket>();
            iterator = this.connectingSockets;
            synchronized (iterator) {
                Iterator<Map.Entry<Socket, ConnectingSocketInfo>> it = this.connectingSockets.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Socket, ConnectingSocketInfo> entry = it.next();
                    ConnectingSocketInfo info = entry.getValue();
                    if (!info.peerAddress.equals(((MemberIdentifier)memberID).getInetAddress())) continue;
                    toRemove.add(entry.getKey());
                    it.remove();
                }
            }
            for (Socket sock : toRemove) {
                try {
                    sock.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("caught exception while trying to close connecting socket for {}", (Object)memberID, (Object)e);
                }
            }
            HashSet<Connection> connectionsToClose = new HashSet<Connection>();
            Iterator iterator2 = this.receivers;
            synchronized (iterator2) {
                Iterator<Connection> it = this.receivers.iterator();
                while (it.hasNext()) {
                    Connection con = it.next();
                    if (!memberID.equals(con.getRemoteAddress())) continue;
                    it.remove();
                    connectionsToClose.add(con);
                }
            }
            for (Connection con : connectionsToClose) {
                ConnectionTable.closeCon(reason, con);
            }
            if (notifyDisconnect && this.owner.getDM().shutdownInProgress()) {
                throw new DistributedSystemDisconnectedException("Shutdown in progress", this.owner.getDM().getDistribution().getShutdownCause());
            }
            if (remoteAddress != null) {
                this.socketCloser.releaseResourcesForAddress(remoteAddress.toString());
            }
        }
    }

    SocketCloser getSocketCloser() {
        return this.socketCloser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasReceiversFor(DistributedMember endPoint) {
        List<Connection> list = this.receivers;
        synchronized (list) {
            for (Connection receiver : this.receivers) {
                if (!endPoint.equals(receiver.getRemoteAddress())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromThreadConMap(ConcurrentMap<DistributedMember, List<Connection>> cm, DistributedMember stub, Connection c) {
        List al;
        if (cm != null && (al = (List)cm.get(stub)) != null) {
            List list = al;
            synchronized (list) {
                al.remove(c);
            }
        }
    }

    void removeThreadConnection(DistributedMember stub, Connection c) {
        ConnectionTable.removeFromThreadConMap(this.threadConnectionMap, stub, c);
        Map<DistributedMember, Connection> m = threadOrderedConnMap.get();
        if (m != null && m.get(stub) == c) {
            m.remove(stub);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSharedConnection(String reason, DistributedMember stub, boolean ordered, Connection c) {
        if (this.closed) {
            return;
        }
        if (ordered) {
            Map<DistributedMember, Object> map = this.orderedConnectionMap;
            synchronized (map) {
                if (this.orderedConnectionMap.get(stub) == c) {
                    ConnectionTable.closeCon(reason, this.orderedConnectionMap.remove(stub));
                }
            }
        }
        Map<DistributedMember, Object> map = this.unorderedConnectionMap;
        synchronized (map) {
            if (this.unorderedConnectionMap.get(stub) == c) {
                ConnectionTable.closeCon(reason, this.unorderedConnectionMap.remove(stub));
            }
        }
    }

    @VisibleForTesting
    public static long getNumSenderSharedConnections() {
        ConnectionTable ct = lastInstance.get();
        if (ct == null) {
            return 0L;
        }
        return ct.getConduit().getStats().getSendersSU();
    }

    public static void emergencyClose() {
        ConnectionTable ct = lastInstance.get();
        if (ct == null) {
            return;
        }
        lastInstance.set(null);
    }

    void removeAndCloseThreadOwnedSockets() {
        Map<DistributedMember, Connection> m = threadOrderedConnMap.get();
        if (m != null) {
            Iterator<Map.Entry<DistributedMember, Connection>> it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<DistributedMember, Connection> me = it.next();
                DistributedMember stub = me.getKey();
                Connection c = me.getValue();
                ConnectionTable.removeFromThreadConMap(this.threadConnectionMap, stub, c);
                it.remove();
                ConnectionTable.closeCon("thread finalization", c);
            }
        }
    }

    public static void releaseThreadsSockets() {
        ConnectionTable ct = lastInstance.get();
        if (ct == null) {
            return;
        }
        ct.removeAndCloseThreadOwnedSockets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getThreadOwnedOrderedConnectionState(DistributedMember member, Map<Long, Long> result) {
        ArrayList al;
        if (this.threadConnectionMap != null && (al = (ArrayList)this.threadConnectionMap.get(member)) != null) {
            ArrayList arrayList = al;
            synchronized (arrayList) {
                al = new ArrayList(al);
            }
            for (Connection connection : al) {
                if (connection.isSharedResource() || !connection.getOriginatedHere() || !connection.getPreserveOrder()) continue;
                result.put(connection.getUniqueId(), connection.getMessagesSent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForThreadOwnedOrderedConnectionState(DistributedMember member, Map<Long, Long> connectionStates) throws InterruptedException {
        ArrayList<Connection> r;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        List<Connection> list = this.receivers;
        synchronized (list) {
            r = new ArrayList<Connection>(this.receivers);
        }
        for (Connection con : r) {
            Long state;
            if (con.stopped || con.isClosing() || con.getOriginatedHere() || !con.getPreserveOrder() || !member.equals(con.getRemoteAddress()) || (state = connectionStates.remove(con.getUniqueId())) == null) continue;
            long count = state;
            while (!con.stopped && !con.isClosing() && con.getMessagesReceived() < count) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for connection {}/{} currently={} need={}", (Object)con.getRemoteAddress(), (Object)con.getUniqueId(), (Object)con.getMessagesReceived(), (Object)count);
                }
                Thread.sleep(100L);
            }
        }
        if (!connectionStates.isEmpty() && logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("These connections from ");
            sb.append(member);
            sb.append("could not be located during waitForThreadOwnedOrderedConnectionState: ");
            Iterator<Map.Entry<Long, Long>> it = connectionStates.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, Long> entry = it.next();
                sb.append(entry.getKey()).append('(').append(entry.getValue()).append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            logger.debug((CharSequence)sb);
        }
    }

    protected DistributionManager getDM() {
        return this.owner.getDM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnectingSocket(Socket socket, InetAddress addr) {
        Map<Socket, ConnectingSocketInfo> map = this.connectingSockets;
        synchronized (map) {
            this.connectingSockets.put(socket, new ConnectingSocketInfo(addr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnectingSocket(Socket socket) {
        Map<Socket, ConnectingSocketInfo> map = this.connectingSockets;
        synchronized (map) {
            this.connectingSockets.remove(socket);
        }
    }

    int getNumberOfReceivers() {
        return this.receivers.size();
    }

    static {
        threadWantsOwnResources = new ThreadLocal();
        threadOrderedConnMap = new ThreadLocal();
        READER_POOL_KEEP_ALIVE_TIME = Long.getLong("p2p.READER_POOL_KEEP_ALIVE_TIME", 120L);
        lastInstance = new AtomicReference();
    }

    private static class ConnectingSocketInfo {
        private final InetAddress peerAddress;

        private ConnectingSocketInfo(InetAddress addr) {
            this.peerAddress = addr;
        }
    }

    private static class IdleConnTT
    extends SystemTimer.SystemTimerTask {
        private Connection connection;

        private IdleConnTT(Connection c) {
            this.connection = c;
        }

        @Override
        public boolean cancel() {
            Connection con = this.connection;
            if (con != null) {
                con.cleanUpOnIdleTaskCancel();
            }
            this.connection = null;
            return super.cancel();
        }

        @Override
        public void run2() {
            Connection con = this.connection;
            if (con != null && con.checkForIdleTimeout()) {
                this.cancel();
            }
        }
    }

    private class PendingConnection {
        private boolean pending = true;
        private Connection conn;
        private final boolean preserveOrder;
        private final DistributedMember id;
        private final Thread connectingThread;

        private PendingConnection(boolean preserveOrder, DistributedMember id) {
            this.preserveOrder = preserveOrder;
            this.id = id;
            this.connectingThread = Thread.currentThread();
        }

        private synchronized void notifyWaiters(Connection c) {
            if (!this.pending) {
                return;
            }
            this.conn = c;
            this.pending = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Notifying waiters that pending {} connection to {} is ready; {}", (Object)(this.preserveOrder ? "ordered" : "unordered"), (Object)this.id, (Object)this);
            }
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Connection waitForConnect(Membership<InternalDistributedMember> mgr, long startTime, long ackTimeout, long ackSATimeout) {
            if (this.connectingThread == Thread.currentThread()) {
                throw new ReenteredConnectException("This thread is already trying to connect");
            }
            Map m = this.preserveOrder ? ConnectionTable.this.orderedConnectionMap : ConnectionTable.this.unorderedConnectionMap;
            DistributedMember targetMember = null;
            if (ackSATimeout > 0L) {
                targetMember = this.id;
            }
            boolean suspected = false;
            boolean severeAlertIssued = false;
            int attempt = 0;
            while (this.pending) {
                Object e;
                ConnectionTable.this.getConduit().getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e2) {
                    interrupted = true;
                    ConnectionTable.this.getConduit().getCancelCriterion().checkCancelInProgress(e2);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!this.pending) break;
                long now = System.currentTimeMillis();
                if (!severeAlertIssued && ackSATimeout > 0L && startTime + ackTimeout < now) {
                    if (startTime + ackTimeout + ackSATimeout < now) {
                        if (targetMember != null) {
                            logger.fatal("Unable to form a TCP/IP connection to {} in over {} seconds", (Object)targetMember, (Object)((ackSATimeout + ackTimeout) / 1000L));
                        }
                        severeAlertIssued = true;
                    } else if (!suspected) {
                        logger.warn("Unable to form a TCP/IP connection to {} in over {} seconds", (Object)this.id, (Object)(ackTimeout / 1000L));
                        mgr.suspectMember((MemberIdentifier)((InternalDistributedMember)targetMember), "Unable to form a TCP/IP connection in a reasonable amount of time");
                        suspected = true;
                    }
                }
                if ((e = m.get(this.id)) == this) {
                    if (!logger.isDebugEnabled() || ++attempt % 20 != 1) continue;
                    logger.debug("Waiting for pending connection to complete: {} connection to {}; {}", (Object)(this.preserveOrder ? "ordered" : "unordered"), (Object)this.id, (Object)this);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Pending connection changed to {} unexpectedly", e);
                }
                if (e == null) {
                    this.notifyWaiters(null);
                    break;
                }
                if (e instanceof Connection) {
                    this.notifyWaiters((Connection)e);
                    break;
                }
                return ((PendingConnection)e).waitForConnect(mgr, startTime, ackTimeout, ackSATimeout);
            }
            return this.conn;
        }

        public String toString() {
            return super.toString() + " created by " + this.connectingThread.getName();
        }
    }
}

