/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Function;
import org.apache.geode.CopyHelper;
import org.apache.geode.DataSerializer;
import org.apache.geode.Delta;
import org.apache.geode.DeltaSerializationException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.EntryOperation;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.SerializedCacheValue;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.cache.query.IndexMaintenanceException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.util.TimestampedEntryEvent;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterProfile;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalEntryEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.TXEntryState;
import org.apache.geode.internal.cache.TXId;
import org.apache.geode.internal.cache.TimestampedEntryEventImpl;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.WrappedCallbackArgument;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PutMessage;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tx.DistTxKeyInfo;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemotePutMessage;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.cache.wan.GatewaySenderEventCallbackArgument;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.OffHeapHelper;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.offheap.ReferenceCountHelper;
import org.apache.geode.internal.offheap.Releasable;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.util.ArrayUtils;
import org.apache.geode.internal.util.BlobHelper;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class EntryEventImpl
implements InternalEntryEvent,
InternalCacheEvent,
DataSerializableFixedID,
EntryOperation,
Releasable {
    private static final Logger logger = LogService.getLogger();
    private transient InternalRegion region;
    private transient RegionEntry re;
    protected KeyInfo keyInfo;
    protected EventID eventID;
    private Object newValue = null;
    private byte[] cachedSerializedNewValue = null;
    private Object oldValue = null;
    protected short eventFlags = 0;
    protected TXId txId = null;
    protected Operation op;
    private transient EnumListenerEvent eventType;
    protected transient DistributedPutAllOperation putAllOp;
    protected transient DistributedRemoveAllOperation removeAllOp;
    protected DistributedMember distributedMember;
    transient DistributionMessage causedByMessage;
    protected ClientProxyMembershipID context = null;
    private byte[] deltaBytes = null;
    private FilterRoutingInfo.FilterInfo filterInfo;
    protected byte[] newValueBytes;
    private byte[] oldValueBytes;
    protected VersionTag versionTag;
    private transient boolean isEvicted = false;
    private transient boolean isPendingSecondaryExpireDestroy = false;
    private transient boolean hasRetried = false;
    public static final Object SUSPECT_TOKEN = new Object();
    private boolean readOldValueFromDisk;
    private final Object offHeapLock;
    private static final boolean EVENT_OLD_VALUE = !Boolean.getBoolean("gemfire.disable-event-old-value");
    private transient int newValueBucketSize;
    protected Long tailKey = -1L;
    protected transient long nextRegionVersion = -1L;
    private Thread invokeCallbacksThread;
    transient boolean offHeapOk = true;

    public EntryEventImpl() {
        this.offHeapLock = null;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.eventID = (EventID)context.getDeserializer().readObject(in);
        Object key = context.getDeserializer().readObject(in);
        Object value = context.getDeserializer().readObject(in);
        this.keyInfo = new KeyInfo(key, value, null);
        this.op = Operation.fromOrdinal(in.readByte());
        this.eventFlags = in.readShort();
        this.keyInfo.setCallbackArg(context.getDeserializer().readObject(in));
        this.txId = (TXId)context.getDeserializer().readObject(in);
        if (in.readBoolean()) {
            assert (false) : "isDelta should never be true";
        } else if (in.readBoolean()) {
            this.newValueBytes = DataSerializer.readByteArray(in);
            this.cachedSerializedNewValue = this.newValueBytes;
            this.newValue = null;
        } else {
            this.newValueBytes = null;
            this.cachedSerializedNewValue = null;
            this.newValue = context.getDeserializer().readObject(in);
        }
        if (in.readBoolean()) {
            this.oldValueBytes = DataSerializer.readByteArray(in);
            this.oldValue = null;
        } else {
            this.oldValueBytes = null;
            this.oldValue = context.getDeserializer().readObject(in);
        }
        this.distributedMember = DSFIDFactory.readInternalDistributedMember(in);
        this.context = ClientProxyMembershipID.readCanonicalized(in);
        this.tailKey = DataSerializer.readLong(in);
    }

    protected EntryEventImpl(InternalRegion region, Operation op, Object key, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean fromRILocalDestroy) {
        this.region = region;
        InternalDistributedSystem ds = (InternalDistributedSystem)region.getCache().getDistributedSystem();
        this.offHeapLock = ds.getOffHeapStore() != null ? new Object() : null;
        this.op = op;
        this.keyInfo = region.getKeyInfo(key);
        this.setOriginRemote(originRemote);
        this.setGenerateCallbacks(generateCallbacks);
        this.distributedMember = distributedMember;
        this.setFromRILocalDestroy(fromRILocalDestroy);
    }

    protected EntryEventImpl(InternalRegion region, Operation op, Object key, Object newVal, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean initializeId) {
        this.region = region;
        InternalDistributedSystem ds = (InternalDistributedSystem)region.getCache().getDistributedSystem();
        this.offHeapLock = ds.getOffHeapStore() != null ? new Object() : null;
        this.op = op;
        this.keyInfo = region.getKeyInfo(key, newVal, callbackArgument);
        if (!Token.isInvalid(newVal)) {
            this.basicSetNewValue(newVal, false);
        }
        this.txId = region.getTXId();
        if (newVal == Token.LOCAL_INVALID) {
            this.setLocalInvalid(true);
        }
        this.setOriginRemote(originRemote);
        this.setGenerateCallbacks(generateCallbacks);
        this.distributedMember = distributedMember;
    }

    protected EntryEventImpl(InternalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, EventID eventID) {
        this(region, op, key, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, true);
        Assert.assertTrue(eventID != null || !(region instanceof PartitionedRegion));
        this.setEventId(eventID);
    }

    public EntryEventImpl(EntryEventImpl other) {
        this(other, true);
    }

    public EntryEventImpl(EntryEventImpl other, boolean setOldValue) {
        this.setRegion(other.getRegion());
        this.offHeapLock = other.offHeapLock != null ? new Object() : null;
        this.eventID = other.eventID;
        this.basicSetNewValue(other.basicGetNewValue(), false);
        this.newValueBytes = other.newValueBytes;
        this.cachedSerializedNewValue = other.cachedSerializedNewValue;
        this.re = other.re;
        if (setOldValue) {
            this.retainAndSetOldValue(other.basicGetOldValue());
            this.oldValueBytes = other.oldValueBytes;
        }
        this.eventFlags = other.eventFlags;
        this.setEventFlag((short)128, false);
        this.txId = other.txId;
        this.op = other.op;
        this.distributedMember = other.distributedMember;
        this.filterInfo = other.filterInfo;
        KeyInfo keyInfo = this.keyInfo = other.keyInfo.isDistKeyInfo() ? new DistTxKeyInfo((DistTxKeyInfo)other.keyInfo) : new KeyInfo(other.keyInfo);
        if (other.getRawCallbackArgument() instanceof GatewaySenderEventCallbackArgument) {
            this.keyInfo.setCallbackArg(new GatewaySenderEventCallbackArgument((GatewaySenderEventCallbackArgument)other.getRawCallbackArgument()));
        }
        this.context = other.context;
        this.deltaBytes = other.deltaBytes;
        this.tailKey = other.tailKey;
        this.versionTag = other.versionTag;
        this.setPossibleDuplicate(other.isPossibleDuplicate());
    }

    public EntryEventImpl(Object key2, boolean isOffHeap) {
        this.keyInfo = new KeyInfo(key2, null, null);
        this.offHeapLock = isOffHeap ? new Object() : null;
    }

    public static EntryEventImpl create(InternalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember) {
        return EntryEventImpl.create(region, op, key, newValue, callbackArgument, originRemote, distributedMember, true, true);
    }

    public static EntryEventImpl create(InternalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks) {
        return EntryEventImpl.create(region, op, key, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, true);
    }

    public static EntryEventImpl create(InternalRegion region, Operation op, Object key, Object newValue, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, EventID eventID) {
        return new EntryEventImpl(region, op, key, newValue, callbackArgument, originRemote, distributedMember, generateCallbacks, eventID);
    }

    public static EntryEventImpl create(InternalRegion region, Operation op, Object key, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean fromRILocalDestroy) {
        return new EntryEventImpl(region, op, key, originRemote, distributedMember, generateCallbacks, fromRILocalDestroy);
    }

    public static EntryEventImpl create(InternalRegion region, Operation op, Object key, Object newVal, Object callbackArgument, boolean originRemote, DistributedMember distributedMember, boolean generateCallbacks, boolean initializeId) {
        return new EntryEventImpl(region, op, key, newVal, callbackArgument, originRemote, distributedMember, generateCallbacks, initializeId);
    }

    static EntryEventImpl createPutAllEvent(DistributedPutAllOperation putAllOp, InternalRegion region, Operation entryOp, Object entryKey, Object entryNewValue) {
        EntryEventImpl e;
        if (putAllOp != null) {
            EntryEventImpl event = putAllOp.getBaseEvent();
            if (event.isBridgeEvent()) {
                e = EntryEventImpl.create(region, entryOp, entryKey, entryNewValue, event.getRawCallbackArgument(), false, event.distributedMember, event.isGenerateCallbacks());
                e.setContext(event.getContext());
            } else {
                e = EntryEventImpl.create(region, entryOp, entryKey, entryNewValue, event.getCallbackArgument(), false, region.getMyId(), event.isGenerateCallbacks());
            }
            e.setPossibleDuplicate(event.isPossibleDuplicate());
        } else {
            e = EntryEventImpl.create(region, entryOp, entryKey, entryNewValue, null, false, region.getMyId(), true);
        }
        e.putAllOp = putAllOp;
        return e;
    }

    protected static EntryEventImpl createRemoveAllEvent(DistributedRemoveAllOperation op, InternalRegion region, Object entryKey) {
        EntryEventImpl e;
        Operation entryOp = Operation.REMOVEALL_DESTROY;
        if (op != null) {
            EntryEventImpl event = op.getBaseEvent();
            if (event.isBridgeEvent()) {
                e = EntryEventImpl.create(region, entryOp, entryKey, null, event.getRawCallbackArgument(), false, event.distributedMember, event.isGenerateCallbacks());
                e.setContext(event.getContext());
            } else {
                e = EntryEventImpl.create(region, entryOp, entryKey, null, event.getCallbackArgument(), false, region.getMyId(), event.isGenerateCallbacks());
            }
            e.setPossibleDuplicate(event.isPossibleDuplicate());
        } else {
            e = EntryEventImpl.create(region, entryOp, entryKey, null, null, false, region.getMyId(), true);
        }
        e.removeAllOp = op;
        return e;
    }

    public boolean isBulkOpInProgress() {
        return this.getPutAllOperation() != null || this.getRemoveAllOperation() != null;
    }

    public DistributedPutAllOperation getPutAllOperation() {
        return this.putAllOp;
    }

    public DistributedPutAllOperation setPutAllOperation(DistributedPutAllOperation nv) {
        DistributedPutAllOperation result = this.putAllOp;
        if (nv != null && nv.getBaseEvent() != null) {
            this.setCallbackArgument(nv.getBaseEvent().getCallbackArgument());
        }
        this.putAllOp = nv;
        return result;
    }

    public DistributedRemoveAllOperation getRemoveAllOperation() {
        return this.removeAllOp;
    }

    public DistributedRemoveAllOperation setRemoveAllOperation(DistributedRemoveAllOperation nv) {
        DistributedRemoveAllOperation result = this.removeAllOp;
        if (nv != null && nv.getBaseEvent() != null) {
            this.setCallbackArgument(nv.getBaseEvent().getCallbackArgument());
        }
        this.removeAllOp = nv;
        return result;
    }

    private boolean testEventFlag(short mask) {
        return EventFlags.isSet(this.eventFlags, mask);
    }

    private void setEventFlag(short mask, boolean on) {
        this.eventFlags = EventFlags.set(this.eventFlags, mask, on);
    }

    @Override
    public DistributedMember getDistributedMember() {
        return this.distributedMember;
    }

    public void setOriginRemote(boolean b) {
        this.setEventFlag((short)1, b);
    }

    public void setLocalInvalid(boolean b) {
        this.setEventFlag((short)2, b);
    }

    public void setGenerateCallbacks(boolean b) {
        this.setEventFlag((short)4, b);
    }

    public void setInvokePRCallbacks(boolean b) {
        this.setEventFlag((short)16, b);
    }

    public boolean getInvokePRCallbacks() {
        return this.testEventFlag((short)16);
    }

    public boolean getInhibitDistribution() {
        return this.testEventFlag((short)4096);
    }

    public void setInhibitDistribution(boolean b) {
        this.setEventFlag((short)4096, b);
    }

    public boolean getIsRedestroyedEntry() {
        return this.testEventFlag((short)8192);
    }

    public void setIsRedestroyedEntry(boolean b) {
        this.setEventFlag((short)8192, b);
    }

    public void isConcurrencyConflict(boolean b) {
        this.setEventFlag((short)32, b);
    }

    public boolean isConcurrencyConflict() {
        return this.testEventFlag((short)32);
    }

    public void setCausedByMessage(DistributionMessage msg) {
        this.causedByMessage = msg;
    }

    public PartitionMessage getPartitionMessage() {
        if (this.causedByMessage != null && this.causedByMessage instanceof PartitionMessage) {
            return (PartitionMessage)this.causedByMessage;
        }
        return null;
    }

    public RemoteOperationMessage getRemoteOperationMessage() {
        if (this.causedByMessage != null && this.causedByMessage instanceof RemoteOperationMessage) {
            return (RemoteOperationMessage)this.causedByMessage;
        }
        return null;
    }

    public boolean isLocalLoad() {
        return this.op.isLocalLoad();
    }

    public boolean isNetSearch() {
        return this.op.isNetSearch();
    }

    public boolean isNetLoad() {
        return this.op.isNetLoad();
    }

    public boolean isDistributed() {
        return this.op.isDistributed();
    }

    public boolean isExpiration() {
        return this.op.isExpiration();
    }

    public boolean isEviction() {
        return this.op.isEviction();
    }

    public void setEvicted() {
        this.isEvicted = true;
    }

    public boolean isEvicted() {
        return this.isEvicted;
    }

    public boolean hasRetried() {
        return this.hasRetried;
    }

    public void setRetried(boolean retried) {
        this.hasRetried = retried;
    }

    public boolean isPendingSecondaryExpireDestroy() {
        return this.isPendingSecondaryExpireDestroy;
    }

    public void setPendingSecondaryExpireDestroy(boolean value) {
        this.isPendingSecondaryExpireDestroy = value;
    }

    @Override
    public boolean isOriginRemote() {
        return this.testEventFlag((short)1);
    }

    public boolean isFromWANAndVersioned() {
        return this.versionTag != null && this.versionTag.isGatewayTag();
    }

    public boolean isFromBridgeAndVersioned() {
        return this.context != null && this.versionTag != null;
    }

    @Override
    public boolean isGenerateCallbacks() {
        return this.testEventFlag((short)4);
    }

    public void setNewEventId(DistributedSystem sys) {
        Assert.assertTrue(this.eventID == null, "Double setting event id");
        EventID newID = new EventID(sys);
        if (this.eventID != null && logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
            logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "Replacing event ID with {} in event {}", (Object)newID, (Object)this);
        }
        this.eventID = newID;
    }

    public void reserveNewEventId(DistributedSystem sys, int count) {
        Assert.assertTrue(this.eventID == null, "Double setting event id");
        this.eventID = new EventID(sys);
        if (count > 1) {
            this.eventID.reserveSequenceId(count - 1);
        }
    }

    public void setEventId(EventID id) {
        this.eventID = id;
    }

    @Override
    public EventID getEventId() {
        return this.eventID;
    }

    @Override
    public boolean isBridgeEvent() {
        return this.hasClientOrigin();
    }

    @Override
    public boolean hasClientOrigin() {
        return this.getContext() != null;
    }

    public void setContext(ClientProxyMembershipID contx) {
        Assert.assertTrue(contx != null);
        this.context = contx;
    }

    @Override
    public ClientProxyMembershipID getContext() {
        return this.context;
    }

    public boolean isLocalInvalid() {
        return this.testEventFlag((short)2);
    }

    public Object getKey() {
        return this.keyInfo.getKey();
    }

    public Object getOldValue() {
        try {
            if (this.isOriginRemote() && this.getRegion().isProxy()) {
                return null;
            }
            Object ov = this.handleNotAvailableOldValue();
            if (ov != null) {
                boolean doCopyOnRead = this.getRegion().isCopyOnRead();
                if (ov instanceof CachedDeserializable) {
                    return this.callWithOffHeapLock((CachedDeserializable)ov, oldValueCD -> {
                        if (doCopyOnRead) {
                            return oldValueCD.getDeserializedWritableCopy(this.getRegion(), this.re);
                        }
                        return oldValueCD.getDeserializedValue(this.getRegion(), this.re);
                    });
                }
                if (doCopyOnRead) {
                    return CopyHelper.copy(ov);
                }
                return ov;
            }
            return null;
        }
        catch (IllegalArgumentException i) {
            IllegalArgumentException iae = new IllegalArgumentException(String.format("%s", "Error while deserializing value for key=" + this.getKey()), i);
            throw iae;
        }
    }

    private Object handleNotAvailableOldValue() {
        Object result = this.basicGetOldValue();
        if (result != Token.NOT_AVAILABLE) {
            return result;
        }
        if (this.getReadOldValueFromDisk()) {
            try {
                result = this.getRegion().getValueInVMOrDiskWithoutFaultIn(this.getKey());
            }
            catch (EntryNotFoundException ex) {
                result = null;
            }
        }
        result = AbstractRegion.handleNotAvailable(result);
        return result;
    }

    public boolean getReadOldValueFromDisk() {
        return this.readOldValueFromDisk;
    }

    public void setReadOldValueFromDisk(boolean v) {
        this.readOldValueFromDisk = v;
    }

    public Object getRawNewValueAsHeapObject() {
        Object result = this.basicGetNewValue();
        if (this.mayHaveOffHeapReferences()) {
            result = OffHeapHelper.copyIfNeeded(result, (InternalCache)this.getRegion().getCache());
        }
        return result;
    }

    public Object getRawNewValue() {
        return this.basicGetNewValue();
    }

    public Object getValue() {
        return this.basicGetNewValue();
    }

    protected void basicSetNewValue(Object v, boolean clearCachedSerializedAndBytes) {
        if (v == this.newValue) {
            return;
        }
        if (this.mayHaveOffHeapReferences()) {
            if (this.offHeapOk) {
                OffHeapHelper.releaseAndTrackOwner(this.newValue, this);
            }
            if (StoredObject.isOffHeapReference(v)) {
                ReferenceCountHelper.setReferenceCountOwner(this);
                if (!((StoredObject)v).retain()) {
                    ReferenceCountHelper.setReferenceCountOwner(null);
                    this.newValue = null;
                    return;
                }
                ReferenceCountHelper.setReferenceCountOwner(null);
            }
        }
        this.newValue = v;
        if (clearCachedSerializedAndBytes) {
            this.newValueBytes = null;
            this.cachedSerializedNewValue = null;
        }
    }

    private void generateNewValueFromBytesIfNeeded() {
        if (this.newValue != null) {
            return;
        }
        byte[] bytes = this.newValueBytes;
        if (bytes != null) {
            this.newValue = CachedDeserializableFactory.create(bytes, (InternalCache)this.getRegion().getCache());
        }
    }

    @Override
    public Object basicGetNewValue() {
        this.generateNewValueFromBytesIfNeeded();
        Object result = this.newValue;
        if (!this.offHeapOk && this.isOffHeapReference(result)) {
            throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
        }
        return result;
    }

    private boolean isOffHeapReference(Object ref) {
        return this.mayHaveOffHeapReferences() && StoredObject.isOffHeapReference(ref);
    }

    void basicSetOldValue(Object v) {
        Object curOldValue = this.oldValue;
        if (v == curOldValue) {
            return;
        }
        if (this.offHeapOk && this.mayHaveOffHeapReferences()) {
            if (ReferenceCountHelper.trackReferenceCounts()) {
                OffHeapHelper.releaseAndTrackOwner(curOldValue, new OldValueOwner());
            } else {
                OffHeapHelper.release(curOldValue);
            }
        }
        this.oldValue = v;
        this.oldValueBytes = null;
    }

    private void retainAndSetOldValue(Object v) {
        if (v == this.oldValue) {
            return;
        }
        if (this.isOffHeapReference(v)) {
            StoredObject so = (StoredObject)v;
            if (ReferenceCountHelper.trackReferenceCounts()) {
                ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                boolean couldNotRetain = !so.retain();
                ReferenceCountHelper.setReferenceCountOwner(null);
                if (couldNotRetain) {
                    this.oldValue = null;
                    this.oldValueBytes = null;
                    return;
                }
            } else if (!so.retain()) {
                this.oldValue = null;
                this.oldValueBytes = null;
                return;
            }
        }
        this.basicSetOldValue(v);
    }

    Object basicGetOldValue() {
        byte[] bytes;
        Object result = this.oldValue;
        if (result == null && (bytes = this.oldValueBytes) != null) {
            this.oldValue = result = CachedDeserializableFactory.create(bytes, (InternalCache)this.getRegion().getCache());
        }
        if (!this.offHeapOk && this.isOffHeapReference(result)) {
            throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
        }
        return result;
    }

    public Object getRawOldValueAsHeapObject() {
        Object result = this.basicGetOldValue();
        if (this.mayHaveOffHeapReferences()) {
            result = OffHeapHelper.copyIfNeeded(result, (InternalCache)this.getRegion().getCache());
        }
        return result;
    }

    public Object getRawOldValue() {
        return this.basicGetOldValue();
    }

    public Object getOldValueAsOffHeapDeserializedOrRaw() {
        Object result = this.basicGetOldValue();
        if (this.mayHaveOffHeapReferences() && result instanceof StoredObject) {
            result = ((CachedDeserializable)result).getDeserializedForReading();
        }
        return AbstractRegion.handleNotAvailable(result);
    }

    protected boolean isRegionCopyOnRead() {
        return this.getRegion().isCopyOnRead();
    }

    public Object getNewValue() {
        boolean doCopyOnRead = this.getRegion().isCopyOnRead();
        Object nv = this.basicGetNewValue();
        if (nv != null) {
            if (nv == Token.NOT_AVAILABLE) {
                return AbstractRegion.handleNotAvailable(nv);
            }
            if (nv instanceof CachedDeserializable) {
                return this.callWithOffHeapLock((CachedDeserializable)nv, newValueCD -> {
                    Object v = null;
                    v = doCopyOnRead ? newValueCD.getDeserializedWritableCopy(this.getRegion(), this.re) : newValueCD.getDeserializedValue(this.getRegion(), this.re);
                    assert (!(v instanceof CachedDeserializable)) : "for key " + this.getKey() + " found nested CachedDeserializable";
                    return v;
                });
            }
            if (doCopyOnRead) {
                return CopyHelper.copy(nv);
            }
            return nv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, R> R callWithOffHeapLock(T value, Function<T, R> function) {
        if (this.isOffHeapReference(value)) {
            Object object = this.offHeapLock;
            synchronized (object) {
                if (!this.offHeapOk) {
                    throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
                }
                return function.apply(value);
            }
        }
        return function.apply(value);
    }

    public String getNewValueStringForm() {
        return StringUtils.forceToString(this.basicGetNewValue());
    }

    public String getOldValueStringForm() {
        return StringUtils.forceToString(this.basicGetOldValue());
    }

    public void setNewValue(Object obj) {
        this.basicSetNewValue(obj, true);
    }

    @Override
    public TransactionId getTransactionId() {
        return this.txId;
    }

    public void setTransactionId(TransactionId txId) {
        this.txId = (TXId)txId;
    }

    public boolean isLoad() {
        return this.op.isLoad();
    }

    public void setRegion(InternalRegion r) {
        this.region = r;
    }

    public InternalRegion getRegion() {
        return this.region;
    }

    @Override
    public Operation getOperation() {
        return this.op;
    }

    public void setOperation(Operation op) {
        this.op = op;
        PartitionMessage prm = this.getPartitionMessage();
        if (prm != null) {
            prm.setOperation(this.op);
        }
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.keyInfo.getCallbackArg();
        while (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        if (result == Token.NOT_AVAILABLE) {
            result = AbstractRegion.handleNotAvailable(result);
        }
        return result;
    }

    @Override
    public boolean isCallbackArgumentAvailable() {
        return this.getRawCallbackArgument() != Token.NOT_AVAILABLE;
    }

    public Object getRawCallbackArgument() {
        return this.keyInfo.getCallbackArg();
    }

    public void setRawCallbackArgument(Object newCallbackArgument) {
        this.keyInfo.setCallbackArg(newCallbackArgument);
    }

    public void setCallbackArgument(Object newCallbackArgument) {
        if (this.keyInfo.getCallbackArg() instanceof WrappedCallbackArgument) {
            ((WrappedCallbackArgument)this.keyInfo.getCallbackArg()).setOriginalCallbackArgument(newCallbackArgument);
        } else {
            this.keyInfo.setCallbackArg(newCallbackArgument);
        }
    }

    public SerializedCacheValue<?> getSerializedNewValue() {
        Object tmp = this.basicGetNewValue();
        if (tmp instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)tmp;
            if (!cd.isSerialized()) {
                return null;
            }
            byte[] bytes = this.newValueBytes;
            if (bytes == null) {
                bytes = this.cachedSerializedNewValue;
            }
            return new SerializedCacheValueImpl(this, this.getRegion(), this.re, cd, bytes);
        }
        return null;
    }

    public void exportNewValue(NewValueImporter importer) {
        Object nv;
        boolean prefersSerialized = importer.prefersNewSerialized();
        if (prefersSerialized) {
            byte[] serializedNewValue = this.getCachedSerializedNewValue();
            if (serializedNewValue == null) {
                serializedNewValue = this.newValueBytes;
            }
            if (serializedNewValue != null) {
                importer.importNewBytes(serializedNewValue, true);
                return;
            }
        }
        if ((nv = this.getRawNewValue()) instanceof StoredObject) {
            StoredObject so = (StoredObject)nv;
            boolean isSerialized = so.isSerialized();
            if (importer.isUnretainedNewReferenceOk()) {
                importer.importNewObject(nv, isSerialized);
            } else if (!isSerialized || prefersSerialized) {
                byte[] bytes = so.getValueAsHeapByteArray();
                importer.importNewBytes(bytes, isSerialized);
                if (isSerialized) {
                    this.setCachedSerializedNewValue(bytes);
                }
            } else {
                importer.importNewObject(so.getValueAsDeserializedHeapObject(), true);
            }
        } else if (nv instanceof byte[]) {
            importer.importNewBytes((byte[])nv, false);
        } else if (nv instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)nv;
            Object cdV = cd.getValue();
            if (cdV instanceof byte[]) {
                importer.importNewBytes((byte[])cdV, true);
                this.setCachedSerializedNewValue((byte[])cdV);
            } else {
                importer.importNewObject(cdV, true);
            }
        } else {
            importer.importNewObject(nv, true);
        }
    }

    public void exportOldValue(OldValueImporter importer) {
        boolean prefersSerialized = importer.prefersOldSerialized();
        if (prefersSerialized && this.oldValueBytes != null) {
            importer.importOldBytes(this.oldValueBytes, true);
            return;
        }
        Object ov = this.getRawOldValue();
        if (ov instanceof StoredObject) {
            StoredObject so = (StoredObject)ov;
            boolean isSerialized = so.isSerialized();
            if (importer.isUnretainedOldReferenceOk()) {
                importer.importOldObject(ov, isSerialized);
            } else if (!isSerialized || prefersSerialized) {
                importer.importOldBytes(so.getValueAsHeapByteArray(), isSerialized);
            } else {
                importer.importOldObject(so.getValueAsDeserializedHeapObject(), true);
            }
        } else if (ov instanceof byte[]) {
            importer.importOldBytes((byte[])ov, false);
        } else if (!importer.isCachedDeserializableValueOk() && ov instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)ov;
            Object cdV = cd.getValue();
            if (cdV instanceof byte[]) {
                importer.importOldBytes((byte[])cdV, true);
            } else {
                importer.importOldObject(cdV, true);
            }
        } else {
            importer.importOldObject(AbstractRegion.handleNotAvailable(ov), true);
        }
    }

    public Object getNewValueAsOffHeapDeserializedOrRaw() {
        Object result = this.getRawNewValue();
        if (this.mayHaveOffHeapReferences() && result instanceof StoredObject) {
            result = ((CachedDeserializable)result).getDeserializedForReading();
        }
        return AbstractRegion.handleNotAvailable(result);
    }

    public StoredObject getOffHeapNewValue() {
        return this.convertToStoredObject(this.basicGetNewValue());
    }

    public StoredObject getOffHeapOldValue() {
        return this.convertToStoredObject(this.basicGetOldValue());
    }

    private StoredObject convertToStoredObject(Object tmp) {
        if (!this.mayHaveOffHeapReferences()) {
            return null;
        }
        if (!(tmp instanceof StoredObject)) {
            return null;
        }
        StoredObject result = (StoredObject)tmp;
        if (!result.retain()) {
            return null;
        }
        return result;
    }

    public Object getDeserializedValue() {
        Object val = this.basicGetNewValue();
        if (val instanceof CachedDeserializable) {
            return ((CachedDeserializable)val).getDeserializedForReading();
        }
        return val;
    }

    public byte[] getSerializedValue() {
        if (this.newValueBytes == null) {
            Object val = this.basicGetNewValue();
            if (val instanceof byte[]) {
                return (byte[])val;
            }
            if (val instanceof CachedDeserializable) {
                return ((CachedDeserializable)val).getSerializedValue();
            }
            try {
                return CacheServerHelper.serialize(val);
            }
            catch (IOException ioe) {
                throw new GemFireIOException("unexpected exception", ioe);
            }
        }
        return this.newValueBytes;
    }

    public void makeSerializedNewValue() {
        this.makeSerializedNewValue(false);
    }

    private void makeSerializedNewValue(boolean isSynced) {
        Object obj = this.basicGetNewValue();
        if (isSynced) {
            this.setSerializationDeferred(false);
        }
        this.basicSetNewValue(EntryEventImpl.getCachedDeserializable(obj, this), false);
    }

    public static Object getCachedDeserializable(Object obj, EntryEventImpl ev) {
        CachedDeserializable cd;
        if (obj instanceof byte[] || obj == null || obj instanceof CachedDeserializable || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj) || obj instanceof Delta) {
            return obj;
        }
        if (obj instanceof byte[][]) {
            int objSize = 12;
            for (byte[] bytes : (byte[][])obj) {
                if (bytes != null) {
                    objSize += CachedDeserializableFactory.getByteSize(bytes);
                    continue;
                }
                objSize += 8;
            }
            cd = CachedDeserializableFactory.create(obj, objSize, (InternalCache)ev.getRegion().getCache());
        } else {
            byte[] b = EntryEventImpl.serialize(obj);
            cd = CachedDeserializableFactory.create(b, (InternalCache)ev.getRegion().getCache());
            if (ev != null) {
                ev.newValueBytes = b;
                ev.cachedSerializedNewValue = b;
            }
        }
        return cd;
    }

    @Override
    public void setCachedSerializedNewValue(byte[] v) {
        this.cachedSerializedNewValue = v;
    }

    @Override
    public byte[] getCachedSerializedNewValue() {
        return this.cachedSerializedNewValue;
    }

    public void setSerializedNewValue(byte[] serializedValue) {
        CachedDeserializable newVal = null;
        if (serializedValue != null) {
            newVal = CachedDeserializableFactory.create(serializedValue, (InternalCache)this.getRegion().getCache());
        }
        this.basicSetNewValue(newVal, false);
        this.newValueBytes = serializedValue;
        this.cachedSerializedNewValue = serializedValue;
    }

    public void setSerializedOldValue(byte[] serializedOldValue) {
        CachedDeserializable ov = serializedOldValue != null ? CachedDeserializableFactory.create(serializedOldValue, (InternalCache)this.getRegion().getCache()) : null;
        this.retainAndSetOldValue(ov);
        this.oldValueBytes = serializedOldValue;
    }

    protected boolean areOldValuesEnabled() {
        return EVENT_OLD_VALUE;
    }

    void putExistingEntry(InternalRegion owner, RegionEntry entry) throws RegionClearedException {
        this.putExistingEntry(owner, entry, false, null);
    }

    public void putExistingEntry(InternalRegion owner, RegionEntry reentry, boolean requireOldValue, Object oldValueForDelta) throws RegionClearedException {
        this.makeUpdate();
        if (this.oldValue == null && this.oldValueBytes == null && !reentry.isInvalidOrRemoved()) {
            if (requireOldValue || this.areOldValuesEnabled() || this.getRegion() instanceof HARegion) {
                Object ov;
                if (ReferenceCountHelper.trackReferenceCounts()) {
                    ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                    ov = reentry.getValueRetain(owner, true);
                    ReferenceCountHelper.setReferenceCountOwner(null);
                } else {
                    ov = reentry.getValueRetain(owner, true);
                }
                if (ov == null) {
                    ov = Token.NOT_AVAILABLE;
                }
                this.basicSetOldValue(ov);
            } else {
                this.basicSetOldValue(Token.NOT_AVAILABLE);
            }
        }
        if (this.oldValue == Token.NOT_AVAILABLE) {
            FilterProfile fp = this.getRegion().getFilterProfile();
            if (this.op.guaranteesOldValue() || fp != null && fp.entryRequiresOldValue(this.getKey())) {
                this.setOldValueForQueryProcessing();
            }
        }
        this.setNewValueInRegion(owner, reentry, oldValueForDelta);
    }

    public void makeUpdate() {
        this.setOperation(this.op.getCorrespondingUpdateOp());
    }

    public void makeCreate() {
        this.setOperation(this.op.getCorrespondingCreateOp());
    }

    public void putNewEntry(InternalRegion owner, RegionEntry reentry) throws RegionClearedException {
        if (!this.op.guaranteesOldValue()) {
            this.basicSetOldValue(null);
        }
        this.makeCreate();
        this.setNewValueInRegion(owner, reentry, null);
    }

    @Override
    public void setRegionEntry(RegionEntry re) {
        this.re = re;
    }

    public RegionEntry getRegionEntry() {
        return this.re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewValueInRegion(InternalRegion owner, RegionEntry reentry, Object oldValueForDelta) throws RegionClearedException {
        Object preparedV;
        boolean wasTombstone = reentry.isTombstone();
        if (this.deltaBytes != null && this.newValue == null && this.newValueBytes == null) {
            this.processDeltaBytes(oldValueForDelta);
        }
        if (owner != null) {
            owner.generateAndSetVersionTag(this, reentry);
        } else {
            this.getRegion().generateAndSetVersionTag(this, reentry);
        }
        this.generateNewValueFromBytesIfNeeded();
        Object v = this.newValue;
        if (v == null) {
            v = this.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
        } else {
            this.getRegion().setRegionInvalid(false);
        }
        reentry.setValueResultOfSearch(this.op.isNetSearch());
        if (v instanceof Delta && this.getRegion().isUsedForPartitionedRegionBucket()) {
            Object ov = this.basicGetOldValue();
            int vSize = ov instanceof CachedDeserializable && !EntryEventImpl.shouldRecalculateSize((Delta)v) ? ((CachedDeserializable)ov).getValueSizeInBytes() : CachedDeserializableFactory.calcMemSize(v, this.getRegion().getObjectSizer(), false);
            v = CachedDeserializableFactory.create(v, vSize, (InternalCache)this.getRegion().getCache());
            this.basicSetNewValue(v, true);
        }
        if ((preparedV = reentry.prepareValueForCache(this.getRegion(), v, this, false)) != v && (v = preparedV) instanceof StoredObject && !((StoredObject)v).isCompressed()) {
            this.basicSetNewValue(v, false);
        }
        boolean isTombstone = v == Token.TOMBSTONE;
        boolean success = false;
        boolean calledSetValue = false;
        try {
            IndexManager idxManager;
            this.setNewValueBucketSize(owner, v);
            if ((this.op.isUpdate() && !reentry.isInvalid() || this.op.isInvalidate()) && (idxManager = IndexUtils.getIndexManager((InternalCache)this.getRegion().getCache(), this.getRegion(), false)) != null) {
                try {
                    idxManager.updateIndexes(reentry, 3, this.op.isUpdate() ? 1 : 0);
                }
                catch (QueryException e) {
                    throw new IndexMaintenanceException(e);
                }
            }
            calledSetValue = true;
            reentry.setValueWithTombstoneCheck(v, this);
            success = true;
        }
        finally {
            if (!success && reentry instanceof OffHeapRegionEntry && v instanceof StoredObject) {
                if (!calledSetValue) {
                    OffHeapHelper.release(v);
                } else {
                    OffHeapRegionEntryHelper.releaseEntry((OffHeapRegionEntry)reentry, (StoredObject)v);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            if (v instanceof CachedDeserializable) {
                logger.trace("EntryEventImpl.setNewValueInRegion: put CachedDeserializable({},{})", this.getKey(), (Object)((CachedDeserializable)v).getStringForm());
            } else {
                logger.trace("EntryEventImpl.setNewValueInRegion: put({},{})", this.getKey(), (Object)StringUtils.forceToString(v));
            }
        }
        if (!isTombstone && wasTombstone) {
            owner.unscheduleTombstone(reentry);
        }
    }

    public int getNewValueBucketSize() {
        return this.newValueBucketSize;
    }

    private void setNewValueBucketSize(InternalRegion lr, Object v) {
        if (lr == null) {
            lr = this.getRegion();
        }
        this.newValueBucketSize = lr.calculateValueSize(v);
    }

    private void processDeltaBytes(Object oldValueInVM) {
        if (!this.getRegion().hasSeenEvent(this)) {
            if (oldValueInVM == null || Token.isInvalidOrRemoved(oldValueInVM)) {
                this.getRegion().getCachePerfStats().incDeltaFailedUpdates();
                throw new InvalidDeltaException("Old value not found for key " + this.keyInfo.getKey());
            }
            FilterProfile fp = this.getRegion().getFilterProfile();
            boolean copy = this.getRegion().getCompressor() == null && (this.getRegion().isCopyOnRead() || this.getRegion().getCloningEnabled() || fp != null && fp.getCqCount() > 0);
            Object value = oldValueInVM;
            boolean wasCD = false;
            if (value instanceof CachedDeserializable) {
                wasCD = true;
                value = copy ? ((CachedDeserializable)value).getDeserializedWritableCopy(this.getRegion(), this.re) : ((CachedDeserializable)value).getDeserializedValue(this.getRegion(), this.re);
            } else if (copy) {
                value = CopyHelper.copy(value);
            }
            boolean deltaBytesApplied = false;
            try (ByteArrayDataInput in = new ByteArrayDataInput(this.getDeltaBytes());){
                long start = this.getRegion().getCachePerfStats().getTime();
                ((Delta)value).fromDelta((DataInput)in);
                this.getRegion().getCachePerfStats().endDeltaUpdate(start);
                deltaBytesApplied = true;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                throw new DeltaSerializationException("Exception while deserializing delta bytes.", t);
            }
            finally {
                if (!deltaBytesApplied) {
                    this.getRegion().getCachePerfStats().incDeltaFailedUpdates();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Delta has been applied for key {}", this.getKey());
            }
            if (wasCD) {
                CachedDeserializable old = (CachedDeserializable)oldValueInVM;
                int valueSize = EntryEventImpl.shouldRecalculateSize((Delta)value) ? CachedDeserializableFactory.calcMemSize(value, this.getRegion().getObjectSizer(), false) : old.getValueSizeInBytes();
                value = CachedDeserializableFactory.create(value, valueSize, (InternalCache)this.getRegion().getCache());
            }
            this.setNewValue(value);
            if (this.causedByMessage != null && this.causedByMessage instanceof PutMessage) {
                ((PutMessage)this.causedByMessage).setDeltaValObj(value);
            }
        } else {
            this.getRegion().getCachePerfStats().incDeltaFailedUpdates();
            throw new InvalidDeltaException("Cache encountered replay of event containing delta bytes for key " + this.keyInfo.getKey());
        }
    }

    @VisibleForTesting
    protected static boolean shouldRecalculateSize(Delta value) {
        return GemFireCacheImpl.DELTAS_RECALCULATE_SIZE || value.getForceRecalculateSize();
    }

    void setTXEntryOldValue(Object oldVal, boolean mustBeAvailable) {
        if (Token.isInvalidOrRemoved(oldVal)) {
            oldVal = null;
        } else if (!mustBeAvailable && oldVal != null && !this.areOldValuesEnabled()) {
            oldVal = Token.NOT_AVAILABLE;
        }
        this.retainAndSetOldValue(oldVal);
    }

    void putValueTXEntry(TXEntryState tx) {
        Object v = this.basicGetNewValue();
        if (v == null) {
            if (this.deltaBytes != null) {
                this.processDeltaBytes(tx.getNearSidePendingValue());
                v = this.basicGetNewValue();
            } else {
                Object object = v = this.isLocalInvalid() ? Token.LOCAL_INVALID : Token.INVALID;
            }
        }
        if (this.op != Operation.LOCAL_INVALIDATE && this.op != Operation.LOCAL_DESTROY) {
            Object pv = v;
            if (this.mayHaveOffHeapReferences()) {
                pv = OffHeapHelper.copyIfNeeded(v, (InternalCache)this.getRegion().getCache());
            }
            tx.setPendingValue(pv);
        }
        tx.setCallbackArgument(this.getCallbackArgument());
    }

    public void setOldValueFromRegion() {
        try {
            RegionEntry re = this.getRegion().getRegionEntry(this.getKey());
            if (re == null) {
                return;
            }
            ReferenceCountHelper.skipRefCountTracking();
            Object v = re.getValueRetain(this.getRegion(), true);
            if (v == null) {
                v = Token.NOT_AVAILABLE;
            }
            ReferenceCountHelper.unskipRefCountTracking();
            try {
                this.setOldValue(v);
            }
            finally {
                if (this.mayHaveOffHeapReferences()) {
                    OffHeapHelper.releaseWithNoTracking(v);
                }
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
    }

    boolean oldValueIsDestroyedToken() {
        return this.oldValue == Token.DESTROYED || this.oldValue == Token.TOMBSTONE;
    }

    public void setOldValueDestroyedToken() {
        this.basicSetOldValue(Token.DESTROYED);
    }

    public void setOldValue(Object v) {
        this.setOldValue(v, false);
    }

    public void setOldValue(Object v, boolean force) {
        if (v != null) {
            if (Token.isInvalidOrRemoved(v)) {
                v = null;
            } else if (this.shouldOldValueBeUnavailable(v, force)) {
                v = Token.NOT_AVAILABLE;
            }
        }
        this.retainAndSetOldValue(v);
    }

    private boolean shouldOldValueBeUnavailable(Object v, boolean force) {
        if (force) {
            return false;
        }
        if (this.areOldValuesEnabled()) {
            return false;
        }
        return !(this.getRegion() instanceof HARegion);
    }

    public void setConcurrentMapOldValue(Object v) {
        if (Token.isRemoved(v)) {
            return;
        }
        if (Token.isInvalid(v)) {
            v = null;
        }
        this.retainAndSetOldValue(v);
    }

    public boolean hasNewValue() {
        if (this.newValueBytes != null) {
            return true;
        }
        Object tmp = this.newValue;
        return tmp != null && tmp != Token.NOT_AVAILABLE;
    }

    public boolean hasOldValue() {
        if (this.oldValueBytes != null) {
            return true;
        }
        return this.oldValue != null && this.oldValue != Token.NOT_AVAILABLE;
    }

    public boolean isOldValueAToken() {
        return this.oldValue instanceof Token;
    }

    @Override
    public boolean isOldValueAvailable() {
        if (this.isOriginRemote() && this.getRegion().isProxy()) {
            return false;
        }
        return this.basicGetOldValue() != Token.NOT_AVAILABLE;
    }

    public void oldValueNotAvailable() {
        this.basicSetOldValue(Token.NOT_AVAILABLE);
    }

    public static Object deserialize(byte[] bytes) {
        return EntryEventImpl.deserialize(bytes, null, null);
    }

    public static Object deserialize(byte[] bytes, KnownVersion version, ByteArrayDataInput in) {
        if (bytes == null) {
            return null;
        }
        try {
            return BlobHelper.deserializeBlob(bytes, version, in);
        }
        catch (IOException e) {
            throw new SerializationException("An IOException was thrown while deserializing", e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("A ClassNotFoundException was thrown while trying to deserialize cached value.", e);
        }
    }

    public static Object deserializeOffHeap(StoredObject bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return BlobHelper.deserializeOffHeapBlob(bytes);
        }
        catch (IOException e) {
            throw new SerializationException("An IOException was thrown while deserializing", e);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("A ClassNotFoundException was thrown while trying to deserialize cached value.", e);
        }
    }

    public static byte[] serialize(Object obj) {
        return EntryEventImpl.serialize(obj, null);
    }

    public static byte[] serialize(Object obj, KnownVersion version) {
        if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
            throw new IllegalArgumentException(String.format("Must not serialize %s in this context.", obj));
        }
        try {
            return BlobHelper.serializeToBlob(obj, version);
        }
        catch (IOException e) {
            throw new SerializationException("An IOException was thrown while serializing.", e);
        }
    }

    public static void fillSerializedValue(BytesAndBitsForCompactor wrapper, Object obj, byte userBits) {
        if (obj == null || obj == Token.NOT_AVAILABLE || Token.isInvalidOrRemoved(obj)) {
            throw new IllegalArgumentException(String.format("Must not serialize %s in this context.", obj));
        }
        try (HeapDataOutputStream hdos = null;){
            hdos = wrapper.getBytes().length < 32 ? new HeapDataOutputStream(KnownVersion.CURRENT) : new HeapDataOutputStream(wrapper.getBytes());
            DataSerializer.writeObject(obj, hdos);
            hdos.sendTo(wrapper, userBits);
        }
    }

    protected String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getShortClassName());
        buf.append("[");
        buf.append("op=");
        buf.append(this.getOperation());
        buf.append(";region=");
        buf.append(this.getRegion().getFullPath());
        buf.append(";key=");
        buf.append(this.getKey());
        if (Boolean.getBoolean("gemfire.insecure-logvalues")) {
            Object object;
            buf.append(";oldValue=");
            if (this.mayHaveOffHeapReferences()) {
                object = this.offHeapLock;
                synchronized (object) {
                    try {
                        ArrayUtils.objectStringNonRecursive(this.basicGetOldValue(), buf);
                    }
                    catch (IllegalStateException ignore) {
                        buf.append("OFFHEAP_VALUE_FREED");
                    }
                }
            }
            ArrayUtils.objectStringNonRecursive(this.basicGetOldValue(), buf);
            buf.append(";newValue=");
            if (this.mayHaveOffHeapReferences()) {
                object = this.offHeapLock;
                synchronized (object) {
                    try {
                        ArrayUtils.objectStringNonRecursive(this.basicGetNewValue(), buf);
                    }
                    catch (IllegalStateException ignore) {
                        buf.append("OFFHEAP_VALUE_FREED");
                    }
                }
            }
            ArrayUtils.objectStringNonRecursive(this.basicGetNewValue(), buf);
        }
        buf.append(";callbackArg=");
        buf.append(this.getRawCallbackArgument());
        buf.append(";originRemote=");
        buf.append(this.isOriginRemote());
        buf.append(";originMember=");
        buf.append(this.getDistributedMember());
        if (this.isPossibleDuplicate()) {
            buf.append(";posDup");
        }
        if (this.callbacksInvoked()) {
            buf.append(";callbacksInvoked");
        }
        if (this.inhibitCacheListenerNotification()) {
            buf.append(";inhibitCacheListenerNotification");
        }
        if (this.versionTag != null) {
            buf.append(";version=").append(this.versionTag);
        }
        if (this.getContext() != null) {
            buf.append(";context=");
            buf.append(this.getContext());
        }
        if (this.eventID != null) {
            buf.append(";id=");
            buf.append(this.eventID);
        }
        if (this.deltaBytes != null) {
            buf.append(";[").append(this.deltaBytes.length).append(" deltaBytes]");
        }
        if (this.filterInfo != null) {
            buf.append(";routing=");
            buf.append(this.filterInfo);
        }
        if (this.isFromServer()) {
            buf.append(";isFromServer");
        }
        if (this.isConcurrencyConflict()) {
            buf.append(";isInConflict");
        }
        if (this.getInhibitDistribution()) {
            buf.append(";inhibitDistribution");
        }
        if (this.tailKey != -1L) {
            buf.append(";tailKey=").append(this.tailKey);
        }
        buf.append("]");
        return buf.toString();
    }

    public int getDSFID() {
        return 105;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        CachedDeserializable cd;
        context.getSerializer().writeObject((Object)this.eventID, out);
        context.getSerializer().writeObject(this.getKey(), out);
        context.getSerializer().writeObject(this.keyInfo.getValue(), out);
        out.writeByte(this.op.ordinal);
        out.writeShort(this.eventFlags & 0xFFFFC03F);
        context.getSerializer().writeObject(this.getRawCallbackArgument(), out);
        context.getSerializer().writeObject((Object)this.txId, out);
        out.writeBoolean(false);
        Object nv = this.basicGetNewValue();
        boolean newValueSerialized = nv instanceof CachedDeserializable;
        if (newValueSerialized) {
            newValueSerialized = ((CachedDeserializable)nv).isSerialized();
        }
        out.writeBoolean(newValueSerialized);
        if (newValueSerialized) {
            if (this.newValueBytes != null) {
                DataSerializer.writeByteArray(this.newValueBytes, out);
            } else if (this.cachedSerializedNewValue != null) {
                DataSerializer.writeByteArray(this.cachedSerializedNewValue, out);
            } else {
                cd = (CachedDeserializable)nv;
                DataSerializer.writeObjectAsByteArray(cd.getValue(), out);
            }
        } else {
            context.getSerializer().writeObject(nv, out);
        }
        Object ov = this.basicGetOldValue();
        boolean oldValueSerialized = ov instanceof CachedDeserializable;
        if (oldValueSerialized) {
            oldValueSerialized = ((CachedDeserializable)ov).isSerialized();
        }
        out.writeBoolean(oldValueSerialized);
        if (oldValueSerialized) {
            if (this.oldValueBytes != null) {
                DataSerializer.writeByteArray(this.oldValueBytes, out);
            } else {
                cd = (CachedDeserializable)ov;
                DataSerializer.writeObjectAsByteArray(cd.getValue(), out);
            }
        } else {
            ov = AbstractRegion.handleNotAvailable(ov);
            context.getSerializer().writeObject(ov, out);
        }
        InternalDataSerializer.invokeToData(this.distributedMember, out);
        context.getSerializer().writeObject((Object)this.getContext(), out);
        DataSerializer.writeLong(this.tailKey, out);
    }

    public SerializedCacheValue<?> getSerializedOldValue() {
        Object tmp = this.basicGetOldValue();
        if (tmp instanceof CachedDeserializable) {
            CachedDeserializable cd = (CachedDeserializable)tmp;
            if (!cd.isSerialized()) {
                return null;
            }
            return new SerializedCacheValueImpl(this, this.getRegion(), this.re, cd, this.oldValueBytes);
        }
        return null;
    }

    public int getNewValSizeForPR() {
        int newSize = 0;
        Object v = this.basicGetNewValue();
        if (v != null) {
            try {
                newSize = CachedDeserializableFactory.calcSerializedSize(v) + CachedDeserializableFactory.overhead();
            }
            catch (IllegalArgumentException iae) {
                logger.warn("DataStore failed to calculate size of new value", (Throwable)iae);
                newSize = 0;
            }
        }
        return newSize;
    }

    public int getOldValSize() {
        int oldSize = 0;
        if (this.hasOldValue()) {
            try {
                oldSize = CachedDeserializableFactory.calcMemSize(this.basicGetOldValue());
            }
            catch (IllegalArgumentException iae) {
                logger.warn("DataStore failed to calculate size of old value", (Throwable)iae);
                oldSize = 0;
            }
        }
        return oldSize;
    }

    @Override
    public EnumListenerEvent getEventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(EnumListenerEvent eventType) {
        this.eventType = eventType;
    }

    public void callbacksInvoked(boolean dispatched) {
        this.setEventFlag((short)128, dispatched);
    }

    public boolean callbacksInvoked() {
        return this.testEventFlag((short)128);
    }

    public void inhibitCacheListenerNotification(boolean inhibit) {
        this.setEventFlag((short)64, inhibit);
    }

    public boolean inhibitCacheListenerNotification() {
        return this.testEventFlag((short)64);
    }

    public void invokeCallbacks(InternalRegion rgn, boolean skipListeners, boolean notifyGateways) {
        if (!this.callbacksInvoked()) {
            this.callbacksInvoked(true);
            if (this.op.isUpdate()) {
                rgn.invokePutCallbacks(EnumListenerEvent.AFTER_UPDATE, this, !skipListeners, notifyGateways);
            } else if (this.op.isCreate()) {
                rgn.invokePutCallbacks(EnumListenerEvent.AFTER_CREATE, this, !skipListeners, notifyGateways);
            } else if (this.op.isDestroy()) {
                rgn.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, this, !skipListeners, notifyGateways);
            } else if (this.op.isInvalidate()) {
                rgn.invokeInvalidateCallbacks(EnumListenerEvent.AFTER_INVALIDATE, this, !skipListeners);
            }
        }
    }

    private void setFromRILocalDestroy(boolean on) {
        this.setEventFlag((short)2048, on);
    }

    public boolean isFromRILocalDestroy() {
        return this.testEventFlag((short)2048);
    }

    public void setNextRegionVersion(long regionVersion) {
        this.nextRegionVersion = regionVersion;
    }

    public long getNextRegionVersion() {
        return this.nextRegionVersion;
    }

    public boolean isFromServer() {
        return this.testEventFlag((short)1024);
    }

    public void setFromServer(boolean v) {
        this.setEventFlag((short)1024, v);
    }

    public boolean isPossibleDuplicate() {
        return this.testEventFlag((short)8);
    }

    public void setPossibleDuplicate(boolean possibleDuplicate) {
        this.setEventFlag((short)8, possibleDuplicate);
    }

    public boolean inhibitAllNotifications() {
        return this.testEventFlag((short)16384);
    }

    public void setInhibitAllNotifications(boolean inhibit) {
        this.setEventFlag((short)16384, inhibit);
    }

    @Override
    public void setLocalFilterInfo(FilterRoutingInfo.FilterInfo info) {
        this.filterInfo = info;
    }

    @Override
    public FilterRoutingInfo.FilterInfo getLocalFilterInfo() {
        return this.filterInfo;
    }

    public byte[] getDeltaBytes() {
        return this.deltaBytes;
    }

    public void setDeltaBytes(byte[] deltaBytes) {
        this.deltaBytes = deltaBytes;
    }

    public boolean isCreate() {
        return this.testEventFlag((short)256);
    }

    public EntryEventImpl setCreate(boolean isCreate) {
        this.setEventFlag((short)256, isCreate);
        return this;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void setOldValueForQueryProcessing() {
        Object v;
        RegionEntry reentry = this.getRegion().getRegionMap().getEntry(this.getKey());
        if (reentry != null && !((v = reentry.getValueOffHeapOrDiskWithoutFaultIn(this.getRegion())) instanceof Token)) {
            this.basicSetOldValue(v);
        }
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    public void setVersionTag(VersionTag versionTag) {
        this.versionTag = versionTag;
    }

    @Override
    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public boolean hasValidVersionTag() {
        return this.versionTag != null && this.versionTag.hasValidVersion();
    }

    public long getEventTime(long suggestedTime) {
        long result = suggestedTime;
        if (this.versionTag != null && this.getRegion().getConcurrencyChecksEnabled()) {
            if (suggestedTime != 0L) {
                this.versionTag.setVersionTimeStamp(suggestedTime);
            } else {
                result = this.versionTag.getVersionTimeStamp();
            }
        }
        if (result <= 0L) {
            InternalRegion region = this.getRegion();
            result = region != null ? region.cacheTimeMillis() : System.currentTimeMillis();
        }
        return result;
    }

    public void setTailKey(Long tailKey) {
        this.tailKey = tailKey;
    }

    public Long getTailKey() {
        return this.tailKey;
    }

    public void setCallbacksInvokedByCurrentThread() {
        this.invokeCallbacksThread = Thread.currentThread();
    }

    public boolean getCallbacksInvokedByCurrentThread() {
        if (this.invokeCallbacksThread == null) {
            return false;
        }
        return Thread.currentThread().equals(this.invokeCallbacksThread);
    }

    public boolean isOnPdxTypeRegion() {
        return "/PdxTypes".equals(this.getRegion().getFullPath());
    }

    public boolean noVersionReceivedFromServer() {
        return this.versionTag == null && this.getRegion().getConcurrencyChecksEnabled() && this.getRegion().getServerProxy() != null && !this.op.isLocal() && !this.isOriginRemote();
    }

    public TimestampedEntryEvent getTimestampedEvent(int newDSID, int oldDSID, long newTimestamp, long oldTimestamp) {
        return new TimestampedEntryEventImpl(this, newDSID, oldDSID, newTimestamp, oldTimestamp);
    }

    private void setSerializationDeferred(boolean serializationDeferred) {
        this.setEventFlag((short)512, serializationDeferred);
    }

    private boolean isSerializationDeferred() {
        return this.testEventFlag((short)512);
    }

    public boolean isSingleHop() {
        return this.causedByMessage != null && this.causedByMessage instanceof RemoteOperationMessage;
    }

    public boolean isSingleHopPutOp() {
        return this.causedByMessage != null && this.causedByMessage instanceof RemotePutMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (!this.offHeapOk) {
            return;
        }
        if (!this.mayHaveOffHeapReferences()) {
            return;
        }
        Object object = this.offHeapLock;
        synchronized (object) {
            this.testHookReleaseInProgress();
            Object ov = this.basicGetOldValue();
            Object nv = this.basicGetNewValue();
            this.offHeapOk = false;
            if (ov instanceof StoredObject) {
                if (ReferenceCountHelper.trackReferenceCounts()) {
                    ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                    ((Releasable)ov).release();
                    ReferenceCountHelper.setReferenceCountOwner(null);
                } else {
                    ((Releasable)ov).release();
                }
            }
            OffHeapHelper.releaseAndTrackOwner(nv, this);
        }
    }

    private boolean mayHaveOffHeapReferences() {
        if (this.offHeapLock == null) {
            return false;
        }
        InternalRegion lr = this.getRegion();
        if (lr != null) {
            return lr.getOffHeap();
        }
        return true;
    }

    void testHookReleaseInProgress() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disallowOffHeapValues() {
        if (this.isOffHeapReference(this.newValue) || this.isOffHeapReference(this.oldValue)) {
            throw new IllegalStateException("This event already has off-heap values");
        }
        if (this.mayHaveOffHeapReferences()) {
            Object object = this.offHeapLock;
            synchronized (object) {
                this.offHeapOk = false;
            }
        } else {
            this.offHeapOk = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyOffHeapToHeap() {
        if (!this.mayHaveOffHeapReferences()) {
            this.offHeapOk = false;
            return;
        }
        Object object = this.offHeapLock;
        synchronized (object) {
            Object nv;
            Object ov = this.basicGetOldValue();
            if (StoredObject.isOffHeapReference(ov)) {
                if (ReferenceCountHelper.trackReferenceCounts()) {
                    ReferenceCountHelper.setReferenceCountOwner(new OldValueOwner());
                    this.oldValue = OffHeapHelper.copyAndReleaseIfNeeded(ov, (InternalCache)this.getRegion().getCache());
                    ReferenceCountHelper.setReferenceCountOwner(null);
                } else {
                    this.oldValue = OffHeapHelper.copyAndReleaseIfNeeded(ov, (InternalCache)this.getRegion().getCache());
                }
            }
            if (StoredObject.isOffHeapReference(nv = this.basicGetNewValue())) {
                ReferenceCountHelper.setReferenceCountOwner(this);
                this.newValue = OffHeapHelper.copyAndReleaseIfNeeded(nv, (InternalCache)this.getRegion().getCache());
                ReferenceCountHelper.setReferenceCountOwner(null);
            }
            if (StoredObject.isOffHeapReference(this.newValue) || StoredObject.isOffHeapReference(this.oldValue)) {
                throw new IllegalStateException("event's old/new value still off-heap after calling copyOffHeapToHeap");
            }
            this.offHeapOk = false;
        }
    }

    public boolean isOldValueOffHeap() {
        return this.isOffHeapReference(this.oldValue);
    }

    public void changeRegionToBucketsOwner() {
        if (this.getRegion().isUsedForPartitionedRegionBucket()) {
            this.setRegion(this.getRegion().getPartitionedRegion());
        }
    }

    public static class SerializedCacheValueImpl
    implements SerializedCacheValue,
    CachedDeserializable,
    Sendable {
        private final EntryEventImpl event;
        private final CachedDeserializable cd;
        private final Region r;
        private final RegionEntry re;
        private final byte[] serializedValue;

        SerializedCacheValueImpl(EntryEventImpl event, Region r, RegionEntry re, CachedDeserializable cd, byte[] serializedBytes) {
            this.event = event.isOffHeapReference(cd) ? event : null;
            this.r = r;
            this.re = re;
            this.cd = cd;
            this.serializedValue = serializedBytes;
        }

        @Override
        public byte[] getSerializedValue() {
            if (this.serializedValue != null) {
                return this.serializedValue;
            }
            return this.callWithOffHeapLock(CachedDeserializable::getSerializedValue);
        }

        private CachedDeserializable getCd() {
            if (this.event != null && !this.event.offHeapOk) {
                throw new IllegalStateException("Attempt to access off heap value after the EntryEvent was released.");
            }
            return this.cd;
        }

        private <R> R callWithOffHeapLock(Function<CachedDeserializable, R> function) {
            if (this.event != null) {
                return (R)this.event.callWithOffHeapLock(this.cd, function);
            }
            return function.apply(this.getCd());
        }

        public Object getDeserializedValue() {
            return this.getDeserializedValue(this.r, this.re);
        }

        @Override
        public Object getDeserializedForReading() {
            return this.getCd().getDeserializedForReading();
        }

        @Override
        public Object getDeserializedWritableCopy(Region rgn, RegionEntry entry) {
            return this.getCd().getDeserializedWritableCopy(rgn, entry);
        }

        @Override
        public Object getDeserializedValue(Region rgn, RegionEntry reentry) {
            return this.callWithOffHeapLock(cd -> cd.getDeserializedValue(rgn, reentry));
        }

        @Override
        public Object getValue() {
            if (this.serializedValue != null) {
                return this.serializedValue;
            }
            return this.getCd().getValue();
        }

        @Override
        public void writeValueAsByteArray(DataOutput out) throws IOException {
            if (this.serializedValue != null) {
                DataSerializer.writeByteArray(this.serializedValue, out);
            } else {
                this.getCd().writeValueAsByteArray(out);
            }
        }

        @Override
        public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
            if (this.serializedValue != null) {
                wrapper.setData(this.serializedValue, userBits, this.serializedValue.length, false);
            } else {
                this.getCd().fillSerializedValue(wrapper, userBits);
            }
        }

        @Override
        public int getValueSizeInBytes() {
            return this.getCd().getValueSizeInBytes();
        }

        @Override
        public int getSizeInBytes() {
            return this.getCd().getSizeInBytes();
        }

        @Override
        public String getStringForm() {
            return this.getCd().getStringForm();
        }

        @Override
        public void sendTo(DataOutput out) throws IOException {
            DataSerializer.writeObject(this.getCd(), out);
        }

        @Override
        public boolean isSerialized() {
            return this.getCd().isSerialized();
        }

        @Override
        public boolean usesHeapForStorage() {
            return this.getCd().usesHeapForStorage();
        }
    }

    private static abstract class EventFlags {
        private static final short FLAG_ORIGIN_REMOTE = 1;
        private static final short FLAG_LOCAL_INVALID = 2;
        private static final short FLAG_GENERATE_CALLBACKS = 4;
        private static final short FLAG_POSSIBLE_DUPLICATE = 8;
        private static final short FLAG_INVOKE_PR_CALLBACKS = 16;
        private static final short FLAG_CONCURRENCY_CONFLICT = 32;
        private static final short FLAG_INHIBIT_LISTENER_NOTIFICATION = 64;
        private static final short FLAG_CALLBACKS_INVOKED = 128;
        private static final short FLAG_ISCREATE = 256;
        private static final short FLAG_SERIALIZATION_DEFERRED = 512;
        private static final short FLAG_FROM_SERVER = 1024;
        private static final short FLAG_FROM_RI_LOCAL_DESTROY = 2048;
        private static final short FLAG_INHIBIT_DISTRIBUTION = 4096;
        private static final short FLAG_REDESTROYED_TOMBSTONE = 8192;
        private static final short FLAG_INHIBIT_ALL_NOTIFICATIONS = 16384;
        private static final short FLAG_TRANSIENT_MASK = -16321;

        private EventFlags() {
        }

        protected static boolean isSet(short flags, short mask) {
            return (flags & mask) != 0;
        }

        protected static short set(short flags, short mask, boolean on) {
            return (short)(on ? flags | mask : flags & ~mask);
        }
    }

    public static interface OldValueImporter {
        public boolean prefersOldSerialized();

        public boolean isUnretainedOldReferenceOk();

        public boolean isCachedDeserializableValueOk();

        public void importOldObject(Object var1, boolean var2);

        public void importOldBytes(byte[] var1, boolean var2);
    }

    public static interface NewValueImporter {
        public boolean prefersNewSerialized();

        public boolean isUnretainedNewReferenceOk();

        public void importNewObject(Object var1, boolean var2);

        public void importNewBytes(byte[] var1, boolean var2);
    }

    private class OldValueOwner {
        private OldValueOwner() {
        }

        private EntryEventImpl getEvent() {
            return EntryEventImpl.this;
        }

        public int hashCode() {
            return this.getEvent().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof OldValueOwner) {
                return this.getEvent().equals(((OldValueOwner)obj).getEvent());
            }
            return false;
        }

        public String toString() {
            return "OldValueOwner " + this.getEvent().toString();
        }
    }
}

