/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class RegionSizeResponse
extends AdminResponse
implements Cancellable {
    private int entryCount;
    private int subregionCount;
    private transient boolean cancelled;

    public static RegionSizeResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        RegionSizeResponse m = new RegionSizeResponse();
        m.setRecipient(recipient);
        return m;
    }

    public void calcSize(Region r) {
        if (this.cancelled) {
            return;
        }
        Set nameSet = r.keySet();
        if (this.cancelled) {
            return;
        }
        this.entryCount = nameSet.size();
        Set<Region<?, ?>> subRegions = r.subregions(false);
        if (this.cancelled) {
            return;
        }
        this.subregionCount = subRegions.size();
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getSubregionCount() {
        return this.subregionCount;
    }

    public int getDSFID() {
        return 1046;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.entryCount);
        out.writeInt(this.subregionCount);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.entryCount = in.readInt();
        this.subregionCount = in.readInt();
    }

    @Override
    public String toString() {
        return "RegionSizeResponse from " + this.getRecipient();
    }
}

