/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.colocation;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.colocation.ColocationLogger;
import org.apache.geode.internal.cache.partitioned.colocation.ColocationLoggerFactory;
import org.apache.geode.internal.cache.partitioned.colocation.SingleThreadColocationLogger;
import org.apache.geode.internal.cache.partitioned.colocation.SingleThreadColocationLoggerConstructor;

class SingleThreadColocationLoggerFactory
implements ColocationLoggerFactory {
    @VisibleForTesting
    static final String LOG_INTERVAL_PROPERTY = "geode.SingleThreadColocationLoggerFactory.LOG_INTERVAL_MILLIS";
    @VisibleForTesting
    static final long DEFAULT_LOG_INTERVAL = 30000L;
    private final long logIntervalMillis;
    private final SingleThreadColocationLoggerConstructor constructor;

    SingleThreadColocationLoggerFactory() {
        this(SingleThreadColocationLogger::new);
    }

    @VisibleForTesting
    SingleThreadColocationLoggerFactory(SingleThreadColocationLoggerConstructor constructor) {
        this(Long.getLong(LOG_INTERVAL_PROPERTY, 30000L), constructor);
    }

    private SingleThreadColocationLoggerFactory(long logIntervalMillis, SingleThreadColocationLoggerConstructor constructor) {
        this.logIntervalMillis = logIntervalMillis;
        this.constructor = constructor;
    }

    @Override
    public ColocationLogger startColocationLogger(PartitionedRegion region) {
        return this.constructor.create(region, this.logIntervalMillis / 2L, this.logIntervalMillis).start();
    }
}

