/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.geode.internal.InternalStatisticsDisabledException;
import org.apache.geode.internal.cache.DiskId;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.DiskEntry;
import org.apache.geode.internal.cache.entries.VMStatsDiskRegionEntryOffHeap;
import org.apache.geode.internal.cache.eviction.EvictionController;
import org.apache.geode.internal.cache.persistence.DiskRecoveryStore;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelper;
import org.apache.geode.internal.util.concurrent.CustomEntryConcurrentHashMap;

public class VMStatsDiskRegionEntryOffHeapStringKey1
extends VMStatsDiskRegionEntryOffHeap {
    private static final AtomicLongFieldUpdater<VMStatsDiskRegionEntryOffHeapStringKey1> LAST_MODIFIED_UPDATER = AtomicLongFieldUpdater.newUpdater(VMStatsDiskRegionEntryOffHeapStringKey1.class, "lastModified");
    protected int hash;
    private CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry;
    private volatile long lastModified;
    private volatile long offHeapAddress;
    private static final AtomicLongFieldUpdater<VMStatsDiskRegionEntryOffHeapStringKey1> OFF_HEAP_ADDRESS_UPDATER = AtomicLongFieldUpdater.newUpdater(VMStatsDiskRegionEntryOffHeapStringKey1.class, "offHeapAddress");
    protected DiskId id;
    private volatile long lastAccessed;
    private volatile int hitCount;
    private volatile int missCount;
    private static final AtomicIntegerFieldUpdater<VMStatsDiskRegionEntryOffHeapStringKey1> HIT_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VMStatsDiskRegionEntryOffHeapStringKey1.class, "hitCount");
    private static final AtomicIntegerFieldUpdater<VMStatsDiskRegionEntryOffHeapStringKey1> MISS_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(VMStatsDiskRegionEntryOffHeapStringKey1.class, "missCount");
    private final long bits1;

    public VMStatsDiskRegionEntryOffHeapStringKey1(RegionEntryContext context, String key, Object value, boolean byteEncode) {
        super(context, value instanceof DiskEntry.RecoveredEntry ? null : value);
        this.initialize(context, value);
        long tempBits1 = 0L;
        if (byteEncode) {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)((byte)key.charAt(i) & 0xFF);
                tempBits1 <<= 8;
            }
            tempBits1 |= 0x40L;
        } else {
            for (int i = key.length() - 1; i >= 0; --i) {
                tempBits1 |= (long)key.charAt(i);
                tempBits1 <<= 16;
            }
        }
        this.bits1 = tempBits1 |= (long)key.length();
    }

    @Override
    public Token getValueAsToken() {
        return OffHeapRegionEntryHelper.getValueAsToken(this);
    }

    @Override
    protected Object getValueField() {
        return OffHeapRegionEntryHelper._getValue(this);
    }

    @Override
    protected void setValueField(Object value) {
        OffHeapRegionEntryHelper.setValue(this, value);
    }

    @Override
    public Object getValueRetain(RegionEntryContext context, boolean decompress) {
        return OffHeapRegionEntryHelper._getValueRetain(this, decompress, context);
    }

    @Override
    public long getAddress() {
        return OFF_HEAP_ADDRESS_UPDATER.get(this);
    }

    @Override
    public boolean setAddress(long expectedAddress, long newAddress) {
        return OFF_HEAP_ADDRESS_UPDATER.compareAndSet(this, expectedAddress, newAddress);
    }

    @Override
    public void release() {
        OffHeapRegionEntryHelper.releaseEntry(this);
    }

    @Override
    public void returnToPool() {
    }

    @Override
    protected long getLastModifiedField() {
        return LAST_MODIFIED_UPDATER.get(this);
    }

    @Override
    protected boolean compareAndSetLastModifiedField(long expectedValue, long newValue) {
        return LAST_MODIFIED_UPDATER.compareAndSet(this, expectedValue, newValue);
    }

    @Override
    public int getEntryHash() {
        return this.hash;
    }

    @Override
    protected void setEntryHash(int hash) {
        this.hash = hash;
    }

    @Override
    public CustomEntryConcurrentHashMap.HashEntry<Object, Object> getNextEntry() {
        return this.nextEntry;
    }

    @Override
    public void setNextEntry(CustomEntryConcurrentHashMap.HashEntry<Object, Object> nextEntry) {
        this.nextEntry = nextEntry;
    }

    protected void initialize(RegionEntryContext context, Object value) {
        this.diskInitialize(context, value);
    }

    @Override
    public int updateAsyncEntrySize(EvictionController evictionController) {
        throw new IllegalStateException("should never be called");
    }

    @Override
    public DiskId getDiskId() {
        return this.id;
    }

    @Override
    public void setDiskId(RegionEntry oldEntry) {
        this.id = ((DiskEntry)oldEntry).getDiskId();
    }

    private void diskInitialize(RegionEntryContext context, Object value) {
        DiskRecoveryStore diskRecoveryStore = (DiskRecoveryStore)((Object)context);
        DiskStoreImpl diskStore = diskRecoveryStore.getDiskStore();
        long maxOplogSize = diskStore.getMaxOplogSize();
        this.id = DiskId.createDiskId(maxOplogSize, true, diskStore.needsLinkedList());
        DiskEntry.Helper.initialize(this, diskRecoveryStore, value);
    }

    @Override
    public void updateStatsForGet(boolean isHit, long time) {
        this.setLastAccessed(time);
        if (isHit) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
    }

    @Override
    protected void setLastModifiedAndAccessedTimes(long lastModified, long lastAccessed) {
        this._setLastModified(lastModified);
        if (!DISABLE_ACCESS_TIME_UPDATE_ON_PUT) {
            this.setLastAccessed(lastAccessed);
        }
    }

    @Override
    public long getLastAccessed() throws InternalStatisticsDisabledException {
        return this.lastAccessed;
    }

    @Override
    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    @Override
    public long getHitCount() throws InternalStatisticsDisabledException {
        return (long)this.hitCount & 0xFFFFFFFFL;
    }

    @Override
    public long getMissCount() throws InternalStatisticsDisabledException {
        return (long)this.missCount & 0xFFFFFFFFL;
    }

    private void incrementHitCount() {
        HIT_COUNT_UPDATER.incrementAndGet(this);
    }

    private void incrementMissCount() {
        MISS_COUNT_UPDATER.incrementAndGet(this);
    }

    @Override
    public void resetCounts() throws InternalStatisticsDisabledException {
        HIT_COUNT_UPDATER.set(this, 0);
        MISS_COUNT_UPDATER.set(this, 0);
    }

    @Override
    public void txDidDestroy(long timeStamp) {
        this.setLastModified(timeStamp);
        this.setLastAccessed(timeStamp);
        this.hitCount = 0;
        this.missCount = 0;
    }

    @Override
    public boolean hasStats() {
        return true;
    }

    private int getKeyLength() {
        return (int)(this.bits1 & 0x3FL);
    }

    private int getEncoding() {
        return (int)(this.bits1 >> 6) & 3;
    }

    @Override
    public Object getKey() {
        int keyLength = this.getKeyLength();
        char[] chars = new char[keyLength];
        long tempBits1 = this.bits1;
        if (this.getEncoding() == 1) {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 8) & 0xFFL);
            }
        } else {
            for (int i = 0; i < keyLength; ++i) {
                chars[i] = (char)((tempBits1 >>= 16) & 0xFFFFL);
            }
        }
        return new String(chars);
    }

    @Override
    public boolean isKeyEqual(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            int keyLength = this.getKeyLength();
            if (stringKey.length() == keyLength) {
                long tempBits1 = this.bits1;
                if (this.getEncoding() == 1) {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 8) & 0xFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                } else {
                    for (int i = 0; i < keyLength; ++i) {
                        char character = (char)((tempBits1 >>= 16) & 0xFFFFL);
                        if (stringKey.charAt(i) == character) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

