/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.management.internal.operation.RegionRedundancyStatusImpl;
import org.apache.geode.management.runtime.RegionRedundancyStatus;

public class SerializableRegionRedundancyStatusImpl
extends RegionRedundancyStatusImpl
implements DataSerializableFixedID {
    public SerializableRegionRedundancyStatusImpl() {
        this.status = RegionRedundancyStatus.RedundancyStatus.NOT_SATISFIED;
    }

    public SerializableRegionRedundancyStatusImpl(PartitionedRegion region) {
        this.regionName = region.getName();
        this.configuredRedundancy = region.getRedundantCopies();
        this.actualRedundancy = this.calculateLowestRedundancy(region);
        this.status = this.determineStatus(this.configuredRedundancy, this.actualRedundancy);
    }

    private int calculateLowestRedundancy(PartitionedRegion region) {
        int numBuckets = region.getPartitionAttributes().getTotalNumBuckets();
        int minRedundancy = Integer.MAX_VALUE;
        for (int i = 0; i < numBuckets; ++i) {
            int bucketRedundancy = region.getRegionAdvisor().getBucketRedundancy(i);
            if (bucketRedundancy == -1 || bucketRedundancy >= minRedundancy) continue;
            minRedundancy = bucketRedundancy;
        }
        return minRedundancy;
    }

    private RegionRedundancyStatus.RedundancyStatus determineStatus(int desiredRedundancy, int actualRedundancy) {
        boolean zeroRedundancy;
        boolean bl = zeroRedundancy = desiredRedundancy == 0;
        if (actualRedundancy == 0) {
            return zeroRedundancy ? RegionRedundancyStatus.RedundancyStatus.SATISFIED : RegionRedundancyStatus.RedundancyStatus.NO_REDUNDANT_COPIES;
        }
        return desiredRedundancy == actualRedundancy ? RegionRedundancyStatus.RedundancyStatus.SATISFIED : RegionRedundancyStatus.RedundancyStatus.NOT_SATISFIED;
    }

    public String toString() {
        return String.format("%s redundancy status: %s. Desired redundancy is %s and actual redundancy is %s.", this.regionName, this.status.name(), this.configuredRedundancy, this.actualRedundancy);
    }

    public int getDSFID() {
        return -161;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeString(this.regionName, out);
        DataSerializer.writeEnum((Enum)this.status, out);
        out.writeInt(this.configuredRedundancy);
        out.writeInt(this.actualRedundancy);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.regionName = DataSerializer.readString(in);
        this.status = DataSerializer.readEnum(RegionRedundancyStatus.RedundancyStatus.class, in);
        this.configuredRedundancy = in.readInt();
        this.actualRedundancy = in.readInt();
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

