/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.admin.CacheInfo;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.CacheConfigResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class CacheConfigRequest
extends AdminRequest {
    private byte attributeCode;
    private int newValue;
    private int cacheId;

    public static CacheConfigRequest create(CacheInfo c, int attCode, int v) {
        CacheConfigRequest m = new CacheConfigRequest();
        m.attributeCode = (byte)attCode;
        m.newValue = v;
        m.cacheId = c.getId();
        return m;
    }

    public CacheConfigRequest() {
        this.friendlyName = "Set a single cache configuration attribute";
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return CacheConfigResponse.create(dm, this.getSender(), this.cacheId, this.attributeCode, this.newValue);
    }

    public int getDSFID() {
        return 1012;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeByte(this.attributeCode);
        out.writeInt(this.newValue);
        out.writeInt(this.cacheId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.attributeCode = in.readByte();
        this.newValue = in.readInt();
        this.cacheId = in.readInt();
    }

    @Override
    public String toString() {
        return "CacheConfigRequest from " + this.getSender();
    }
}

