/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryExecutionTimeoutException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledSelect;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.PathUtils;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.QueryExecutionCanceledException;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.MapType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.logging.log4j.Logger;

public class CompiledIteratorDef
extends AbstractCompiledValue {
    private static final Logger logger = LogService.getLogger();
    private String name;
    private ObjectType elementType;
    private CompiledValue collectionExpr;

    public CompiledIteratorDef(String name, ObjectType elementType, CompiledValue collectionExpr) {
        this.name = name;
        this.elementType = elementType == null ? TypeUtils.OBJECT_TYPE : elementType;
        this.collectionExpr = collectionExpr;
    }

    @Override
    public List getChildren() {
        return Collections.singletonList(this.collectionExpr);
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("Not to be evaluated directly");
    }

    public RuntimeIterator getRuntimeIterator(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        RuntimeIterator rIter = null;
        rIter = (RuntimeIterator)context.cacheGet(this);
        if (rIter != null) {
            return rIter;
        }
        ObjectType type = this.elementType;
        if (type.equals(TypeUtils.OBJECT_TYPE)) {
            ObjectType typc = this.getCollectionElementTypeCast();
            if (typc != null) {
                type = typc;
            } else if (!(this.collectionExpr instanceof CompiledSelect)) {
                type = this.computeElementType(context);
            }
        }
        rIter = new RuntimeIterator(this, type);
        String fromClause = this.genFromClause(context);
        rIter.setDefinition(fromClause);
        if (type.equals(TypeUtils.OBJECT_TYPE) && !this.isDependentOnAnyIteratorOfScopeLessThanItsOwn(context)) {
            this.evaluateCollectionForIndependentIterator(context, rIter);
        }
        context.cachePut(this, rIter);
        return rIter;
    }

    protected void evaluateCollectionForIndependentIterator(ExecutionContext context, RuntimeIterator rIter) throws RegionNotFoundException, TypeMismatchException {
        try {
            rIter.evaluateCollection(context);
        }
        catch (QueryExecutionTimeoutException qet) {
            throw qet;
        }
        catch (RegionNotFoundException re) {
            throw re;
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (QueryExecutionCanceledException e) {
            throw e;
        }
        catch (CacheClosedException e) {
            throw e;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception while getting runtime iterator.", (Throwable)e);
            }
            throw new TypeMismatchException("Exception in evaluating the Collection Expression in getRuntimeIterator() even though the Collection is independent of any RuntimeIterator", e);
        }
    }

    ObjectType getCollectionElementTypeCast() throws TypeMismatchException {
        ObjectType typ = this.collectionExpr.getTypecast();
        if (typ != null) {
            if (!(typ instanceof CollectionType)) {
                throw new TypeMismatchException(String.format("An iterator definition must be a collection type, not a %s", typ));
            }
            if (typ instanceof MapType) {
                return ((MapType)typ).getEntryType();
            }
            return ((CollectionType)typ).getElementType();
        }
        return null;
    }

    SelectResults evaluateCollection(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.evaluateCollection(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectResults evaluateCollection(ExecutionContext context, RuntimeIterator stopAtIter) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ObjectType elmTypc;
        Object coll;
        context.currentScope().setLimit(stopAtIter);
        try {
            coll = this.collectionExpr.evaluate(context);
        }
        finally {
            context.currentScope().setLimit(null);
        }
        if (TypeUtils.OBJECT_TYPE.equals(this.elementType) && (elmTypc = this.getCollectionElementTypeCast()) != null) {
            this.elementType = elmTypc;
        }
        return this.prepareIteratorDef(coll, this.elementType, context);
    }

    @Override
    public int getType() {
        return 49;
    }

    public String getName() {
        return this.name;
    }

    public ObjectType getElementType() {
        return this.elementType;
    }

    public CompiledValue getCollectionExpr() {
        return this.collectionExpr;
    }

    public void setCollectionExpr(CompiledValue collectionExpr) {
        this.collectionExpr = collectionExpr;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        return context.addDependencies(this, this.collectionExpr.computeDependencies(context));
    }

    private ObjectType computeElementType(ExecutionContext context) throws AmbiguousNameException {
        ObjectType type = PathUtils.computeElementTypeOfExpression(context, this.collectionExpr);
        if (type.isMapType()) {
            return ((MapType)type).getEntryType();
        }
        if (type.isCollectionType()) {
            return ((CollectionType)type).getElementType();
        }
        return type;
    }

    private SelectResults prepareIteratorDef(Object obj, ObjectType elementType, ExecutionContext context) throws TypeMismatchException {
        if (obj == null) {
            return null;
        }
        if (obj == QueryService.UNDEFINED) {
            return null;
        }
        if (obj instanceof SelectResults) {
            SelectResults sr = (SelectResults)obj;
            if (!elementType.equals(TypeUtils.OBJECT_TYPE)) {
                sr.setElementType(elementType);
            }
            return sr;
        }
        if (obj instanceof Region) {
            QRegion qRegion = new QRegion((Region)obj, false, context);
            if (!elementType.equals(TypeUtils.OBJECT_TYPE)) {
                qRegion.setElementType(elementType);
            }
            return qRegion;
        }
        if (obj instanceof Collection) {
            ResultsCollectionWrapper res = new ResultsCollectionWrapper(elementType, (Collection)obj);
            res.setModifiable(false);
            return res;
        }
        if (obj instanceof Object[]) {
            if (elementType.equals(TypeUtils.OBJECT_TYPE)) {
                elementType = TypeUtils.getObjectType(obj.getClass().getComponentType());
            }
            ResultsCollectionWrapper res = new ResultsCollectionWrapper(elementType, Arrays.asList((Object[])obj));
            res.setModifiable(false);
            return res;
        }
        if (obj instanceof Map) {
            if (elementType.equals(TypeUtils.OBJECT_TYPE)) {
                elementType = TypeUtils.getObjectType(Map.Entry.class);
            }
            ResultsCollectionWrapper res = new ResultsCollectionWrapper(elementType, ((Map)obj).entrySet());
            res.setModifiable(false);
            return res;
        }
        obj = new Object[]{obj};
        if (elementType.equals(TypeUtils.OBJECT_TYPE)) {
            elementType = TypeUtils.getObjectType(obj.getClass().getComponentType());
        }
        ResultsCollectionWrapper res = new ResultsCollectionWrapper(elementType, Arrays.asList(obj));
        res.setModifiable(false);
        return res;
    }

    String genFromClause(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        StringBuilder sbuff = new StringBuilder();
        this.collectionExpr.generateCanonicalizedExpression(sbuff, context);
        return sbuff.toString();
    }

    boolean isDependentOnAnyIteratorOfScopeLessThanItsOwn(ExecutionContext context) {
        boolean isDep = false;
        Set<RuntimeIterator> dependencySet = context.getDependencySet(this, true);
        Iterator<RuntimeIterator> itr = dependencySet.iterator();
        int currScope = context.currentScope().getScopeID();
        while (itr.hasNext()) {
            RuntimeIterator ritr = itr.next();
            if (ritr.getScopeID() > currScope) continue;
            isDep = true;
            break;
        }
        return isDep;
    }
}

