/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.SetOptions;
import org.apache.geode.redis.internal.executor.string.StringExecutor;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class SetEXExecutor
extends StringExecutor {
    private static final String ERROR_SECONDS_NOT_A_NUMBER = "The expiration argument provided was not a number";
    private static final String ERROR_SECONDS_NOT_LEGAL = "invalid expire time in setex";
    private static final String SUCCESS = "OK";
    private static final int VALUE_INDEX = 3;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long expiration;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisStringCommands stringCommands = this.getRedisStringCommands(context);
        RedisKey key = command.getKey();
        byte[] value = commandElems.get(3);
        byte[] expirationArray = commandElems.get(2);
        try {
            expiration = Coder.bytesToLong(expirationArray);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error(ERROR_SECONDS_NOT_A_NUMBER);
        }
        if (expiration <= 0L) {
            return RedisResponse.error(ERROR_SECONDS_NOT_LEGAL);
        }
        if (!this.timeUnitMillis()) {
            expiration = TimeUnit.SECONDS.toMillis(expiration);
        }
        SetOptions setOptions = new SetOptions(SetOptions.Exists.NONE, expiration, false);
        stringCommands.set(key, new ByteArrayWrapper(value), setOptions);
        return RedisResponse.string(SUCCESS);
    }

    protected boolean timeUnitMillis() {
        return false;
    }
}

