/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.key;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommandsFunctionInvoker;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class ExpireExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long delay;
        List<byte[]> commandElems = command.getProcessedCommand();
        int SECONDS_INDEX = 2;
        RedisKey key = command.getKey();
        byte[] delayByteArray = commandElems.get(SECONDS_INDEX);
        try {
            delay = Coder.bytesToLong(delayByteArray);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error("value is not an integer or out of range");
        }
        if (!this.timeUnitMillis()) {
            delay = TimeUnit.SECONDS.toMillis(delay);
        }
        long timestamp = System.currentTimeMillis() + delay;
        RedisKeyCommandsFunctionInvoker redisKeyCommands = new RedisKeyCommandsFunctionInvoker(context.getRegionProvider().getDataRegion());
        int result = redisKeyCommands.pexpireat(key, timestamp);
        return RedisResponse.integer(result);
    }

    protected boolean timeUnitMillis() {
        return false;
    }
}

