/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommandsFunctionInvoker;
import org.apache.geode.redis.internal.statistics.RedisStats;
import org.apache.logging.log4j.Logger;

public class PassiveExpirationManager {
    private static final Logger logger = LogService.getLogger();
    private final Region<RedisKey, RedisData> dataRegion;
    private final ScheduledExecutorService expirationExecutor;
    private final RedisStats redisStats;
    @VisibleForTesting
    public static final int INTERVAL = 3;

    public PassiveExpirationManager(Region<RedisKey, RedisData> dataRegion, RedisStats redisStats) {
        this.dataRegion = dataRegion;
        this.redisStats = redisStats;
        this.expirationExecutor = LoggingExecutors.newSingleThreadScheduledExecutor((String)"GemFireRedis-PassiveExpiration-");
        this.expirationExecutor.scheduleWithFixedDelay(() -> this.doDataExpiration(dataRegion), 3L, 3L, TimeUnit.MINUTES);
    }

    public void stop() {
        this.expirationExecutor.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDataExpiration(Region<RedisKey, RedisData> redisData) {
        long start = this.redisStats.startPassiveExpirationCheck();
        long expireCount = 0L;
        try {
            long now = System.currentTimeMillis();
            Region localPrimaryData = PartitionRegionHelper.getLocalPrimaryData(redisData);
            RedisKeyCommandsFunctionInvoker redisKeyCommands = new RedisKeyCommandsFunctionInvoker(redisData);
            for (Map.Entry entry : localPrimaryData.entrySet()) {
                try {
                    if (!((RedisData)entry.getValue()).hasExpired(now) || -2L != redisKeyCommands.internalPttl((RedisKey)entry.getKey())) continue;
                    ++expireCount;
                }
                catch (EntryDestroyedException entryDestroyedException) {}
            }
        }
        catch (CacheClosedException now) {
        }
        catch (Error | RuntimeException ex) {
            logger.warn("Passive expiration failed. Will try again in 1 second.", ex);
        }
        finally {
            this.redisStats.endPassiveExpirationCheck(start, expireCount);
        }
    }
}

