/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.wan.serial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.wan.GatewayQueueEvent;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.RegionQueue;
import org.apache.geode.internal.cache.ha.ThreadIdentifier;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import org.apache.geode.internal.cache.wan.GatewaySenderEventDispatcher;
import org.apache.geode.internal.cache.wan.GatewaySenderException;
import org.apache.geode.internal.cache.wan.serial.SerialGatewaySenderEventProcessor;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ConcurrentSerialGatewaySenderEventProcessor
extends AbstractGatewaySenderEventProcessor {
    private static final Logger logger = LogService.getLogger();
    protected final List<SerialGatewaySenderEventProcessor> processors = new ArrayList<SerialGatewaySenderEventProcessor>();
    protected final AbstractGatewaySender sender;
    private GemFireException ex = null;
    private final Set<RegionQueue> queues;

    public ConcurrentSerialGatewaySenderEventProcessor(AbstractGatewaySender sender, ThreadsMonitoring tMonitoring, boolean cleanQueues) {
        super("Event Processor for GatewaySender_" + sender.getId(), sender, tMonitoring);
        this.sender = sender;
        this.initializeMessageQueue(sender.getId(), cleanQueues);
        this.queues = new HashSet<RegionQueue>();
        for (SerialGatewaySenderEventProcessor processor : this.processors) {
            this.queues.add(processor.getQueue());
        }
    }

    @Override
    public int getTotalQueueSize() {
        int totalSize = 0;
        for (RegionQueue regionQueue : this.queues) {
            totalSize += regionQueue.size();
        }
        return totalSize;
    }

    @Override
    protected void initializeMessageQueue(String id, boolean cleanQueues) {
        for (int i = 0; i < this.sender.getDispatcherThreads(); ++i) {
            this.processors.add(new SerialGatewaySenderEventProcessor(this.sender, id + "." + i, this.getThreadMonitorObj(), cleanQueues));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Created the SerialGatewayEventProcessor_{}->{}", (Object)i, (Object)this.processors.get(i));
        }
    }

    @Override
    public int eventQueueSize() {
        int size = 0;
        for (RegionQueue queue : this.queues) {
            size += queue.size();
        }
        return size;
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue) throws IOException, CacheException {
        this.enqueueEvent(operation, event, substituteValue, false);
    }

    @Override
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue, boolean isLastEventInTransaction) throws IOException, CacheException {
        int index = Math.abs(this.getHashCode((EntryEventImpl)event) % this.processors.size());
        this.enqueueEvent(operation, event, substituteValue, index, isLastEventInTransaction);
    }

    public void setModifiedEventId(EntryEventImpl clonedEvent, int index) {
        EventID originalEventId = clonedEvent.getEventId();
        if (logger.isDebugEnabled()) {
            logger.debug("The original EventId is {}", (Object)originalEventId);
        }
        long newThreadId = ThreadIdentifier.createFakeThreadIDForParallelGateway(index, originalEventId.getThreadID(), 0);
        EventID newEventId = new EventID(originalEventId.getMembershipID(), newThreadId, originalEventId.getSequenceID());
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Generated event id for event with key={}, index={}, original event id={}, threadId={}, new event id={}, newThreadId={}:index=" + this.sender.getEventIdIndex(), (Object)this, clonedEvent.getKey(), (Object)index, (Object)originalEventId, (Object)ThreadIdentifier.toDisplayString(originalEventId.getThreadID()), (Object)newEventId, (Object)ThreadIdentifier.toDisplayString(newThreadId));
        }
        clonedEvent.setEventId(newEventId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueEvent(EnumListenerEvent operation, EntryEvent event, Object substituteValue, int index, boolean isLastEventInTransaction) throws CacheException, IOException {
        SerialGatewaySenderEventProcessor serialProcessor = this.processors.get(index);
        if (this.sender.getOrderPolicy() == GatewaySender.OrderPolicy.KEY || this.sender.getOrderPolicy() == GatewaySender.OrderPolicy.PARTITION) {
            EntryEventImpl clonedEvent = new EntryEventImpl((EntryEventImpl)event);
            try {
                this.setModifiedEventId(clonedEvent, index);
                serialProcessor.enqueueEvent(operation, clonedEvent, substituteValue, isLastEventInTransaction);
            }
            finally {
                clonedEvent.release();
            }
        } else {
            serialProcessor.enqueueEvent(operation, event, substituteValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.sender.getEnforceThreadsConnectSameReceiver()) {
            this.processors.get(0).start();
            this.waitForRunningStatus(this.processors.get(0));
            String receiverUniqueId = this.processors.get(0).getExpectedReceiverUniqueId();
            if (isDebugEnabled) {
                logger.debug("First dispatcher is connected to " + receiverUniqueId);
            }
            for (int j = 1; j < this.processors.size(); ++j) {
                this.processors.get(j).setExpectedReceiverUniqueId(receiverUniqueId);
            }
        }
        int n = i = this.sender.getEnforceThreadsConnectSameReceiver() ? 1 : 0;
        while (i < this.processors.size()) {
            if (isDebugEnabled) {
                logger.debug("Starting the serialProcessor {}", (Object)i);
            }
            this.processors.get(i).start();
            ++i;
        }
        try {
            this.waitForRunningStatus();
        }
        catch (GatewaySenderException e) {
            this.ex = e;
        }
        Iterator<SerialGatewaySenderEventProcessor> iterator = this.getRunningStateLock();
        synchronized (iterator) {
            if (this.ex != null) {
                this.setException(this.ex);
                this.setIsStopped(true);
            } else {
                this.setIsStopped(false);
            }
            this.getRunningStateLock().notifyAll();
        }
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            try {
                serialProcessor.join();
            }
            catch (InterruptedException e) {
                if (!isDebugEnabled) continue;
                logger.debug("Got InterruptedException while waiting for child threads to finish.");
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void rebalance() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForRunningStatus(SerialGatewaySenderEventProcessor serialProcessor) {
        Object object = serialProcessor.getRunningStateLock();
        synchronized (object) {
            while (serialProcessor.getException() == null && serialProcessor.isStopped()) {
                try {
                    serialProcessor.getRunningStateLock().wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            Exception ex = serialProcessor.getException();
            if (ex != null) {
                throw new GatewaySenderException(String.format("Could not start a gateway sender %s because of exception %s", this.sender.getId(), ex.getMessage()), ex.getCause());
            }
        }
    }

    private void waitForRunningStatus() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            this.waitForRunningStatus(serialProcessor);
        }
    }

    private int getHashCode(EntryEventImpl event) {
        int eventHashCode = 0;
        switch (this.sender.getOrderPolicy()) {
            case KEY: {
                eventHashCode = event.getKey().hashCode();
                break;
            }
            case THREAD: {
                EventID eventId = event.getEventId();
                byte[] memberId = eventId.getMembershipID();
                long threadId = eventId.getThreadID();
                int memberIdHashCode = Arrays.hashCode(memberId);
                int threadIdHashCode = (int)(threadId ^ threadId >>> 32);
                eventHashCode = memberIdHashCode + threadIdHashCode;
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated hashcode for event with key={}, memberId={}, threadId={}: {}", (Object)this, event.getKey(), (Object)Arrays.toString(memberId), (Object)threadId, (Object)eventHashCode);
                break;
            }
            case PARTITION: {
                int n = eventHashCode = PartitionRegionHelper.isPartitionedRegion(event.getRegion()) ? PartitionedRegionHelper.getHashKey(event) : event.getKey().hashCode();
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: Generated partition hashcode for event with key={}: {}", (Object)this, event.getKey(), (Object)eventHashCode);
            }
        }
        return eventHashCode;
    }

    @Override
    public void stopProcessing() {
        if (!this.isAlive()) {
            return;
        }
        this.setIsStopped(true);
        ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable> stopperCallables = new ArrayList<AbstractGatewaySenderEventProcessor.SenderStopperCallable>();
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            stopperCallables.add(new AbstractGatewaySenderEventProcessor.SenderStopperCallable(serialProcessor));
        }
        ExecutorService stopperService = LoggingExecutors.newFixedThreadPool((int)this.processors.size(), (String)"ConcurrentSerialGatewaySenderEventProcessor Stopper Thread", (boolean)true);
        try {
            List futures = stopperService.invokeAll(stopperCallables);
            for (Future f : futures) {
                try {
                    boolean b = (Boolean)f.get();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("ConcurrentSerialGatewaySenderEventProcessor: {} stopped dispatching: {}", (Object)(b ? "Successfully" : "Unsuccessfully"), (Object)this);
                }
                catch (ExecutionException e) {
                    logger.warn("GatewaySender {} caught exception while stopping: {}", new Object[]{this.sender, e.getCause()});
                }
            }
        }
        catch (InterruptedException e) {
            throw new InternalGemFireException(e.getMessage());
        }
        stopperService.shutdown();
        this.closeProcessor();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentSerialGatewaySenderEventProcessor: Stopped dispatching: {}", (Object)this);
        }
    }

    @Override
    public void closeProcessor() {
        for (SerialGatewaySenderEventProcessor processor : this.processors) {
            processor.closeProcessor();
        }
    }

    @Override
    public void pauseDispatching() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.pauseDispatching();
        }
        super.pauseDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentSerialGatewaySenderEventProcessor: Paused dispatching: {}", (Object)this);
        }
    }

    @Override
    public void resumeDispatching() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.resumeDispatching();
        }
        super.resumeDispatching();
        if (logger.isDebugEnabled()) {
            logger.debug("ConcurrentSerialGatewaySenderEventProcessor: Resumed dispatching: {}", (Object)this);
        }
    }

    public List<SerialGatewaySenderEventProcessor> getProcessors() {
        return new LinkedList<SerialGatewaySenderEventProcessor>(this.processors);
    }

    public Set<RegionQueue> getQueues() {
        return this.queues;
    }

    @Override
    public void removeCacheListener() {
        for (SerialGatewaySenderEventProcessor processor : this.processors) {
            processor.removeCacheListener();
        }
    }

    @Override
    public void waitForDispatcherToPause() {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.waitForDispatcherToPause();
        }
    }

    @Override
    public GatewaySenderEventDispatcher getDispatcher() {
        return this.processors.get(0).getDispatcher();
    }

    @Override
    public void initializeEventDispatcher() {
    }

    @Override
    protected void registerEventDroppedInPrimaryQueue(EntryEventImpl droppedEvent) {
        int index = Math.abs(this.getHashCode(droppedEvent) % this.processors.size());
        this.setModifiedEventId(droppedEvent, index);
        this.processors.get(index).sendBatchDestroyOperationForDroppedEvent(droppedEvent, index);
    }

    @Override
    protected void enqueueEvent(GatewayQueueEvent event) {
        for (SerialGatewaySenderEventProcessor serialProcessor : this.processors) {
            serialProcessor.enqueueEvent(event);
        }
    }

    protected ThreadsMonitoring getThreadMonitorObj() {
        DistributionManager distributionManager = this.sender.getDistributionManager();
        if (distributionManager != null) {
            return distributionManager.getThreadMonitoring();
        }
        return null;
    }

    @Override
    public String printUnprocessedEvents() {
        return this.processors.stream().map(processor -> processor.printUnprocessedEvents()).collect(Collectors.joining(", "));
    }

    @Override
    public String printUnprocessedTokens() {
        return this.processors.stream().map(processor -> processor.printUnprocessedTokens()).collect(Collectors.joining(", "));
    }
}

