/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverHolder;
import org.apache.geode.internal.cache.Conflatable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.ha.HAContainerWrapper;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.ha.HARegionQueueAttributes;
import org.apache.geode.internal.cache.ha.HARegionQueueStats;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxyStats;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ClientMarkerMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.MessageTooLargeException;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.ByteArrayDataInput;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.util.internal.UncheckedUtils;
import org.apache.logging.log4j.Logger;

public class MessageDispatcher
extends LoggingThread {
    private static final Logger logger = LogService.getLogger();
    private static final long DEFAULT_SLOW_STARTING_TIME = 5000L;
    private static final String KEY_SLOW_START_TIME_FOR_TESTING = "slowStartTimeForTesting";
    protected final HARegionQueue _messageQueue;
    private final CacheClientProxy _proxy;
    private volatile boolean _isStopped = true;
    protected final Object _pausedLock = new Object();
    private final Object _stopDispatchingLock = new Object();
    private final ReadWriteLock socketLock = new ReentrantReadWriteLock();
    private final Lock socketWriteLock = this.socketLock.writeLock();

    protected MessageDispatcher(CacheClientProxy proxy, String name, StatisticsClock statisticsClock) throws CacheException {
        super(name);
        this._proxy = proxy;
        try {
            boolean canHandleDelta;
            HARegionQueueAttributes harq = new HARegionQueueAttributes();
            harq.setBlockingQueueCapacity(proxy._maximumMessageCount);
            harq.setExpiryTime(proxy._messageTimeToLive);
            ((HAContainerWrapper)proxy._cacheClientNotifier.getHaContainer()).putProxy(HARegionQueue.createRegionName(this.getProxy().getHARegionName()), this.getProxy());
            boolean createDurableQueue = proxy.proxyID.isDurable();
            boolean bl = canHandleDelta = InternalDistributedSystem.getAnyInstance().getConfig().getDeltaPropagation() && this._proxy.clientConflation != 1;
            if ((createDurableQueue || canHandleDelta) && logger.isDebugEnabled()) {
                logger.debug("Creating a {} subscription queue for {}", (Object)(createDurableQueue ? "durable" : "non-durable"), (Object)proxy.getProxyID());
            }
            this._messageQueue = HARegionQueue.getHARegionQueueInstance(this.getProxy().getHARegionName(), this.getCache(), harq, 1, createDurableQueue, proxy._cacheClientNotifier.getHaContainer(), proxy.getProxyID(), this._proxy.clientConflation, this._proxy.isPrimary(), canHandleDelta, statisticsClock);
            if (this._proxy.hasRegisteredInterested()) {
                this._messageQueue.setHasRegisteredInterest(true);
            }
        }
        catch (CancelException | RegionExistsException e) {
            throw e;
        }
        catch (Exception e) {
            this.getCache().getCancelCriterion().checkCancelInProgress(e);
            throw new CacheException("Exception occurred while trying to create a message queue.", e){
                private static final long serialVersionUID = 0L;
            };
        }
    }

    private CacheClientProxy getProxy() {
        return this._proxy;
    }

    private InternalCache getCache() {
        return this.getProxy().getCache();
    }

    private Socket getSocket() {
        return this.getProxy().getSocket();
    }

    private ByteBuffer getCommBuffer() {
        return this.getProxy().getCommBuffer();
    }

    private CacheClientProxyStats getStatistics() {
        return this.getProxy().getStatistics();
    }

    private void basicStopDispatching() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: notified dispatcher to stop", (Object)this);
        }
        this._isStopped = true;
    }

    public String toString() {
        return this.getProxy().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stopDispatching(boolean checkQueue) {
        if (this.isStopped()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Stopping dispatching", (Object)this);
        }
        if (!checkQueue) {
            this.basicStopDispatching();
            return;
        }
        try {
            for (int numberOfPeeks = 0; numberOfPeeks < CacheClientProxy.MAXIMUM_SHUTDOWN_PEEKS; ++numberOfPeeks) {
                boolean interrupted = Thread.interrupted();
                try {
                    List events = this._messageQueue.peek(1, -1);
                    if (events != null && events.size() != 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Waiting for client to drain queue: {}", (Object)this._proxy.proxyID);
                        }
                        Thread.sleep(500L);
                        continue;
                    }
                    break;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                catch (CancelException e) {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
                catch (CacheException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("{}: Exception occurred while trying to stop dispatching", (Object)this, (Object)e);
                    continue;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        finally {
            this.basicStopDispatching();
        }
    }

    protected boolean isStopped() {
        return this._isStopped;
    }

    protected int getQueueSize() {
        return this._messageQueue == null ? 0 : this._messageQueue.size();
    }

    protected int getQueueSizeStat() {
        if (this._messageQueue != null) {
            HARegionQueueStats stats = this._messageQueue.getStatistics();
            return (int)(stats.getEventsEnqued() - stats.getEventsRemoved() - stats.getEventsConflated() - stats.getMarkerEventsConflated() - stats.getEventsExpired() - stats.getEventsRemovedByQrm() - stats.getEventsTaken() - stats.getNumVoidRemovals());
        }
        return 0;
    }

    protected void drainClientCqEvents(ClientProxyMembershipID clientId, InternalCqQuery cqToClose) {
        this._messageQueue.closeClientCq(clientId, cqToClose);
    }

    public void run() {
        if (CacheClientProxy.isSlowStartForTesting) {
            long slowStartTimeForTesting = Long.getLong(KEY_SLOW_START_TIME_FOR_TESTING, 5000L);
            long elapsedTime = 0L;
            long startTime = System.currentTimeMillis();
            while (slowStartTimeForTesting > elapsedTime && CacheClientProxy.isSlowStartForTesting) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ignore) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Slow start for testing interrupted");
                    break;
                }
                elapsedTime = System.currentTimeMillis() - startTime;
            }
            if (slowStartTimeForTesting < elapsedTime) {
                CacheClientProxy.isSlowStartForTesting = false;
            }
        }
        this.runDispatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void runDispatcher() {
        boolean exceptionOccurred = false;
        this._isStopped = false;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Beginning to process events", (Object)this);
        }
        ClientMessage clientMessage = null;
        while (!this.isStopped() && !this._proxy._cache.getCancelCriterion().isCancelInProgress()) {
            try {
                if (this.getProxy().isPaused()) {
                    Object object = this._pausedLock;
                    synchronized (object) {
                        try {
                            logger.info("available ids = " + this._messageQueue.size() + " , isEmptyAckList =" + this._messageQueue.isEmptyAckList() + ", peekInitialized = " + this._messageQueue.isPeekInitialized());
                            while (!this._messageQueue.isEmptyAckList() && this._messageQueue.isPeekInitialized()) {
                                this._messageQueue.remove();
                            }
                        }
                        catch (InterruptedException ex) {
                            logger.warn("{}: sleep interrupted.", (Object)this);
                        }
                    }
                    this.waitForResumption();
                }
                try {
                    clientMessage = (ClientMessage)this._messageQueue.peek();
                }
                catch (RegionDestroyedException skipped) {
                    break;
                }
                this.getStatistics().setQueueSize(this._messageQueue.size());
                if (this.isStopped()) break;
                if (clientMessage != null) {
                    long start = this.getStatistics().startTime();
                    boolean isDispatched = this.dispatchMessage(clientMessage);
                    this.getStatistics().endMessage(start);
                    if (isDispatched) {
                        this._messageQueue.remove();
                        if (clientMessage instanceof ClientMarkerMessageImpl) {
                            this.getProxy().setMarkerEnqueued(false);
                        }
                    }
                } else {
                    this._messageQueue.remove();
                }
                clientMessage = null;
            }
            catch (MessageTooLargeException e) {
                logger.warn("Message too large to send to client: {}, {}", clientMessage, (Object)e.getMessage());
            }
            catch (IOException e) {
                Object ex = this._stopDispatchingLock;
                synchronized (ex) {
                    if (!this.isStopped() && !this.getProxy().isPaused()) {
                        if ("Broken pipe".equals(e.getMessage())) {
                            logger.warn("{}: Proxy closing due to unexpected broken pipe on socket connection.", (Object)this);
                        } else if ("Connection reset".equals(e.getMessage())) {
                            logger.warn("{}: Proxy closing due to unexpected reset on socket connection.", (Object)this);
                        } else if ("Connection reset by peer".equals(e.getMessage())) {
                            logger.warn("{}: Proxy closing due to unexpected reset by peer on socket connection.", (Object)this);
                        } else if ("Socket is closed".equals(e.getMessage()) || "Socket Closed".equals(e.getMessage())) {
                            logger.info("{}: Proxy closing due to socket being closed locally.", (Object)this);
                        } else {
                            logger.warn(String.format("%s: An unexpected IOException occurred so the proxy will be closed.", new Object[]{this}), (Throwable)e);
                        }
                        this.pauseOrUnregisterProxy(e);
                    }
                }
                exceptionOccurred = true;
            }
            catch (InterruptedException e) {
                if (this.getProxy().isPaused()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: interrupted because it is being paused. It will continue and wait for resumption.", (Object)this);
                    }
                    Thread.interrupted();
                    continue;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug("{}: interrupted", (Object)this);
                break;
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: shutting down due to cancellation", (Object)this);
                }
                exceptionOccurred = true;
                break;
            }
            catch (RegionDestroyedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: shutting down due to loss of message queue", (Object)this);
                }
                exceptionOccurred = true;
                break;
            }
            catch (Exception e) {
                if (this.isStopped()) continue;
                logger.fatal(String.format("%s : An unexpected Exception occurred", new Object[]{this}), (Throwable)e);
            }
        }
        if (!exceptionOccurred) {
            ArrayList list = new ArrayList();
            try {
                Thread.interrupted();
                int size = this._messageQueue.size();
                list.addAll((Collection)UncheckedUtils.uncheckedCast((Object)this._messageQueue.peek(size)));
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: After flagging the dispatcher to stop , the residual List of messages to be dispatched={} size={}", (Object)this, list, (Object)list.size());
                }
                if (list.size() > 0) {
                    long start = this.getStatistics().startTime();
                    Iterator itr = list.iterator();
                    while (itr.hasNext()) {
                        this.dispatchMessage((ClientMessage)itr.next());
                        this.getStatistics().endMessage(start);
                        itr.remove();
                    }
                    this._messageQueue.remove();
                }
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CacheClientNotifier stopped due to cancellation");
                }
            }
            catch (Exception e) {
                String extraMsg = null;
                if ("Broken pipe".equals(e.getMessage())) {
                    extraMsg = "Problem caused by broken pipe on socket.";
                } else if (e instanceof RegionDestroyedException) {
                    extraMsg = "Problem caused by message queue being closed.";
                }
                if (extraMsg == null) {
                    extraMsg = "Problem caused by: " + e.getMessage();
                }
                logger.info(String.format("%s Possibility of not being able to send some or all of the messages to clients. Total messages currently present in the list %s.", !this.isStopped() ? this.toString() + ": " : "", list.size()));
                logger.info(extraMsg);
            }
            if (!list.isEmpty() && logger.isTraceEnabled()) {
                logger.trace("Messages remaining in the list are: {}", list);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Dispatcher thread is ending", (Object)this);
        }
    }

    private void pauseOrUnregisterProxy(Throwable t) {
        ClientHealthMonitor chm;
        if (this.getProxy().isDurable()) {
            try {
                this.getProxy().pauseDispatching();
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: {}", (Object)this, (Object)ex);
                }
            }
        } else {
            this._isStopped = true;
        }
        if ((chm = ClientHealthMonitor.getInstance()) != null) {
            ClientProxyMembershipID proxyID = this.getProxy().proxyID;
            chm.removeAllConnectionsAndUnregisterClient(proxyID, t);
            if (!this.getProxy().isDurable()) {
                this.getProxy().getCacheClientNotifier().unregisterClient(proxyID, false);
            }
        }
    }

    protected boolean dispatchMessage(ClientMessage clientMessage) throws IOException {
        Message message;
        boolean isDispatched = false;
        if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER_VERBOSE)) {
            logger.trace(LogMarker.BRIDGE_SERVER_VERBOSE, "Dispatching {}", (Object)clientMessage);
        }
        if (clientMessage instanceof ClientUpdateMessage) {
            byte[] latestValue = (byte[])((ClientUpdateMessage)clientMessage).getValue();
            if (logger.isTraceEnabled()) {
                StringBuilder msg = new StringBuilder(100);
                msg.append((Object)this).append(": Using latest value: ").append(Arrays.toString(latestValue));
                if (((ClientUpdateMessage)clientMessage).valueIsObject()) {
                    if (latestValue != null) {
                        msg.append(" (").append(this.deserialize(latestValue)).append(")");
                    }
                    msg.append(" for ").append(clientMessage);
                }
                logger.trace(msg.toString());
            }
            message = ((ClientUpdateMessageImpl)clientMessage).getMessage(this.getProxy(), latestValue);
            if (CacheClientProxy.AFTER_MESSAGE_CREATION_FLAG) {
                ClientServerObserver bo = ClientServerObserverHolder.getInstance();
                bo.afterMessageCreation(message);
            }
        } else {
            message = clientMessage.getMessage(this.getProxy(), true);
        }
        if (!this._proxy.isPaused()) {
            this.sendMessage(message);
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Dispatched {}", (Object)this, (Object)clientMessage);
            }
            isDispatched = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Message Dispatcher of a Paused CCProxy is trying to dispatch message");
        }
        if (isDispatched) {
            this._messageQueue.getStatistics().incEventsDispatched();
        }
        return isDispatched;
    }

    private void sendMessage(Message message) throws IOException {
        if (message == null) {
            return;
        }
        this.socketWriteLock.lock();
        try {
            message.setComms(this.getSocket(), this.getCommBuffer(), this.getStatistics());
            message.send();
            this.getProxy().resetPingCounter();
        }
        finally {
            this.socketWriteLock.unlock();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{}: Sent {}", (Object)this, (Object)message);
        }
    }

    protected void enqueueMessage(Conflatable clientMessage) {
        block5: {
            try {
                this._messageQueue.put(clientMessage);
                if (this._proxy.isPaused() && this._proxy.isDurable()) {
                    this._proxy._cacheClientNotifier.statistics.incEventEnqueuedWhileClientAwayCount();
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Queued message while Durable Client is away {}", (Object)this, (Object)clientMessage);
                    }
                }
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.isStopped()) break block5;
                this._proxy._statistics.incMessagesFailedQueued();
                logger.fatal(String.format("%s: Exception occurred while attempting to add message to queue", new Object[]{this}), (Throwable)e);
            }
        }
    }

    protected void enqueueMarker(ClientMessage message) {
        block5: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Queueing marker message. <{}>. The queue contains {} entries.", (Object)this, (Object)message, (Object)this.getQueueSize());
                }
                this._messageQueue.put(message);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Queued marker message. The queue contains {} entries.", (Object)this, (Object)this.getQueueSize());
                }
            }
            catch (CancelException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.isStopped()) break block5;
                logger.fatal(String.format("%s : Exception occurred while attempting to add message to queue", new Object[]{this}), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessageDirectly(ClientMessage clientMessage) {
        block10: {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Dispatching directly: {}", (Object)this, (Object)clientMessage);
                }
                Message message = clientMessage.getMessage(this.getProxy(), true);
                this.sendMessage(message);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Dispatched directly: {}", (Object)this, (Object)clientMessage);
                }
            }
            catch (MessageTooLargeException e) {
                logger.warn("Message too large to send to client: {}, {}", (Object)clientMessage, (Object)e.getMessage());
            }
            catch (IOException e) {
                Object object = this._stopDispatchingLock;
                synchronized (object) {
                    if (!this.isStopped() && !this.getProxy().isPaused()) {
                        logger.fatal(String.format("%s : An unexpected Exception occurred", new Object[]{this}), (Throwable)e);
                        this.pauseOrUnregisterProxy(e);
                    }
                }
            }
            catch (Exception e) {
                if (this.isStopped()) break block10;
                logger.fatal(String.format("%s : An unexpected Exception occurred", new Object[]{this}), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForResumption() throws InterruptedException {
        Object object = this._pausedLock;
        synchronized (object) {
            logger.info("{} : Pausing processing", (Object)this);
            if (!this.getProxy().isPaused()) {
                return;
            }
            while (this.getProxy().isPaused()) {
                this._pausedLock.wait();
            }
            this._messageQueue.clearPeekedIDs();
        }
    }

    protected void resumeDispatching() {
        logger.info("{} : Resuming processing", (Object)this);
        this._pausedLock.notifyAll();
    }

    protected Object deserialize(byte[] serializedBytes) {
        Object deserializedObject = serializedBytes;
        try (ByteArrayDataInput dis = new ByteArrayDataInput(serializedBytes);){
            deserializedObject = DataSerializer.readObject((DataInput)dis);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deserializedObject;
    }

    protected void initializeTransients() {
        while (!this._messageQueue.isEmptyAckList() && this._messageQueue.isPeekInitialized()) {
            try {
                this._messageQueue.remove();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this._messageQueue.initializeTransients();
    }
}

