/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.distributed.internal.ServerLocationAndMemberId;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.logging.internal.executors.LoggingExecutors;

public class LocatorLoadSnapshot {
    private static final String LOAD_IMBALANCE_THRESHOLD_PROPERTY_NAME = "gemfire.locator-load-imbalance-threshold";
    public static final float DEFAULT_LOAD_IMBALANCE_THRESHOLD = 10.0f;
    private final Map<ServerLocation, String[]> serverGroupMap = new HashMap<ServerLocation, String[]>();
    private final Map<String, Map<ServerLocationAndMemberId, LoadHolder>> connectionLoadMap = new HashMap<String, Map<ServerLocationAndMemberId, LoadHolder>>();
    private final Map<String, Map<ServerLocation, LoadHolder>> queueLoadMap = new HashMap<String, Map<ServerLocation, LoadHolder>>();
    private final ConcurrentMap<EstimateMapKey, LoadEstimateTask> estimateMap = new ConcurrentHashMap<EstimateMapKey, LoadEstimateTask>();
    private float loadImbalanceThreshold;
    private boolean rebalancing;
    private final ScheduledExecutorService estimateTimeoutProcessor = LoggingExecutors.newScheduledThreadPool((int)1, (String)"loadEstimateTimeoutProcessor", (boolean)false);

    public LocatorLoadSnapshot() {
        this.connectionLoadMap.put(null, new HashMap());
        this.queueLoadMap.put(null, new HashMap());
        String property = System.getProperty(LOAD_IMBALANCE_THRESHOLD_PROPERTY_NAME);
        this.loadImbalanceThreshold = property != null ? Float.parseFloat(property) : 10.0f;
    }

    public synchronized void addServer(ServerLocation location, String memberId, String[] groups, ServerLoad initialLoad, long loadPollInterval) {
        this.serverGroupMap.put(location, groups);
        LoadHolder connectionLoad = new LoadHolder(location, initialLoad.getConnectionLoad(), initialLoad.getLoadPerConnection(), loadPollInterval);
        this.addGroups(this.connectionLoadMap, groups, connectionLoad, memberId);
        LoadHolder queueLoad = new LoadHolder(location, initialLoad.getSubscriptionConnectionLoad(), initialLoad.getLoadPerSubscriptionConnection(), loadPollInterval);
        this.addGroups(this.queueLoadMap, groups, queueLoad);
        this.updateLoad(location, memberId, initialLoad);
    }

    public synchronized void removeServer(ServerLocation location, String memberId) {
        String[] groups = this.serverGroupMap.remove(location);
        if (groups != null) {
            this.removeFromMap(this.connectionLoadMap, groups, location, memberId);
            this.removeFromMap(this.queueLoadMap, groups, location);
        }
    }

    public void updateLoad(ServerLocation location, String memberId, ServerLoad newLoad) {
        this.updateLoad(location, memberId, newLoad, null);
    }

    synchronized void updateLoad(ServerLocation location, String memberId, ServerLoad newLoad, List<ClientProxyMembershipID> clientIds) {
        String[] groups = this.serverGroupMap.get(location);
        if (groups == null) {
            return;
        }
        if (clientIds != null) {
            for (ClientProxyMembershipID clientId : clientIds) {
                this.cancelClientEstimate(clientId, location);
            }
        }
        this.updateMap(this.connectionLoadMap, location, memberId, newLoad.getConnectionLoad(), newLoad.getLoadPerConnection());
        this.updateMap(this.queueLoadMap, location, newLoad.getSubscriptionConnectionLoad(), newLoad.getLoadPerSubscriptionConnection());
    }

    public synchronized boolean hasBalancedConnections(String group) {
        if ("".equals(group)) {
            group = null;
        }
        Map<ServerLocationAndMemberId, LoadHolder> groupServers = this.connectionLoadMap.get(group);
        return this.isBalanced(groupServers);
    }

    private synchronized boolean isBalanced(Map<ServerLocationAndMemberId, LoadHolder> groupServers) {
        return this.isBalanced(groupServers, false);
    }

    private synchronized boolean isBalanced(Map<ServerLocationAndMemberId, LoadHolder> groupServers, boolean withThresholdCheck) {
        boolean balanced;
        if (groupServers == null || groupServers.isEmpty()) {
            return true;
        }
        float bestLoad = Float.MAX_VALUE;
        float largestLoadPerConnection = Float.MIN_VALUE;
        float worstLoad = Float.MIN_VALUE;
        for (Map.Entry<ServerLocationAndMemberId, LoadHolder> loadHolderEntry : groupServers.entrySet()) {
            LoadHolder nextLoadReference = loadHolderEntry.getValue();
            float nextLoad = nextLoadReference.getLoad();
            float nextLoadPerConnection = nextLoadReference.getLoadPerConnection();
            if (nextLoad < bestLoad) {
                bestLoad = nextLoad;
            }
            if (nextLoad > worstLoad) {
                worstLoad = nextLoad;
            }
            if (!(nextLoadPerConnection > largestLoadPerConnection)) continue;
            largestLoadPerConnection = nextLoadPerConnection;
        }
        boolean bl = balanced = worstLoad - bestLoad <= largestLoadPerConnection;
        if (withThresholdCheck) {
            balanced = this.thresholdCheck(bestLoad, worstLoad, largestLoadPerConnection, balanced);
        }
        return balanced;
    }

    private synchronized boolean thresholdCheck(float bestLoad, float worstLoad, float largestLoadPerConnection, boolean balanced) {
        if (this.rebalancing) {
            if (balanced) {
                this.rebalancing = false;
            }
            return balanced;
        }
        if (!balanced) {
            float imbalance = worstLoad - bestLoad;
            if (imbalance >= largestLoadPerConnection * this.loadImbalanceThreshold) {
                this.rebalancing = true;
            } else {
                balanced = true;
            }
        }
        return balanced;
    }

    synchronized boolean isRebalancing() {
        return this.rebalancing;
    }

    public synchronized ServerLocation getServerForConnection(String group, Set<ServerLocation> excludedServers) {
        Map<ServerLocationAndMemberId, LoadHolder> groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = this.connectionLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return null;
        }
        List<LoadHolder> bestLHs = this.findBestServers(groupServers, excludedServers, 1);
        if (bestLHs.isEmpty()) {
            return null;
        }
        LoadHolder lh = bestLHs.get(0);
        lh.incConnections();
        return lh.getLocation();
    }

    public synchronized ArrayList getServers(String group) {
        Map<ServerLocationAndMemberId, LoadHolder> groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = this.connectionLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return null;
        }
        ArrayList<ServerLocation> result = new ArrayList<ServerLocation>();
        for (ServerLocationAndMemberId locationAndMemberId : groupServers.keySet()) {
            result.add(locationAndMemberId.getServerLocation());
        }
        return result;
    }

    public void shutDown() {
        this.estimateTimeoutProcessor.shutdown();
    }

    public synchronized ServerLocation getReplacementServerForConnection(ServerLocation currentServer, String group, Set<ServerLocation> excludedServers) {
        Map<ServerLocationAndMemberId, LoadHolder> groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = this.connectionLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return null;
        }
        if (this.isBalanced(groupServers, true)) {
            return currentServer;
        }
        LoadHolder currentServerLH = this.isCurrentServerMostLoaded(currentServer, groupServers);
        if (currentServerLH == null) {
            return currentServer;
        }
        List<LoadHolder> bestLHs = this.findBestServers(groupServers, excludedServers, 1);
        if (bestLHs.isEmpty()) {
            return null;
        }
        LoadHolder bestLH = bestLHs.get(0);
        currentServerLH.decConnections();
        bestLH.incConnections();
        return bestLH.getLocation();
    }

    public List getServersForQueue(String group, Set<ServerLocation> excludedServers, int count) {
        return this.getServersForQueue(null, group, excludedServers, count);
    }

    synchronized List<ServerLocation> getServersForQueue(ClientProxyMembershipID id, String group, Set<ServerLocation> excludedServers, int count) {
        Map<ServerLocation, LoadHolder> groupServers;
        if ("".equals(group)) {
            group = null;
        }
        if ((groupServers = this.queueLoadMap.get(group)) == null || groupServers.isEmpty()) {
            return Collections.emptyList();
        }
        List<LoadHolder> bestLHs = this.findBestServers(groupServers, excludedServers, count);
        ArrayList<ServerLocation> result = new ArrayList<ServerLocation>(bestLHs.size());
        if (id != null) {
            ClientProxyMembershipID.Identity actualId = id.getIdentity();
            for (LoadHolder load : bestLHs) {
                EstimateMapKey key = new EstimateMapKey(actualId, load.getLocation());
                LoadEstimateTask task = new LoadEstimateTask(key, load);
                try {
                    long MIN_TIMEOUT = 60000L;
                    long timeout = load.getLoadPollInterval() * 2L;
                    if (timeout < 60000L) {
                        timeout = 60000L;
                    }
                    task.setFuture(this.estimateTimeoutProcessor.schedule(task, timeout, TimeUnit.MILLISECONDS));
                    this.addEstimate(key, task);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                result.add(load.getLocation());
            }
        } else {
            for (LoadHolder load : bestLHs) {
                load.incConnections();
                result.add(load.getLocation());
            }
        }
        return result;
    }

    public synchronized Map<ServerLocation, ServerLoad> getLoadMap() {
        Map<ServerLocationAndMemberId, LoadHolder> connectionMap = this.connectionLoadMap.get(null);
        Map<ServerLocation, LoadHolder> queueMap = this.queueLoadMap.get(null);
        HashMap<ServerLocation, ServerLoad> result = new HashMap<ServerLocation, ServerLoad>();
        for (Map.Entry<ServerLocationAndMemberId, LoadHolder> entry : connectionMap.entrySet()) {
            ServerLocation location = entry.getKey().getServerLocation();
            LoadHolder connectionLoad = entry.getValue();
            LoadHolder queueLoad = queueMap.get(location);
            if (queueLoad == null) continue;
            result.put(location, new ServerLoad(connectionLoad.getLoad(), connectionLoad.getLoadPerConnection(), queueLoad.getLoad(), queueLoad.getLoadPerConnection()));
        }
        return result;
    }

    @VisibleForTesting
    void addGroups(Map<String, Map<ServerLocation, LoadHolder>> map, String[] groups, LoadHolder holder) {
        for (String group : groups) {
            Map groupMap = map.computeIfAbsent(group, k -> new HashMap());
            groupMap.put(holder.getLocation(), holder);
        }
        if (groups.length <= 0 || !groups[0].equals("__recv__group")) {
            Map groupMap = map.computeIfAbsent(null, k -> new HashMap());
            groupMap.put(holder.getLocation(), holder);
        }
    }

    @VisibleForTesting
    void addGroups(Map<String, Map<ServerLocationAndMemberId, LoadHolder>> map, String[] groups, LoadHolder holder, String memberId) {
        for (String group : groups) {
            Map groupMap = map.computeIfAbsent(group, k -> new HashMap());
            groupMap.put(new ServerLocationAndMemberId(holder.getLocation(), memberId), holder);
        }
        if (groups.length <= 0 || !groups[0].equals("__recv__group")) {
            Map groupMap = map.computeIfAbsent(null, k -> new HashMap());
            groupMap.put(new ServerLocationAndMemberId(holder.getLocation(), memberId), holder);
        }
    }

    @VisibleForTesting
    void removeFromMap(Map<String, Map<ServerLocation, LoadHolder>> map, String[] groups, ServerLocation location) {
        for (String group : groups) {
            Map<ServerLocation, LoadHolder> groupMap = map.get(group);
            if (groupMap == null) continue;
            groupMap.remove(location);
            if (groupMap.size() != 0) continue;
            map.remove(group);
        }
        Map<ServerLocation, LoadHolder> groupMap = map.get(null);
        groupMap.remove(location);
    }

    @VisibleForTesting
    void removeFromMap(Map<String, Map<ServerLocationAndMemberId, LoadHolder>> map, String[] groups, ServerLocation location, String memberId) {
        ServerLocationAndMemberId locationAndMemberId = new ServerLocationAndMemberId(location, memberId);
        for (String group : groups) {
            Map<ServerLocationAndMemberId, LoadHolder> groupMap = map.get(group);
            if (groupMap == null) continue;
            groupMap.remove(locationAndMemberId);
            if (groupMap.size() != 0) continue;
            map.remove(group);
        }
        Map<ServerLocationAndMemberId, LoadHolder> groupMap = map.get(null);
        groupMap.remove(locationAndMemberId);
    }

    @VisibleForTesting
    void updateMap(Map map, ServerLocation location, float load, float loadPerConnection) {
        this.updateMap(map, location, "", load, loadPerConnection);
    }

    @VisibleForTesting
    void updateMap(Map map, ServerLocation location, String memberId, float load, float loadPerConnection) {
        LoadHolder holder;
        Map groupMap = (Map)map.get(null);
        if (memberId.equals("")) {
            holder = (LoadHolder)groupMap.get(location);
        } else {
            ServerLocationAndMemberId locationAndMemberId = new ServerLocationAndMemberId(location, memberId);
            holder = (LoadHolder)groupMap.get(locationAndMemberId);
        }
        if (holder != null) {
            holder.setLoad(load, loadPerConnection);
        }
    }

    @VisibleForTesting
    List<LoadHolder> findBestServers(Map<?, LoadHolder> groupServers, Set<ServerLocation> excludedServers, int count) {
        if (count == 0) {
            return new ArrayList<LoadHolder>();
        }
        TreeSet<LoadHolder> bestEntries = new TreeSet<LoadHolder>((l1, l2) -> {
            int difference = Float.compare(l1.getLoad(), l2.getLoad());
            if (difference != 0) {
                return difference;
            }
            ServerLocation sl1 = l1.getLocation();
            ServerLocation sl2 = l2.getLocation();
            return sl1.compareTo(sl2);
        });
        boolean retainAll = count < 0;
        float lastBestLoad = Float.MAX_VALUE;
        for (Map.Entry<?, LoadHolder> loadEntry : groupServers.entrySet()) {
            ServerLocation location;
            Object key = loadEntry.getKey();
            if (key instanceof ServerLocationAndMemberId) {
                location = ((ServerLocationAndMemberId)key).getServerLocation();
            } else if (key instanceof ServerLocation) {
                location = (ServerLocation)key;
            } else {
                throw new InternalGemFireException("findBestServers method was called with incorrect type parameters.");
            }
            if (excludedServers.contains(location)) continue;
            LoadHolder nextLoadReference = loadEntry.getValue();
            float nextLoad = nextLoadReference.getLoad();
            if (bestEntries.size() >= count && !retainAll && !(nextLoad < lastBestLoad)) continue;
            bestEntries.add(nextLoadReference);
            if (!retainAll && bestEntries.size() > count) {
                bestEntries.remove(bestEntries.last());
            }
            LoadHolder lastBestHolder = (LoadHolder)bestEntries.last();
            lastBestLoad = lastBestHolder.getLoad();
        }
        return new ArrayList<LoadHolder>(bestEntries);
    }

    @VisibleForTesting
    LoadHolder isCurrentServerMostLoaded(ServerLocation currentServer, Map<ServerLocationAndMemberId, LoadHolder> groupServers) {
        LoadHolder currentLH = null;
        for (ServerLocationAndMemberId locationAndMemberId : groupServers.keySet()) {
            if (!currentServer.equals(locationAndMemberId.getServerLocation())) continue;
            currentLH = groupServers.get(locationAndMemberId);
            break;
        }
        if (currentLH == null) {
            return null;
        }
        float currentLoad = currentLH.getLoad();
        for (Map.Entry<ServerLocationAndMemberId, LoadHolder> loadEntry : groupServers.entrySet()) {
            LoadHolder nextLoadReference;
            float nextLoad;
            ServerLocation location = loadEntry.getKey().getServerLocation();
            if (location.equals(currentServer) || !((nextLoad = (nextLoadReference = loadEntry.getValue()).getLoad()) > currentLoad)) continue;
            return null;
        }
        return currentLH;
    }

    private void cancelClientEstimate(ClientProxyMembershipID id, ServerLocation location) {
        if (id != null) {
            this.removeAndCancelEstimate(new EstimateMapKey(id.getIdentity(), location));
        }
    }

    private void addEstimate(EstimateMapKey key, LoadEstimateTask task) {
        LoadEstimateTask oldTask = this.estimateMap.put(key, task);
        if (oldTask != null) {
            oldTask.cancel();
        }
    }

    private boolean removeIfPresentEstimate(EstimateMapKey key, LoadEstimateTask task) {
        return this.estimateMap.remove(key, task);
    }

    private void removeAndCancelEstimate(EstimateMapKey key) {
        LoadEstimateTask oldTask = (LoadEstimateTask)this.estimateMap.remove(key);
        if (oldTask != null) {
            oldTask.cancel();
        }
    }

    @VisibleForTesting
    static class LoadHolder {
        private float load;
        private float loadPerConnection;
        private int estimateCount;
        private final ServerLocation location;
        private final long loadPollInterval;

        LoadHolder(ServerLocation location, float load, float loadPerConnection, long loadPollInterval) {
            this.location = location;
            this.load = load;
            this.loadPerConnection = loadPerConnection;
            this.loadPollInterval = loadPollInterval;
        }

        void setLoad(float load, float loadPerConnection) {
            this.loadPerConnection = loadPerConnection;
            this.load = load + (float)this.estimateCount * loadPerConnection;
        }

        void incConnections() {
            this.load += this.loadPerConnection;
        }

        void addEstimate() {
            ++this.estimateCount;
            this.incConnections();
        }

        void removeEstimate() {
            --this.estimateCount;
            this.decConnections();
        }

        void decConnections() {
            this.load -= this.loadPerConnection;
        }

        public float getLoad() {
            return this.load;
        }

        public float getLoadPerConnection() {
            return this.loadPerConnection;
        }

        public ServerLocation getLocation() {
            return this.location;
        }

        public long getLoadPollInterval() {
            return this.loadPollInterval;
        }

        public String toString() {
            return "LoadHolder[" + this.getLoad() + ", " + this.getLocation() + ", loadPollInterval=" + this.getLoadPollInterval() + (this.estimateCount != 0 ? ", estimates=" + this.estimateCount : "") + ", " + this.loadPerConnection + "]";
        }
    }

    private class LoadEstimateTask
    implements Runnable {
        private final EstimateMapKey key;
        private final LoadHolder lh;
        private ScheduledFuture future;

        LoadEstimateTask(EstimateMapKey key, LoadHolder lh) {
            this.key = key;
            this.lh = lh;
            lh.addEstimate();
        }

        @Override
        public void run() {
            if (LocatorLoadSnapshot.this.removeIfPresentEstimate(this.key, this)) {
                this.decEstimate();
            }
        }

        public void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        public void cancel() {
            this.future.cancel(false);
            this.decEstimate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decEstimate() {
            LocatorLoadSnapshot locatorLoadSnapshot = LocatorLoadSnapshot.this;
            synchronized (locatorLoadSnapshot) {
                this.lh.removeEstimate();
            }
        }
    }

    private static class EstimateMapKey {
        private final ClientProxyMembershipID.Identity clientId;
        private final ServerLocation serverId;

        EstimateMapKey(ClientProxyMembershipID.Identity clientId, ServerLocation serverId) {
            this.clientId = clientId;
            this.serverId = serverId;
        }

        public int hashCode() {
            return this.clientId.hashCode() ^ this.serverId.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EstimateMapKey)) {
                return false;
            }
            EstimateMapKey that = (EstimateMapKey)obj;
            return this.clientId.equals(that.clientId) && this.serverId.equals(that.serverId);
        }
    }
}

