/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.math.BigDecimal;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.RedisCommandType;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisCommandsFunctionInvoker;
import org.apache.geode.redis.internal.executor.string.RedisStringCommands;
import org.apache.geode.redis.internal.executor.string.SetOptions;

public class RedisStringCommandsFunctionInvoker
extends RedisCommandsFunctionInvoker
implements RedisStringCommands {
    public RedisStringCommandsFunctionInvoker(Region<RedisKey, RedisData> region) {
        super(region);
    }

    @Override
    public long append(RedisKey key, ByteArrayWrapper valueToAppend) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.APPEND, valueToAppend});
    }

    @Override
    public ByteArrayWrapper get(RedisKey key) {
        return (ByteArrayWrapper)this.invokeCommandFunction(key, new Object[]{RedisCommandType.GET});
    }

    @Override
    public boolean set(RedisKey key, ByteArrayWrapper value, SetOptions options) {
        return (Boolean)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SET, value, options});
    }

    @Override
    public long incr(RedisKey key) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.INCR});
    }

    @Override
    public long decr(RedisKey key) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.DECR});
    }

    @Override
    public ByteArrayWrapper getset(RedisKey key, ByteArrayWrapper value) {
        return (ByteArrayWrapper)this.invokeCommandFunction(key, new Object[]{RedisCommandType.GETSET, value});
    }

    @Override
    public long incrby(RedisKey key, long increment) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.INCRBY, increment});
    }

    @Override
    public long decrby(RedisKey key, long decrement) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.DECRBY, decrement});
    }

    @Override
    public ByteArrayWrapper getrange(RedisKey key, long start, long end) {
        return (ByteArrayWrapper)this.invokeCommandFunction(key, new Object[]{RedisCommandType.GETRANGE, start, end});
    }

    @Override
    public long bitcount(RedisKey key, int start, int end) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.BITCOUNT, start, end});
    }

    @Override
    public long bitcount(RedisKey key) {
        return (Long)this.invokeCommandFunction(key, new Object[]{RedisCommandType.BITCOUNT});
    }

    @Override
    public int strlen(RedisKey key) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.STRLEN});
    }

    @Override
    public int getbit(RedisKey key, int offset) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.GETBIT, offset});
    }

    @Override
    public int setbit(RedisKey key, long offset, int value) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SETBIT, offset, value});
    }

    @Override
    public BigDecimal incrbyfloat(RedisKey key, BigDecimal increment) {
        return (BigDecimal)this.invokeCommandFunction(key, new Object[]{RedisCommandType.INCRBYFLOAT, increment});
    }

    @Override
    public int bitop(String operation, RedisKey destKey, List<RedisKey> sources) {
        return (Integer)this.invokeCommandFunction(destKey, new Object[]{RedisCommandType.BITOP, operation, sources});
    }

    @Override
    public int bitpos(RedisKey key, int bit, int start, Integer end) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.BITPOS, bit, start, end});
    }

    @Override
    public int setrange(RedisKey key, int offset, byte[] value) {
        return (Integer)this.invokeCommandFunction(key, new Object[]{RedisCommandType.SETRANGE, offset, value});
    }

    @Override
    public ByteArrayWrapper mget(RedisKey key) {
        return (ByteArrayWrapper)this.invokeCommandFunction(key, new Object[]{RedisCommandType.MGET});
    }
}

