/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;
import org.apache.geode.redis.internal.executor.hash.RedisHashCommands;
import org.apache.geode.redis.internal.netty.Coder;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class HIncrByExecutor
extends HashExecutor {
    private static final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be numeric";
    private static final int INCREMENT_INDEX = 3;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        long increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        RedisKey key = command.getKey();
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        byte[] incrArray = commandElems.get(3);
        try {
            increment = Coder.bytesToLong(incrArray);
        }
        catch (NumberFormatException e) {
            return RedisResponse.error(ERROR_INCREMENT_NOT_USABLE);
        }
        RedisHashCommands redisHashCommands = this.createRedisHashCommands(context);
        long value = redisHashCommands.hincrby(key, field, increment);
        return RedisResponse.integer(value);
    }
}

