/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.connectors.jdbc.internal.cli.RegisterDriverFunction;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.SingleGfshCommand;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class RegisterDriverCommand
extends SingleGfshCommand {
    static final String REGISTER_DRIVER = "register driver";
    static final String REGISTER_DRIVER__HELP = "(Experimental) Register a driver with the cluster's Driver Manager using the name of a driver class contained within a currenly deployed jar.";
    static final String DRIVER_CLASS_NAME = "driver-class";
    static final String DRIVER_CLASS_NAME_HELP = "The name of the driver class contained in a currently deployed jar to be registered with the cluster's Driver Manager.";

    @CliCommand(value={"register driver"}, help="(Experimental) Register a driver with the cluster's Driver Manager using the name of a driver class contained within a currenly deployed jar.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public ResultModel registerDriver(@CliOption(key={"driver-class"}, help="The name of the driver class contained in a currently deployed jar to be registered with the cluster's Driver Manager.", mandatory=true) String driverClassName) {
        try {
            Set targetMembers = this.findMembers(null, null);
            if (targetMembers.size() > 0) {
                Object[] arguments = new Object[]{driverClassName};
                List registerDriverResults = this.executeAndGetFunctionResult((Function)new RegisterDriverFunction(), arguments, targetMembers);
                return ResultModel.createMemberStatusResult((List)registerDriverResults, (String)"(Experimental) ", null, (boolean)false, (boolean)true);
            }
            return ResultModel.createInfo((String)"(Experimental) \nNo members found");
        }
        catch (Exception ex) {
            return ResultModel.createError((String)("Failed to register driver \"" + driverClassName + "\": " + ex.getMessage()));
        }
    }
}

