/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring.executor;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractExecutor {
    private static final int THREAD_DUMP_DEPTH = 40;
    private static final Logger logger = LogService.getLogger();
    public static final String LOCK_OWNER_THREAD_STACK = "Lock owner thread stack";
    private long threadID;
    private String groupName;
    private short numIterationsStuck = 0;
    private long startTime = System.currentTimeMillis();

    public AbstractExecutor(ThreadsMonitoring tMonitoring) {
        this.threadID = Thread.currentThread().getId();
    }

    public AbstractExecutor(ThreadsMonitoring tMonitoring, long threadID) {
        this.threadID = threadID;
    }

    public void handleExpiry(long stuckTime) {
        this.incNumIterationsStuck();
        logger.warn(this.createThreadReport(stuckTime));
    }

    String createThreadReport(long stuckTime) {
        ThreadInfo lockOwnerThread;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss zzz");
        ThreadInfo thread = ManagementFactory.getThreadMXBean().getThreadInfo(this.threadID, 40);
        boolean logThreadDetails = thread != null;
        StringBuilder stringBuilder = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        stringBuilder.append("Thread <").append(this.threadID).append("> (0x").append(Long.toHexString(this.threadID)).append(") that was executed at <").append(dateFormat.format(this.getStartTime())).append("> has been stuck for <").append((float)stuckTime / 1000.0f).append(" seconds> and number of thread monitor iteration <").append(this.numIterationsStuck).append("> ").append(lineSeparator);
        if (logThreadDetails) {
            stringBuilder.append("Thread Name <").append(thread.getThreadName()).append(">").append(" state <").append((Object)thread.getThreadState()).append(">").append(lineSeparator);
            if (thread.getLockName() != null) {
                stringBuilder.append("Waiting on <").append(thread.getLockName()).append(">").append(lineSeparator);
            }
            if (thread.getLockOwnerName() != null) {
                stringBuilder.append("Owned By <").append(thread.getLockOwnerName()).append("> with ID <").append(thread.getLockOwnerId()).append(">").append(lineSeparator);
            }
        }
        stringBuilder.append("Executor Group <").append(this.groupName).append(">").append(lineSeparator).append("Monitored metric <ResourceManagerStats.numThreadsStuck>").append(lineSeparator);
        if (logThreadDetails) {
            this.writeThreadStack(thread, "Thread stack:", stringBuilder);
        }
        if (logThreadDetails && thread.getLockOwnerName() != null && (lockOwnerThread = ManagementFactory.getThreadMXBean().getThreadInfo(thread.getLockOwnerId(), 40)) != null) {
            this.writeThreadStack(lockOwnerThread, LOCK_OWNER_THREAD_STACK, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void writeThreadStack(ThreadInfo thread, String header, StringBuilder strb) {
        String lineSeparator = System.lineSeparator();
        strb.append(header).append(lineSeparator);
        for (int i = 0; i < thread.getStackTrace().length; ++i) {
            String row = thread.getStackTrace()[i].toString();
            strb.append(row).append(lineSeparator);
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long newTime) {
        this.startTime = newTime;
    }

    public short getNumIterationsStuck() {
        return this.numIterationsStuck;
    }

    public void incNumIterationsStuck() {
        this.numIterationsStuck = (short)(this.numIterationsStuck + 1);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public long getThreadID() {
        return this.threadID;
    }
}

