/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class SetEXExecutor
extends StringExecutor
implements Extendable {
    private final String ERROR_SECONDS_NOT_A_NUMBER = "The expiration argument provided was not a number";
    private final String ERROR_SECONDS_NOT_LEGAL = "The expiration argument must be greater than 0";
    private final String SUCCESS = "OK";
    private final int VALUE_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long expiration;
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        byte[] value = commandElems.get(3);
        byte[] expirationArray = commandElems.get(2);
        try {
            expiration = Coder.bytesToLong(expirationArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The expiration argument provided was not a number"));
            return;
        }
        if (expiration <= 0L) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The expiration argument must be greater than 0"));
            return;
        }
        if (!this.timeUnitMillis()) {
            expiration *= 1000L;
        }
        this.checkAndSetDataType(key, context);
        r.put((Object)key, (Object)new ByteArrayWrapper(value));
        context.getRegionProvider().setExpiration(key, expiration);
        command.setResponse(Coder.getSimpleStringResponse(context.getByteBufAllocator(), "OK"));
    }

    protected boolean timeUnitMillis() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the SETEX command is \"SETEX key seconds value\"";
    }
}

