/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public abstract class PushXExecutor
extends ListExecutor
implements Extendable {
    private static final int NOT_EXISTS = 0;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        Region<Object, Object> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        this.pushElements(key, commandElems, 2, 3, keyRegion, this.pushType(), context);
        int listSize = keyRegion.size() - 2;
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), listSize));
    }

    protected abstract ListExecutor.ListDirection pushType();
}

