/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import java.util.Map;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HExistsExecutor
extends HashExecutor {
    private static final int NOT_EXISTS = 0;
    private static final int EXISTS = 1;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        boolean hasField;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HEXISTS command is \"HEXISTS key field\""));
            return;
        }
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        ByteArrayWrapper key = command.getKey();
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            Map<ByteArrayWrapper, ByteArrayWrapper> map = this.getMap(context, key);
            if (map == null || map.isEmpty()) {
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
                return;
            }
            hasField = map.containsKey(field);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        if (hasField) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 1));
        } else {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
        }
    }
}

