/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geode.annotations.Immutable;

@Immutable
public class InterestPolicy
implements Serializable {
    private static final long serialVersionUID = 1567179436331385968L;
    @Immutable
    private static final InterestPolicy[] VALUES = new InterestPolicy[2];
    @Immutable
    public static final InterestPolicy ALL = new InterestPolicy("ALL", 0);
    @Immutable
    public static final InterestPolicy CACHE_CONTENT;
    @Immutable
    public static final InterestPolicy DEFAULT;
    private final transient String name;
    public final byte ordinal;

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private InterestPolicy(String name, int ordinal) {
        this.name = name;
        this.ordinal = (byte)ordinal;
        InterestPolicy.VALUES[this.ordinal] = this;
    }

    public static InterestPolicy fromOrdinal(byte ordinal) {
        return VALUES[ordinal];
    }

    public boolean isAll() {
        return this == ALL;
    }

    public boolean isCacheContent() {
        return this == CACHE_CONTENT;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public String toString() {
        return this.name;
    }

    static {
        DEFAULT = CACHE_CONTENT = new InterestPolicy("CACHE_CONTENT", 1);
    }
}

