/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class BitCountExecutor
extends StringExecutor {
    private final String ERROR_NOT_INT = "The indexes provided must be numeric values";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() != 2 && commandElems.size() != 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the BITCOUNT command is \"BITCOUNT key [start end]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkAndSetDataType(key, context);
        ByteArrayWrapper wrapper = (ByteArrayWrapper)r.get((Object)key);
        if (wrapper == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        byte[] value = wrapper.toBytes();
        long startL = 0L;
        long endL = value.length - 1;
        if (commandElems.size() == 4) {
            try {
                startL = Coder.bytesToLong(commandElems.get(2));
                endL = Coder.bytesToLong(commandElems.get(3));
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The indexes provided must be numeric values"));
                return;
            }
        }
        if (startL > Integer.MAX_VALUE || endL > Integer.MAX_VALUE) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The number provided is out of range"));
            return;
        }
        int start = (int)startL;
        int end = (int)endL;
        if (start < 0) {
            start += value.length;
        }
        if (end < 0) {
            end += value.length;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > value.length - 1) {
            end = value.length - 1;
        }
        if (end < start || start >= value.length) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        long setBits = 0L;
        for (int j = start; j <= end; ++j) {
            setBits += (long)Integer.bitCount(0xFF & value[j]);
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), setBits));
    }
}

