/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisLockService;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public abstract class HashExecutor
extends AbstractExecutor {
    protected final int FIELD_INDEX = 2;

    protected Map<ByteArrayWrapper, ByteArrayWrapper> getMap(ExecutionHandlerContext context, ByteArrayWrapper key) {
        Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>> region = context.getRegionProvider().getHashRegion();
        HashMap map = (HashMap)region.get((Object)key);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    protected AutoCloseableLock withRegionLock(ExecutionHandlerContext context, ByteArrayWrapper key) throws InterruptedException, TimeoutException {
        RedisLockService lockService = context.getLockService();
        return lockService.lock(key);
    }

    protected void saveMap(Map<ByteArrayWrapper, ByteArrayWrapper> map, ExecutionHandlerContext context, ByteArrayWrapper key) {
        if (map == null) {
            return;
        }
        RegionProvider rp = context.getRegionProvider();
        rp.getHashRegion().put((Object)key, map);
        context.getKeyRegistrar().register(key, RedisDataType.REDIS_HASH);
    }
}

