/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.KeyHashIdentifier;
import org.apache.geode.redis.internal.RedisLockServiceMBean;

public class RedisLockService
implements RedisLockServiceMBean {
    private static final int DEFAULT_TIMEOUT = 1000;
    private final int timeoutMS;
    private final Map<KeyHashIdentifier, Lock> weakReferencesTolocks = Collections.synchronizedMap(new WeakHashMap());

    public RedisLockService() {
        this(1000);
    }

    public RedisLockService(int timeoutMS) {
        this.timeoutMS = timeoutMS;
    }

    @Override
    public int getLockCount() {
        return this.weakReferencesTolocks.size();
    }

    public AutoCloseableLock lock(ByteArrayWrapper key) throws InterruptedException {
        KeyHashIdentifier lockKey;
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        KeyHashIdentifier referencedKey = lockKey = new KeyHashIdentifier(key.toBytes());
        Lock lock = new ReentrantLock();
        do {
            Lock oldLock;
            if ((oldLock = this.weakReferencesTolocks.putIfAbsent(lockKey, lock)) == null) continue;
            lock = oldLock;
            referencedKey = this.getReferenceToLockKey(lockKey);
        } while (referencedKey == null);
        if (!lock.tryLock(this.timeoutMS, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Couldn't get lock for " + lockKey.toString());
        }
        return new AutoCloseableLock(referencedKey, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyHashIdentifier getReferenceToLockKey(KeyHashIdentifier lockKey) {
        Map<KeyHashIdentifier, Lock> map = this.weakReferencesTolocks;
        synchronized (map) {
            for (KeyHashIdentifier keyInSet : this.weakReferencesTolocks.keySet()) {
                if (!keyInSet.equals(lockKey)) continue;
                return keyInSet;
            }
        }
        return null;
    }
}

