/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.JsonPdxConverter;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.SerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.internal.protocol.protobuf.v1.utilities.exception.UnknownProtobufEncodingType;
import org.apache.geode.internal.protocol.serialization.NoOpCustomValueSerializer;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.protocol.serialization.ValueSerializer;

@Experimental
public class ProtobufSerializationService
implements SerializationService<BasicTypes.EncodedValue> {
    private final JsonPdxConverter jsonPdxConverter = new JsonPdxConverter();
    private final ValueSerializer serializer;

    public ProtobufSerializationService() {
        this(new NoOpCustomValueSerializer());
    }

    public ProtobufSerializationService(ValueSerializer valueSerializer) {
        this.serializer = valueSerializer;
    }

    @Override
    public BasicTypes.EncodedValue encode(Object value) throws EncodingException {
        BasicTypes.EncodedValue.Builder builder = BasicTypes.EncodedValue.newBuilder();
        try {
            if (this.serializer.supportsPrimitives()) {
                ByteString encoded = this.serializer.serialize(value);
                return builder.setCustomObjectResult(encoded).build();
            }
            if (value == null) {
                return builder.setNullResult(NullValue.NULL_VALUE).build();
            }
            ProtobufEncodingTypes protobufEncodingTypes = ProtobufEncodingTypes.valueOf(value.getClass());
            switch (protobufEncodingTypes) {
                case INT: {
                    builder.setIntResult((Integer)value);
                    break;
                }
                case LONG: {
                    builder.setLongResult((Long)value);
                    break;
                }
                case SHORT: {
                    builder.setShortResult(((Short)value).shortValue());
                    break;
                }
                case BYTE: {
                    builder.setByteResult(((Byte)value).byteValue());
                    break;
                }
                case DOUBLE: {
                    builder.setDoubleResult((Double)value);
                    break;
                }
                case FLOAT: {
                    builder.setFloatResult(((Float)value).floatValue());
                    break;
                }
                case BINARY: {
                    builder.setBinaryResult(ByteString.copyFrom((byte[])value));
                    break;
                }
                case BOOLEAN: {
                    builder.setBooleanResult((Boolean)value);
                    break;
                }
                case STRING: {
                    builder.setStringResult((String)value);
                    break;
                }
                default: {
                    ByteString customResult = this.customSerialize(value);
                    if (customResult != null) {
                        builder.setCustomObjectResult(customResult);
                        break;
                    }
                    if (value instanceof PdxInstance) {
                        builder.setJsonObjectResult(this.jsonPdxConverter.encode((PdxInstance)value));
                        break;
                    }
                    throw new EncodingException("No handler for object type " + value.getClass());
                }
            }
        }
        catch (UnknownProtobufEncodingType e) {
            throw new EncodingException("No protobuf encoding for type " + value.getClass().getName(), e);
        }
        catch (IOException e) {
            throw new EncodingException("Error encoding type " + value.getClass().getName(), e);
        }
        return builder.build();
    }

    private ByteString customSerialize(Object value) throws IOException {
        return this.serializer instanceof NoOpCustomValueSerializer ? null : this.serializer.serialize(value);
    }

    @Override
    public Object decode(BasicTypes.EncodedValue encodedValue) throws DecodingException {
        try {
            switch (encodedValue.getValueCase()) {
                case BINARYRESULT: {
                    return encodedValue.getBinaryResult().toByteArray();
                }
                case BOOLEANRESULT: {
                    return encodedValue.getBooleanResult();
                }
                case BYTERESULT: {
                    return (byte)encodedValue.getByteResult();
                }
                case DOUBLERESULT: {
                    return encodedValue.getDoubleResult();
                }
                case FLOATRESULT: {
                    return Float.valueOf(encodedValue.getFloatResult());
                }
                case INTRESULT: {
                    return encodedValue.getIntResult();
                }
                case LONGRESULT: {
                    return encodedValue.getLongResult();
                }
                case SHORTRESULT: {
                    return (short)encodedValue.getShortResult();
                }
                case STRINGRESULT: {
                    return encodedValue.getStringResult();
                }
                case JSONOBJECTRESULT: {
                    return this.jsonPdxConverter.decode(encodedValue.getJsonObjectResult());
                }
                case NULLRESULT: {
                    return null;
                }
                case CUSTOMOBJECTRESULT: {
                    return this.serializer.deserialize(encodedValue.getCustomObjectResult());
                }
            }
            throw new DecodingException("Unknown Protobuf encoding type: " + encodedValue.getValueCase());
        }
        catch (IOException | ClassNotFoundException e) {
            throw new DecodingException("Error decoding value", e);
        }
    }

    public Collection<Object> decodeList(Collection<BasicTypes.EncodedValue> encodedValues) {
        return encodedValues.stream().map(this::decode).collect(Collectors.toList());
    }

    private static enum ProtobufEncodingTypes {
        STRING(String.class),
        INT(Integer.class),
        LONG(Long.class),
        SHORT(Short.class),
        BYTE(Byte.class),
        BOOLEAN(Boolean.class),
        DOUBLE(Double.class),
        FLOAT(Float.class),
        BINARY(byte[].class),
        OTHER(Object.class);

        private Class clazz;
        private static Map<Class, ProtobufEncodingTypes> classToType;

        private ProtobufEncodingTypes(Class clazz) {
            this.clazz = clazz;
        }

        public static ProtobufEncodingTypes valueOf(Class unencodedValueClass) throws UnknownProtobufEncodingType {
            ProtobufEncodingTypes type = classToType.get(unencodedValueClass);
            if (type != null) {
                return type;
            }
            return OTHER;
        }

        static {
            classToType = new HashMap<Class, ProtobufEncodingTypes>();
            for (ProtobufEncodingTypes type : ProtobufEncodingTypes.values()) {
                classToType.put(type.clazz, type);
            }
        }
    }
}

