/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.logging.internal.log4j.LogLevel;
import org.apache.geode.management.internal.cli.GfshParser;

public class ReadWriteFile {
    public static void main(String[] args) {
        if (args.length != 6) {
            throw new IllegalArgumentException("Requires only 6  arguments : <logInputFileName> <logOutputFileName> <LogLevel> <UptoLogLevel> <StartTime> <EndTime>");
        }
        String result = ReadWriteFile.readWriteFile(args[0], args[1], args[2], args[3], args[4], args[5]);
        System.out.println(result);
    }

    public static String readWriteFile(String logFileName, String logToBeWritten, String logLevel, String onlyLogLevel, String startTime, String endTime) {
        try {
            String line;
            long lineCount = 0L;
            File logFileNameFile = new File(logFileName);
            if (!logFileNameFile.canRead()) {
                return "Cannot read logFileName=" + logFileName;
            }
            BufferedReader input = new BufferedReader(new FileReader(logFileName));
            File logToBeWrittenToFile = new File(logToBeWritten);
            BufferedWriter output = new BufferedWriter(new FileWriter(logToBeWrittenToFile));
            if (!logToBeWrittenToFile.exists()) {
                input.close();
                output.flush();
                output.close();
                return logToBeWritten + " does not exist";
            }
            if (!logToBeWrittenToFile.isFile()) {
                input.close();
                output.flush();
                output.close();
                return logToBeWritten + " is not a file";
            }
            if (!logToBeWrittenToFile.canWrite()) {
                input.close();
                output.flush();
                output.close();
                return "can not write file " + logToBeWritten;
            }
            List<String> logLevels = ReadWriteFile.getLogLevels(logLevel, onlyLogLevel);
            boolean timeRangeCheck = false;
            boolean validateLogLevel = true;
            while (input.ready() && (line = input.readLine()) != null) {
                if (!new File(logFileName).canRead()) {
                    return "Cannot read logFileName=" + logFileName;
                }
                ++lineCount;
                boolean foundLogLevelTag = line.startsWith("[");
                if (line.contains("[info ") && !timeRangeCheck) {
                    StringBuilder stTime = new StringBuilder();
                    int spaceCounter = 0;
                    for (int i = line.indexOf("[info ") + 6; i < line.length(); ++i) {
                        if (line.charAt(i) == ' ') {
                            ++spaceCounter;
                        }
                        if (spaceCounter > 2) break;
                        stTime.append(line.charAt(i));
                    }
                    SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    Date d = df.parse(stTime.substring(0, stTime.length() - 4));
                    Time fileStartTime = new Time(d.getTime());
                    File inputFile = new File(logFileName);
                    Time fileEndTime = new Time(inputFile.lastModified());
                    Time longStart = new Time(Long.parseLong(startTime));
                    Time longEnd = new Time(Long.parseLong(endTime));
                    long userStartTime = longStart.getTime();
                    long userEndTime = longEnd.getTime();
                    if ((fileStartTime.getTime() < userStartTime || fileStartTime.getTime() > userEndTime) && (fileEndTime.getTime() < userStartTime || fileEndTime.getTime() > userEndTime)) break;
                    timeRangeCheck = true;
                }
                if (foundLogLevelTag) {
                    validateLogLevel = ReadWriteFile.checkLogLevel(line, logLevel, logLevels);
                }
                if (!validateLogLevel) continue;
                output.append(line);
                output.newLine();
                if (lineCount % 1000L != 0L) continue;
                output.flush();
            }
            input.close();
            output.flush();
            output.close();
            return "Successfully written file " + logFileName;
        }
        catch (FunctionException ex) {
            return "readWriteFile FunctionException " + ex.getMessage();
        }
        catch (IOException ex) {
            return "readWriteFile FileNotFoundException " + ex.getMessage();
        }
        catch (Exception ex) {
            return "readWriteFile Exception " + ex.getMessage();
        }
    }

    private static List<String> getLogLevels(String logLevel, String onlyLogLevel) {
        ArrayList<String> logLevels = new ArrayList<String>();
        if (onlyLogLevel.toLowerCase().equals("false")) {
            Iterator iterator = LogWriterImpl.allLevels.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                if (level < LogLevel.getLogWriterLevel((String)logLevel)) continue;
                logLevels.add(LogWriterImpl.levelToString((int)level).toLowerCase());
            }
        } else {
            logLevels.add(logLevel);
        }
        return logLevels;
    }

    static boolean checkLogLevel(String line, String logLevel, List<String> logLevels) {
        if (line == null) {
            return false;
        }
        if (logLevel.toLowerCase().equals("all")) {
            return true;
        }
        if (line.equals(GfshParser.LINE_SEPARATOR)) {
            return true;
        }
        if (logLevels.size() > 0) {
            for (String permittedLogLevel : logLevels) {
                boolean flag;
                int indexFrom = line.indexOf(91);
                int indexTo = line.indexOf(32);
                if (indexFrom <= -1 || indexTo <= -1 || indexTo <= indexFrom || !(flag = line.substring(indexFrom + 1, indexTo).toLowerCase().contains(permittedLogLevel))) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

