/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.Context;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class ListJndiBindingFunction
extends CliFunction<Void> {
    private static final long serialVersionUID = 5254506785395069200L;

    @Override
    public CliFunctionResult executeFunction(FunctionContext<Void> context) {
        CliFunctionResult result;
        try {
            Context ctx = JNDIInvoker.getJNDIContext();
            Map bindings = JNDIInvoker.getBindingNamesRecursively((Context)ctx);
            List<String> resultValues = bindings.entrySet().stream().flatMap(e -> Arrays.stream(new String[]{(String)e.getKey(), (String)e.getValue()})).collect(Collectors.toList());
            result = this.createCliFunctionResult(context, resultValues);
        }
        catch (Exception e2) {
            result = new CliFunctionResult(context.getMemberName(), (Object)e2, "Unable to retrieve JNDI bindings");
        }
        return result;
    }

    private CliFunctionResult createCliFunctionResult(FunctionContext<Void> context, List<String> resultValues) {
        return new CliFunctionResult(context.getMemberName(), resultValues.toArray(new Serializable[0]));
    }
}

