/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import com.github.davidmoten.geo.LatLong;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.CoderException;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.GeoCoder;
import org.apache.geode.redis.internal.GeoRadiusResponseElement;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.SortedSetQuery;

public abstract class GeoSortedSetExecutor
extends AbstractExecutor {
    protected Region<ByteArrayWrapper, ByteArrayWrapper> getOrCreateRegion(ExecutionHandlerContext context, ByteArrayWrapper key, RedisDataType type) {
        Region<?, ?> r = context.getRegionProvider().getOrCreateRegion(key, type, context);
        return r;
    }

    protected Region<ByteArrayWrapper, ByteArrayWrapper> getRegion(ExecutionHandlerContext context, ByteArrayWrapper key) {
        Region<?, ?> r = context.getRegionProvider().getRegion(key);
        return r;
    }

    protected List<StructImpl> getGeoRadiusRange(ExecutionHandlerContext context, ByteArrayWrapper key, String hash) throws Exception {
        Query query = this.getQuery(key, SortedSetQuery.GEORADIUS, context);
        Object[] params = new Object[]{hash + "%"};
        SelectResults results = (SelectResults)query.execute(params);
        return results.asList();
    }

    protected void respondGeoRadius(Command command, ExecutionHandlerContext context, List<GeoRadiusResponseElement> results) {
        ByteBuf rsp;
        try {
            rsp = GeoCoder.geoRadiusResponse(context.getByteBufAllocator(), results);
        }
        catch (CoderException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The server had an internal error please try again"));
            return;
        }
        command.setResponse(rsp);
    }

    protected void respondGeoCoordinates(Command command, ExecutionHandlerContext context, List<LatLong> positions) {
        ByteBuf rsp;
        try {
            rsp = GeoCoder.getBulkStringGeoCoordinateArrayResponse(context.getByteBufAllocator(), positions);
        }
        catch (CoderException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The server had an internal error please try again"));
            return;
        }
        command.setResponse(rsp);
    }
}

