/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractScanExecutor;
import org.apache.geode.redis.internal.executor.set.DeltaSet;

public class SScanExecutor
extends AbstractScanExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        String tmp;
        byte[] bytes;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the SSCAN command is \"SSCAN key cursor [MATCH pattern] [COUNT count]\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SET, context);
        Region<ByteArrayWrapper, DeltaSet> region = this.getRegion(context);
        Set<ByteArrayWrapper> set = DeltaSet.members(region, key);
        if (set == null) {
            command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), new ArrayList()));
            return;
        }
        byte[] cAr = commandElems.get(2);
        String cursorString = Coder.bytesToString(cAr);
        int cursor = 0;
        Pattern matchPattern = null;
        String globMatchPattern = null;
        int count = 10;
        try {
            cursor = Integer.parseInt(cursorString);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (cursor < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Invalid cursor"));
            return;
        }
        if (commandElems.size() > 4) {
            try {
                bytes = commandElems.get(3);
                tmp = Coder.bytesToString(bytes);
                if (tmp.equalsIgnoreCase("MATCH")) {
                    bytes = commandElems.get(4);
                    globMatchPattern = Coder.bytesToString(bytes);
                } else if (tmp.equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(4);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (commandElems.size() > 6) {
            try {
                bytes = commandElems.get(5);
                tmp = Coder.bytesToString(bytes);
                if (tmp.equalsIgnoreCase("COUNT")) {
                    bytes = commandElems.get(6);
                    count = Coder.bytesToInt(bytes);
                }
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
                return;
            }
        }
        if (count < 0) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Count must be numeric and positive"));
            return;
        }
        try {
            matchPattern = this.convertGlobToRegex(globMatchPattern);
        }
        catch (PatternSyntaxException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Incorrect syntax for given glob regex"));
            return;
        }
        List<?> returnList = this.getIteration(new ArrayList<ByteArrayWrapper>(set), matchPattern, count, cursor);
        command.setResponse(Coder.getScanResponse(context.getByteBufAllocator(), returnList));
    }

    private Region<ByteArrayWrapper, DeltaSet> getRegion(ExecutionHandlerContext context) {
        return context.getRegionProvider().getSetRegion();
    }

    @Override
    protected List<?> getIteration(Collection<?> list, Pattern matchPattern, int count, int cursor) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        int size = list.size();
        int beforeCursor = 0;
        int numElements = 0;
        int i = -1;
        for (ByteArrayWrapper value : list) {
            String key = Coder.bytesToString(value.toBytes());
            ++i;
            if (beforeCursor < cursor) {
                ++beforeCursor;
                continue;
            }
            if (numElements >= count) break;
            if (matchPattern != null) {
                if (!matchPattern.matcher(key).matches()) continue;
                returnList.add(value);
                ++numElements;
                continue;
            }
            returnList.add(value);
            ++numElements;
        }
        if (i == size - 1) {
            returnList.add(0, String.valueOf(0));
        } else {
            returnList.add(0, String.valueOf(i));
        }
        return returnList;
    }
}

