/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.validators;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.DiskStore;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.configuration.validators.ConfigurationValidator;

public class DiskStoreValidator
implements ConfigurationValidator<DiskStore> {
    @Override
    public void validate(CacheElementOperation operation, DiskStore config) throws IllegalArgumentException {
        switch (operation) {
            case CREATE: 
            case UPDATE: {
                this.checkRequiredItems(config);
                this.checkValueRanges(config);
                break;
            }
            case DELETE: {
                this.validateDelete((AbstractConfiguration)config);
            }
        }
    }

    private void validateDelete(AbstractConfiguration config) {
        if (StringUtils.isNotBlank((CharSequence)config.getGroup())) {
            throw new IllegalArgumentException("Group is an invalid option when deleting disk store.");
        }
    }

    private void checkValueRanges(DiskStore config) {
        if (config.getDiskUsageCriticalPercentage() != null) {
            DiskStoreMonitor.checkCritical(config.getDiskUsageCriticalPercentage().floatValue());
        }
        if (config.getDiskUsageWarningPercentage() != null) {
            DiskStoreMonitor.checkWarning(config.getDiskUsageWarningPercentage().floatValue());
        }
        if (config.getCompactionThreshold() != null && (0 > config.getCompactionThreshold() || config.getCompactionThreshold() > 100)) {
            throw new IllegalArgumentException("CompactionThreshold has to be set to a value between 0-100.");
        }
        if (config.getMaxOplogSizeInBytes() != null) {
            DiskStoreAttributes.checkMinOplogSize(config.getMaxOplogSizeInBytes());
        }
        if (config.getQueueSize() != null) {
            DiskStoreAttributes.checkQueueSize(config.getQueueSize());
        }
        if (config.getWriteBufferSize() != null) {
            DiskStoreAttributes.checkWriteBufferSize(config.getWriteBufferSize());
        }
        DiskStoreAttributes.verifyNonNegativeDirSize(config.getDirectories().stream().mapToInt(diskDir -> {
            if (diskDir.getDirSize() != null) {
                return diskDir.getDirSize();
            }
            return Integer.MAX_VALUE;
        }).toArray());
    }

    private void checkRequiredItems(DiskStore config) {
        if (StringUtils.isEmpty((CharSequence)config.getName())) {
            throw new IllegalArgumentException("Diskstore name is required.");
        }
        if (config.getDirectories() != null && config.getDirectories().size() > 0) {
            if (config.getDirectories().stream().anyMatch(diskDir -> StringUtils.isEmpty((CharSequence)diskDir.getName()))) {
                throw new IllegalArgumentException("Diskdir name is required.");
            }
        } else {
            throw new IllegalArgumentException("At least one DiskDir element required.");
        }
    }
}

