/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.internal.HttpService;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CacheFactoryStatics;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.AgentUtil;
import org.apache.logging.log4j.Logger;

public class RestAgent {
    private static final Logger logger = LogService.getLogger();
    private boolean running = false;
    private final DistributionConfig config;
    private final SecurityService securityService;
    private final String GEMFIRE_VERSION = GemFireVersion.getGemFireVersion();
    private AgentUtil agentUtil = new AgentUtil(this.GEMFIRE_VERSION);

    public RestAgent(DistributionConfig config, SecurityService securityService) {
        this.config = config;
        this.securityService = securityService;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void start(InternalCache cache) {
        if (!this.running && this.config.getHttpServicePort() != 0) {
            try {
                this.startHttpService(cache);
                this.running = true;
                cache.setRESTServiceRunning(true);
                RestAgent.createParameterizedQueryRegion();
            }
            catch (Throwable e) {
                logger.warn("Unable to start dev REST API: {}", (Object)e.toString());
            }
        }
    }

    private boolean isRunningInTomcat() {
        return System.getProperty("catalina.base") != null || System.getProperty("catalina.home") != null;
    }

    public void startHttpService(InternalCache cache) throws Exception {
        URI gemfireAPIWar = this.agentUtil.findWarLocation("geode-web-api");
        if (gemfireAPIWar == null) {
            logger.info("Unable to find GemFire Developer REST API WAR file; the Developer REST Interface for GemFire will not be accessible.");
        }
        if (this.isRunningInTomcat()) {
            logger.warn("Detected presence of catalina system properties. HTTP service will not be started. To enable the GemFire Developer REST API, please deploy the /geode-web-api WAR file in your application server.");
        } else if (this.agentUtil.isAnyWarFileAvailable(gemfireAPIWar)) {
            HashMap<String, Object> securityServiceAttr = new HashMap<String, Object>();
            securityServiceAttr.put("org.apache.geode.securityService", this.securityService);
            if (cache.getOptionalService(HttpService.class).isPresent()) {
                HttpService httpService = cache.getOptionalService(HttpService.class).get();
                Path gemfireAPIWarPath = Paths.get(gemfireAPIWar);
                httpService.addWebApplication("/gemfire-api", gemfireAPIWarPath, securityServiceAttr);
                httpService.addWebApplication("/geode", gemfireAPIWarPath, securityServiceAttr);
            } else {
                logger.warn("HttpService is not available - could not start Dev REST API");
            }
        }
    }

    public static String getBindAddressForHttpService(DistributionConfig config) {
        String bindAddress = config.getHttpServiceBindAddress();
        if (StringUtils.isNotBlank((CharSequence)bindAddress)) {
            return bindAddress;
        }
        bindAddress = config.getServerBindAddress();
        if (StringUtils.isNotBlank((CharSequence)bindAddress)) {
            return bindAddress;
        }
        bindAddress = config.getBindAddress();
        if (StringUtils.isNotBlank((CharSequence)bindAddress)) {
            return bindAddress;
        }
        try {
            bindAddress = LocalHostUtil.getLocalHost().getHostAddress();
            logger.info("RestAgent.getBindAddressForHttpService.localhost: " + LocalHostUtil.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            logger.error("LocalHost could not be found.", (Throwable)e);
        }
        return bindAddress;
    }

    public static void createParameterizedQueryRegion() {
        block6: {
            try {
                InternalCache cache;
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting creation of  __ParameterizedQueries__ region");
                }
                if ((cache = CacheFactoryStatics.getAnyInstance()) != null) {
                    InternalRegionFactory<String, String> factory = cache.createInternalRegionFactory(RegionShortcut.REPLICATE);
                    factory.setConcurrencyChecksEnabled(false);
                    factory.setKeyConstraint(String.class);
                    factory.setStatisticsEnabled(false);
                    factory.setValueConstraint(String.class);
                    factory.setIsUsedForMetaRegion(true);
                    factory.create("__ParameterizedQueries__");
                    if (logger.isDebugEnabled()) {
                        logger.debug("Successfully created __ParameterizedQueries__ region");
                    }
                } else {
                    logger.error("Cannot create ParameterizedQueries Region as no cache found!");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug("Error creating __ParameterizedQueries__ Region with cause {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

