/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.util.Arrays;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.distributed.internal.ResourceEvent;
import org.apache.geode.internal.cache.DiskDirSizesUnit;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.cache.backup.BackupService;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.apache.geode.internal.cache.xmlcache.DiskStoreAttributesCreation;
import org.apache.geode.pdx.internal.TypeRegistry;

public class DiskStoreFactoryImpl
implements DiskStoreFactory {
    private final InternalCache cache;
    private final DiskStoreAttributes attrs = new DiskStoreAttributes();

    public DiskStoreFactoryImpl(InternalCache cache) {
        this.cache = cache;
    }

    public DiskStoreFactoryImpl(InternalCache cache, DiskStoreAttributes attrs) {
        this.attrs.name = attrs.name;
        this.setAutoCompact(attrs.getAutoCompact());
        this.setAllowForceCompaction(attrs.getAllowForceCompaction());
        this.setCompactionThreshold(attrs.getCompactionThreshold());
        this.setMaxOplogSizeInBytes(attrs.getMaxOplogSizeInBytes());
        this.setTimeInterval(attrs.getTimeInterval());
        this.setWriteBufferSize(attrs.getWriteBufferSize());
        this.setQueueSize(attrs.getQueueSize());
        this.setDiskDirs(DiskStoreFactoryImpl.cloneArray(attrs.getDiskDirs()));
        this.setDiskDirsAndSizes(DiskStoreFactoryImpl.cloneArray(attrs.getDiskDirs()), DiskStoreFactoryImpl.cloneArray(attrs.getDiskDirSizes()));
        this.setDiskUsageWarningPercentage(attrs.getDiskUsageWarningPercentage());
        this.setDiskUsageCriticalPercentage(attrs.getDiskUsageCriticalPercentage());
        this.cache = cache;
    }

    private static File[] cloneArray(File[] o) {
        File[] result = null;
        if (o != null) {
            result = new File[o.length];
            System.arraycopy(o, 0, result, 0, o.length);
        }
        return result;
    }

    private static int[] cloneArray(int[] o) {
        int[] result = null;
        if (o != null) {
            result = new int[o.length];
            System.arraycopy(o, 0, result, 0, o.length);
        }
        return result;
    }

    @VisibleForTesting
    public DiskStoreFactory setDiskDirSizesUnit(DiskDirSizesUnit unit) {
        this.attrs.setDiskDirSizesUnit(unit);
        return this;
    }

    @Override
    public DiskStoreFactory setAutoCompact(boolean autoCompact) {
        this.attrs.autoCompact = autoCompact;
        return this;
    }

    @Override
    public DiskStoreFactory setAllowForceCompaction(boolean allowForceCompaction) {
        this.attrs.allowForceCompaction = allowForceCompaction;
        return this;
    }

    @Override
    public DiskStoreFactory setCompactionThreshold(int compactionThreshold) {
        if (compactionThreshold < 0) {
            throw new IllegalArgumentException(String.format("%s has to be positive number and the value given %s is not acceptable", "compaction-threshold", compactionThreshold));
        }
        if (compactionThreshold > 100) {
            throw new IllegalArgumentException(String.format("%s has to be a number that does not exceed %s so the value given %s is not acceptable", "compaction-threshold", compactionThreshold, 100));
        }
        this.attrs.compactionThreshold = compactionThreshold;
        return this;
    }

    @Override
    public DiskStoreFactory setTimeInterval(long timeInterval) {
        DiskStoreAttributes.checkTimeInterval(timeInterval);
        this.attrs.timeInterval = timeInterval;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskStoreImpl createOwnedByRegion(String name, boolean isOwnedByPR, InternalRegionArguments internalRegionArgs) {
        this.attrs.name = name;
        InternalCache internalCache = this.cache;
        synchronized (internalCache) {
            DiskStoreImpl ds = new DiskStoreImpl(this.cache, this.attrs, true, internalRegionArgs);
            if (isOwnedByPR) {
                this.initializeDiskStore(ds);
            }
            this.cache.addRegionOwnedDiskStore(ds);
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskStore create(String name) {
        BackupService backup;
        DiskStore result;
        this.attrs.name = name;
        InternalCache internalCache = this.cache;
        synchronized (internalCache) {
            result = this.findExisting(name);
            if (result == null) {
                if (this.cache instanceof GemFireCacheImpl) {
                    TypeRegistry registry = this.cache.getPdxRegistry();
                    DiskStoreImpl dsi = new DiskStoreImpl(this.cache, this.attrs);
                    result = dsi;
                    this.cache.getInternalDistributedSystem().handleResourceEvent(ResourceEvent.DISKSTORE_CREATE, dsi);
                    this.initializeDiskStore(dsi);
                    this.cache.addDiskStore(dsi);
                    if (registry != null) {
                        registry.creatingDiskStore(dsi);
                    }
                } else if (this.cache instanceof CacheCreation) {
                    CacheCreation creation = (CacheCreation)this.cache;
                    result = new DiskStoreAttributesCreation(this.attrs);
                    creation.addDiskStore(result);
                }
            }
        }
        if (this.cache instanceof GemFireCacheImpl && (backup = this.cache.getBackupService()) != null) {
            backup.waitForBackup();
        }
        return result;
    }

    protected void initializeDiskStore(DiskStoreImpl diskStore) {
        try {
            diskStore.doInitialRecovery();
        }
        catch (RuntimeException e) {
            diskStore.close();
            throw e;
        }
    }

    private DiskStore findExisting(String name) {
        DiskStore existing;
        if (this.cache instanceof GemFireCacheImpl && (existing = this.cache.findDiskStore(name)) != null) {
            if (((DiskStoreImpl)existing).sameAs(this.attrs)) {
                return existing;
            }
            throw new IllegalStateException("DiskStore named \"" + name + "\" already exists");
        }
        return null;
    }

    @Override
    public DiskStoreFactory setDiskDirsAndSizes(File[] diskDirs, int[] diskDirSizes) {
        if (diskDirSizes.length != diskDirs.length) {
            throw new IllegalArgumentException(String.format("Number of diskSizes is %s which is not equal to number of disk Dirs which is %s", diskDirSizes.length, diskDirs.length));
        }
        DiskStoreAttributes.verifyNonNegativeDirSize(diskDirSizes);
        DiskStoreFactoryImpl.checkIfDirectoriesExist(diskDirs);
        this.attrs.diskDirs = new File[diskDirs.length];
        System.arraycopy(diskDirs, 0, this.attrs.diskDirs, 0, diskDirs.length);
        this.attrs.diskDirSizes = new int[diskDirSizes.length];
        System.arraycopy(diskDirSizes, 0, this.attrs.diskDirSizes, 0, diskDirSizes.length);
        return this;
    }

    public static void checkIfDirectoriesExist(File[] diskDirs) {
        for (File diskDir : diskDirs) {
            if (diskDir.isDirectory() || diskDir.mkdirs()) continue;
            throw new GemFireIOException(String.format("Unable to create directory : %s", diskDir));
        }
    }

    @Override
    public DiskStoreFactory setDiskDirs(File[] diskDirs) {
        DiskStoreFactoryImpl.checkIfDirectoriesExist(diskDirs);
        int[] diskSizes = new int[diskDirs.length];
        Arrays.fill(diskSizes, Integer.MAX_VALUE);
        return this.setDiskDirsAndSizes(diskDirs, diskSizes);
    }

    @Override
    public DiskStoreFactory setMaxOplogSize(long maxOplogSize) {
        DiskStoreAttributes.checkMinAndMaxOplogSize(maxOplogSize);
        this.attrs.maxOplogSizeInBytes = maxOplogSize * 0x100000L;
        return this;
    }

    public DiskStoreFactory setMaxOplogSizeInBytes(long maxOplogSizeInBytes) {
        DiskStoreAttributes.checkMinOplogSize(maxOplogSizeInBytes);
        this.attrs.maxOplogSizeInBytes = maxOplogSizeInBytes;
        return this;
    }

    @Override
    public DiskStoreFactory setQueueSize(int queueSize) {
        DiskStoreAttributes.checkQueueSize(queueSize);
        this.attrs.queueSize = queueSize;
        return this;
    }

    @Override
    public DiskStoreFactory setWriteBufferSize(int writeBufferSize) {
        DiskStoreAttributes.checkWriteBufferSize(writeBufferSize);
        this.attrs.writeBufferSize = writeBufferSize;
        return this;
    }

    public DiskStoreAttributes getDiskStoreAttributes() {
        return this.attrs;
    }

    @Override
    public DiskStoreFactory setDiskUsageWarningPercentage(float warningPercent) {
        this.attrs.setDiskUsageWarningPercentage(warningPercent);
        return this;
    }

    @Override
    public DiskStoreFactory setDiskUsageCriticalPercentage(float criticalPercent) {
        this.attrs.setDiskUsageCriticalPercentage(criticalPercent);
        return this;
    }
}

