/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.admin.remote.Cancellable;
import org.apache.geode.internal.admin.remote.CancellationRegistry;
import org.apache.geode.internal.admin.remote.RegionAdminRequest;
import org.apache.geode.internal.admin.remote.RegionSizeResponse;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class RegionSizeRequest
extends RegionAdminRequest
implements Cancellable {
    private transient boolean cancelled;
    private transient RegionSizeResponse resp;

    public static RegionSizeRequest create() {
        RegionSizeRequest m = new RegionSizeRequest();
        return m;
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        Assert.assertTrue(this.getSender() != null);
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = RegionSizeResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.calcSize(this.getRegion(dm.getSystem()));
        if (this.cancelled) {
            return null;
        }
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    public RegionSizeRequest() {
        this.friendlyName = "Fetch region size";
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    public int getDSFID() {
        return 1045;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
    }

    @Override
    public String toString() {
        return "RegionSizeRequest from " + this.getRecipient() + " region=" + this.getRegionName();
    }
}

