/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.cq;

import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.MissingCqService;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.cache.query.internal.cq.spi.CqServiceFactory;
import org.apache.geode.internal.cache.InternalCache;

public class CqServiceProvider {
    @Immutable
    private static final CqServiceFactory factory;
    @MutableForTesting
    public static boolean MAINTAIN_KEYS;
    public static final boolean VMOTION_DURING_CQ_REGISTRATION_FLAG = false;

    public static CqService create(InternalCache cache) {
        if (factory == null) {
            return new MissingCqService();
        }
        return factory.create(cache);
    }

    public static ServerCQ readCq(DataInput in) throws ClassNotFoundException, IOException {
        if (factory == null) {
            throw new IllegalStateException("CqService is not available.");
        }
        return factory.readCqQuery(in);
    }

    private CqServiceProvider() {
    }

    static {
        MAINTAIN_KEYS = Boolean.parseBoolean(System.getProperty("gemfire.cq.MAINTAIN_KEYS", "true"));
        ServiceLoader<CqServiceFactory> loader = ServiceLoader.load(CqServiceFactory.class);
        Iterator<CqServiceFactory> itr = loader.iterator();
        if (!itr.hasNext()) {
            factory = null;
        } else {
            factory = itr.next();
            factory.initialize();
        }
    }
}

