/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.GfshCommand;
import org.apache.geode.management.internal.cli.domain.StackTracesPerMember;
import org.apache.geode.management.internal.cli.functions.GetStackTracesFunction;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExportStackTraceCommand
extends GfshCommand {
    private final GetStackTracesFunction getStackTracesFunction = new GetStackTracesFunction();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS").withZone(ZoneId.systemDefault());

    @CliCommand(value={"export stack-traces"}, help="Export the stack trace for a member or members.")
    @CliMetaData(relatedTopic={"Debug-Utility"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public ResultModel exportStackTrace(@CliOption(key={"member", "members"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="Export the stack trace for a member or members.") String[] memberNameOrId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.all.member.idOrName:disable-string-converter", help="group") String[] group, @CliOption(key={"file"}, help="Name of the file to which the stack traces will be written.") String fileName, @CliOption(key={"abort-if-file-exists"}, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="Abort the command if already exists at locator directory") boolean failIfFilePresent) throws IOException {
        File outFile;
        if (fileName == null) {
            StringBuilder filePrefix = new StringBuilder("stacktrace");
            fileName = filePrefix.append("_").append(System.currentTimeMillis()).toString();
        }
        if ((outFile = new File(fileName)).exists() && failIfFilePresent) {
            return ResultModel.createError(CliStrings.format((String)"Error occurred while exporting stack-traces, file {0} already present", (Object)outFile.getCanonicalPath()));
        }
        HashMap<String, byte[]> dumps = new HashMap<String, byte[]>();
        Set<DistributedMember> targetMembers = this.getMembers(group, memberNameOrId);
        ResultModel result = new ResultModel();
        InfoResultModel resultData = result.addInfo();
        ResultCollector<?, ?> rc = this.executeFunction((Function<?>)this.getStackTracesFunction, (Object)null, targetMembers);
        ArrayList resultList = (ArrayList)rc.getResult();
        for (Object resultObj : resultList) {
            if (!(resultObj instanceof StackTracesPerMember)) continue;
            StackTracesPerMember stackTracePerMember = (StackTracesPerMember)resultObj;
            dumps.put(this.getHeaderMessage(stackTracePerMember), stackTracePerMember.getStackTraces());
        }
        InternalDistributedSystem ads = ((InternalCache)this.getCache()).getInternalDistributedSystem();
        String filePath = this.writeStacksToFile(dumps, fileName);
        resultData.addLine(CliStrings.format((String)"stack-trace(s) exported to file: {0}", (Object)filePath));
        resultData.addLine("On host : " + ads.getDistributedMember().getHost());
        return result;
    }

    String getHeaderMessage(StackTracesPerMember stackTracesPerMember) {
        String headerMessage = stackTracesPerMember.getMemberNameOrId();
        Instant timestamp = stackTracesPerMember.getTimestamp();
        if (timestamp != null) {
            headerMessage = headerMessage + " at " + this.formatter.format(timestamp);
        }
        return headerMessage;
    }

    public String writeStacksToFile(Map<String, byte[]> dumps, String fileName) throws IOException {
        String filePath;
        File outputFile = new File(fileName);
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            PrintWriter ps = new PrintWriter(os);
            for (Map.Entry<String, byte[]> entry : dumps.entrySet()) {
                int count;
                ps.append("*** Stack-trace for member ").append(entry.getKey()).append(" ***").append(System.lineSeparator());
                ps.flush();
                GZIPInputStream zipIn = new GZIPInputStream(new ByteArrayInputStream(entry.getValue()));
                BufferedInputStream bin = new BufferedInputStream(zipIn);
                byte[] buffer = new byte[10000];
                while ((count = bin.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, count);
                }
                ps.append('\n');
            }
            ps.flush();
            filePath = outputFile.getCanonicalPath();
        }
        return filePath;
    }
}

