/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class OqlQueryRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.OQLQueryRequest, RegionAPI.OQLQueryResponse> {
    Logger logger = LogService.getLogger();

    @Override
    public Result<RegionAPI.OQLQueryResponse> process(ProtobufSerializationService serializationService, RegionAPI.OQLQueryRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, ConnectionStateException, EncodingException, DecodingException {
        String queryString = request.getQuery();
        List<BasicTypes.EncodedValue> encodedParameters = request.getBindParameterList();
        Object[] bindParameters = this.decodeBindParameters(serializationService, encodedParameters);
        try {
            Object results = messageExecutionContext.getSecureCache().query(queryString, bindParameters);
            return Success.of(this.encodeResults(serializationService, results));
        }
        catch (QueryException e) {
            this.logger.info("Query failed: " + queryString, (Throwable)e);
            return Failure.of(e);
        }
    }

    private Object[] decodeBindParameters(ProtobufSerializationService serializationService, List<BasicTypes.EncodedValue> encodedParameters) {
        Object[] bindParameters = new Object[encodedParameters.size()];
        for (int i = 0; i < encodedParameters.size(); ++i) {
            bindParameters[i] = serializationService.decode(encodedParameters.get(i));
        }
        return bindParameters;
    }

    private RegionAPI.OQLQueryResponse encodeResults(ProtobufSerializationService serializationService, Object value) throws EncodingException {
        RegionAPI.OQLQueryResponse.Builder builder = RegionAPI.OQLQueryResponse.newBuilder();
        if (!(value instanceof SelectResults)) {
            builder.setSingleResult(serializationService.encode(value));
            return builder.build();
        }
        SelectResults selectResults = (SelectResults)value;
        if (!selectResults.getCollectionType().getElementType().isStructType()) {
            BasicTypes.EncodedValueList.Builder listResult = BasicTypes.EncodedValueList.newBuilder();
            selectResults.stream().map(serializationService::encode).forEach(listResult::addElement);
            builder.setListResult(listResult);
            return builder.build();
        }
        SelectResults structResults = selectResults;
        StructType elementType = (StructType)structResults.getCollectionType().getElementType();
        BasicTypes.Table.Builder tableResult = BasicTypes.Table.newBuilder();
        tableResult.addAllFieldName(Arrays.asList(elementType.getFieldNames()));
        for (Struct row : structResults) {
            tableResult.addRow(this.encodeStruct(serializationService, row));
        }
        builder.setTableResult(tableResult);
        return builder.build();
    }

    private BasicTypes.EncodedValueList.Builder encodeStruct(ProtobufSerializationService serializationService, Struct row) throws EncodingException {
        BasicTypes.EncodedValueList.Builder structBuilder = BasicTypes.EncodedValueList.newBuilder();
        for (Object element : row.getFieldValues()) {
            structBuilder.addElement(serializationService.encode(element));
        }
        return structBuilder;
    }
}

